from typing import List, Optional, Dict, Tuple
from uuid import UUID

from edps.client.CalselectorRequest import CalselectorRequest
from edps.client.FitsFile import FitsFile
from edps.client.GraphType import GraphType
from edps.client.JobInfo import JobInfo
from edps.client.ParameterSetDTO import ParameterSetDTO
from edps.client.ProcessingRequest import ProcessingRequest
from edps.client.WorkflowDTO import WorkflowDTO
from edps.client.WorkflowStateDTO import WorkflowStateDTO
from edps.client.search import SearchFilter
from edps.generator.job import Job
from edps.generator.stateful_task import CleanupRequestArgs
from .JobsRepository import JobDetails
from .generation_result import GenerationResult
from ..generator.assoc_util import RequestType


class JobGenerator:
    def load_calibrations(self, workflow_name: str):
        raise NotImplementedError

    def classify_files(self, paths: List[str], workflow_name: str) -> List[FitsFile]:
        raise NotImplementedError

    def create_jobs(self, request: ProcessingRequest, request_type: RequestType) -> Tuple[GenerationResult, List[str], UUID]:
        raise NotImplementedError

    def cleanup_request(self, workflow_name: str, targets: List[str], cleanup_args: CleanupRequestArgs):
        raise NotImplementedError

    def get_graph(self, workflow: str, graph_type: GraphType) -> str:
        raise NotImplementedError

    def get_workflow(self, workflow_name: str) -> WorkflowDTO:
        raise NotImplementedError

    def get_workflow_state(self, workflow_name: str) -> WorkflowStateDTO:
        raise NotImplementedError

    def get_workflow_jobs(self, workflow_name: str) -> List[JobInfo]:
        raise NotImplementedError

    def get_workflow_job(self, workflow_name: str, job_id: str) -> JobInfo:
        raise NotImplementedError

    def get_assoc_map(self, workflow_name: str) -> str:
        raise NotImplementedError

    def reset_workflow(self, workflow_name: str):
        raise NotImplementedError

    def get_targets(self, workflow_name: str, targets: List[str], meta_targets: List[str]) -> str:
        raise NotImplementedError

    def get_parameter_sets(self, workflow_name: str) -> List[ParameterSetDTO]:
        raise NotImplementedError

    def get_default_params(self, workflow_name: str, task_name: str) -> Dict[str, object]:
        raise NotImplementedError

    def get_recipe_params(self, workflow_name: str, task_name: str, parameter_set: str) -> Dict[str, str]:
        raise NotImplementedError

    def remove_jobs(self, affected_jobs: List[UUID]):
        raise NotImplementedError

    def get_association_report(self, job: JobInfo) -> str:
        raise NotImplementedError

    def load_past_jobs(self, complete: List[JobDetails]):
        raise NotImplementedError

    def find_historical_job(self, job: JobInfo) -> Optional[Job]:
        raise NotImplementedError

    def expand_targets(self, search_filter: SearchFilter) -> SearchFilter:
        raise NotImplementedError

    def create_calselector_jobs(self, request: CalselectorRequest) -> Tuple[GenerationResult, List[str], UUID]:
        raise NotImplementedError
