from dataclasses import dataclass, field
from typing import List

from edps.client.JobInfo import JobInfo
from edps.client.WorkflowDTO import CalselectorJob


@dataclass
class GenerationResult:
    job_ids: List[str]
    jobs_as_info: List[JobInfo]
    files_with_no_jobs: List[str]
    incomplete_groups: List[List[str]]
    incomplete_jobs: List[JobInfo]
    calselector_jobs: List[CalselectorJob] = field(default_factory=list)

    @classmethod
    def empty(cls) -> 'GenerationResult':
        return cls(job_ids=[], jobs_as_info=[], files_with_no_jobs=[], incomplete_groups=[], incomplete_jobs=[],
                   calselector_jobs=[])
