from typing import Callable, List, Optional, Dict, Tuple
from uuid import UUID

from edps.client.FitsFile import FitsFile
from edps.client.search import SearchFilter
from edps.executor.filtering import ProductFilter
from edps.interfaces.JobsRepository import JobDetails

JobExistenceFunction = Callable[[str, List[FitsFile]], bool]


class JobsDB:
    def get_all(self) -> List[JobDetails]:
        raise NotImplementedError

    def get_job_details_simple(self, job_id: UUID, is_job_present: JobExistenceFunction) -> JobDetails:
        raise NotImplementedError

    def get_jobs_list(self, pattern: str, offset: int, limit: int) -> List[JobDetails]:
        raise NotImplementedError

    def get_jobs_list_filter_with_limits(self, search_filter: SearchFilter,
                                         start: int, end: Optional[int]) -> List[JobDetails]:
        raise NotImplementedError

    def find_complete_job(self, command: str, inputs: List[FitsFile], recipe_parameters: Dict,
                          input_filter: ProductFilter, output_filter: ProductFilter, is_job_present: JobExistenceFunction) -> UUID:
        raise NotImplementedError

    def find_associated_jobs(self, parent_jobs: List[UUID]) -> List[UUID]:
        raise NotImplementedError

    def find_children_jobs(self, parent_jobs: List[UUID]) -> Tuple[List[UUID], List[UUID]]:
        raise NotImplementedError

    def insert_multiple(self, data: List[JobDetails]):
        raise NotImplementedError

    def set_job_details(self, job_id: UUID, new_value: JobDetails):
        raise NotImplementedError

    def remove_jobs(self, job_ids: List[UUID]):
        raise NotImplementedError

    def clear(self):
        raise NotImplementedError

    def close(self):
        raise NotImplementedError
