import datetime
from threading import RLock
from typing import Dict, List


class Meter:
    def __init__(self, name: str, tags: Dict[str, str]):
        self.name = name
        self.tags = tags
        self.entries: List[float] = []
        self.lock = RLock()

    def get_and_reset(self) -> Dict:
        with self.lock:
            count = len(self.entries)
            s = sum(self.entries)
            document = {
                "@timestamp": datetime.datetime.utcnow().isoformat()[:-6] + '001Z',
                "name": self.name,
                "count": count,
                "sum": s,
                "mean": self.__avg(s, count),
                "max": max(self.entries, default=0)
            }
            document.update(self.tags)
            self.entries = []
        return document

    def __avg(self, s, count):
        return (s / count) if count != 0 else 0

    def record(self, value: float):
        self.entries.append(value)
