import argparse
from time import sleep

from edps import __version__
from edps.client.EDPSClient import EDPSClient


def main():
    parser = argparse.ArgumentParser(description=f"EDPS client version {__version__}")
    parser.add_argument("-H", "--host", help='e.g. "localhost"', default="localhost", type=str)
    parser.add_argument("-P", "--port", help='e.g. "5000"', default=5000, type=int)
    parser.add_argument("-n", "--nowait", help="Return immediately, don't wait for EDPS to close", default=False,
                        action='store_true')
    args = parser.parse_args()
    client = EDPSClient(args.host, args.port)
    client.shutdown_edps()
    if not args.nowait:
        return wait_until_cant_connect(client)


def wait_until_cant_connect(client):
    while True:
        try:
            response = client.get_jobs_list(search="RUNNING")
            if response.is_right():
                print("EDPS still running. Number of running jobs:", len(response.get()))
                sleep(1)
            else:
                print("EDPS has stopped")
                return
        except Exception as e:
            print("EDPS has stopped:", e)
            return


if __name__ == '__main__':
    main()
