# edps-dashboard (edpsgui)

## Building edpsgui

*NOTE:* this step can be skipped when installing `edpsgui` from a pre-built package.

Clone the repository:

```buildoutcfg
git clone https://gitlab.eso.org/szampier/edps-panel.git
cd edps-panel
```

Create a virtual environment and run the build module:

```buildoutcfg
python3.9 -m venv build_env
. build_env/bin/activate
pip install build
python3 -m build
```

The package is created in the `dist` directory.

## Installation

1. Create a virtual environment and activate it:

```buildoutcfg
python3.9 -m venv edpsgui_env
. edpsgui_env/bin/activate
```

2. Create a file `requirements.txt` with the following contents:

```buildoutcfg
http://dfsjenkins.hq.eso.org:8080/job/edps/job/master/lastSuccessfulBuild/artifact/dist/edps-latest.tar.gz
https://ftp.eso.org/pub/dfs/pipelines/libraries/adari-core/adari_core-0.6.0.tar.gz
https://www.eso.org/~szampier/edps/edpsgui-0.0.1.tar.gz
```

*NOTE* you can also build `edpsgui` from source as described in the [Building](#building-edpsgui) section.
In this case replace the last line of the requirements file with : `file:///path/to/edpsgui-0.0.1.tar.gz`

3. Install the required packages:

```buildoutcfg
pip install -r requirements.txt
```

## Configuration

`edpsgui` reads its configuration from `$HOME/.edps/application.properties`.

A default configuration can be created using the `edps` command line tool.

### Additional configurations (env. variables)
- `EDPSGUI_INPUT_DIR`: used by the file selector as top-level directory to browse (default `/`)
- `EDPSGUI_FITS_VIEWER` : path to fits viewer (default `fv`)

## Running edpsgui

- Activate the environment: `. edpsgui_env/bin/activate`
- Run: `edpsgui`

## Stopping edpsgui

- Type Ctrl-C in the terminal where edpsgui is running
