import panel as pn
import param
from panel.viewable import Viewer, Viewable

from edpsgui.domain.edpsw import EDPSWrapper


def get_edps() -> EDPSWrapper:
    EDPS = 'edps'
    if EDPS not in pn.state.cache:
        pn.state.cache[EDPS] = EDPSWrapper()
    return pn.state.cache[EDPS]


class EDPSControl(Viewer):
    edps_status = param.Boolean()

    def __init__(self, **params):
        self.edps: EDPSWrapper = get_edps()
        self.start_btn = pn.widgets.Button(button_style='solid', align='center', sizing_mode='scale_height')
        if self.edps.is_running():
            self.set_edps_started()
        else:
            self.set_edps_stopped()
        pn.bind(self.start_edps, self.start_btn, watch=True)
        super().__init__(**params)

    def set_edps_started(self):
        self.start_btn.name = 'Stop EDPS'
        self.start_btn.button_type = 'danger'
        self.start_btn.icon = 'player-stop-filled'
        self.edps_status = True

    def set_edps_stopped(self):
        self.start_btn.name = 'Start EDPS'
        self.start_btn.button_type = 'success'
        self.start_btn.icon = 'player-play-filled'
        self.edps_status = False

    def start_edps(self, event):
        with self.start_btn.param.update(loading=True, disabled=True):
            if self.edps.is_running():
                self.edps.stop()
                self.set_edps_stopped()
            else:
                self.edps.start()
                self.set_edps_started()

    def __panel__(self) -> Viewable:
        return self.start_btn
