import os

import panel as pn
import param
from panel.viewable import Viewer, Viewable


class InputSelector(Viewer):
    inputs = param.ListSelector(default=[])

    def __init__(self, **params):
        super().__init__(**params)
        base_dir = os.environ.get('EDPSGUI_INPUT_DIR') or '/'
        self.inputs = pn.state.cache.get('inputs', [])
        self.file_selector = pn.widgets.FileSelector.from_param(self.param.inputs, directory=base_dir,
                                                                root_directory='/',
                                                                show_hidden=True)
        self.file_selector.param.watch(lambda event: pn.state.cache.update({'inputs': event.new}), 'value')
        self.layout = self.create_layout()

    @pn.depends('inputs')
    def selected_inputs(self):
        return '\n'.join([f'- {inp}' for inp in self.inputs])

    def open_modal(self, event):
        modal_content = pn.Column(pn.Spacer(height=20),
                                  pn.pane.Markdown("### Select Inputs"),
                                  self.file_selector, width=800)
        modal = pn.Modal(modal_content)
        self.layout.pop(-1)
        self.layout.append(modal)
        modal.open = True

    def create_layout(self) -> pn.Row:
        input_btn = pn.widgets.Button(name='Select Inputs', button_type='primary', align='start')
        input_btn.on_click(self.open_modal)
        return pn.Row(
            input_btn,
            pn.Column(self.selected_inputs, height=150, scroll=True),
            pn.Spacer()  # This is a placeholder!
        )

    def __panel__(self) -> Viewable:
        return self.layout
