import panel as pn
import param
from panel.viewable import Viewer, Viewable

from edpsgui import pipeline_by_workflow
from .edps_ctl import get_edps


class WorkflowSelector(Viewer):
    edps_status = param.Boolean(default=None, allow_refs=True)
    workflow = param.Selector()

    def __init__(self, **params):
        super().__init__(**params)
        self.edps = get_edps()
        self.workflow = pn.state.cache.get('workflow')

        stylesheet = """
        .bk-input {
            font-size: 18px;
            color: #FFD700;
        }
        """
        self.workflow_selector = pn.widgets.Select.from_param(self.param.workflow, options=self.get_workflows,
                                                              name='Workflow', width=250, stylesheets=[stylesheet])
        self.workflow_selector.param.watch(self.on_value_changed, 'value')

    def on_value_changed(self, event):
        if event:
            pn.state.cache.update({'workflow': event.new})

    @pn.depends('edps_status')
    def get_workflows(self):
        if self.edps_status:
            workflows = sorted(self.edps.workflows())
            return workflows
        else:
            return []

    @pn.depends('edps_status', 'workflow')
    def pipeline_version(self):
        pipeline = ''
        if self.edps_status and self.workflow:
            workflow = self.workflow.split('.')[0]
            pipe_id = pipeline_by_workflow.get(workflow, workflow)
            pipe_version = [p for p in self.edps.get_installed_pipelines() if p.startswith(pipe_id)]
            pipeline = pipe_version[0] if pipe_version else 'Unknown'
        return pn.pane.HTML(f'<font size="3">Pipeline<br>{pipeline}</font>')

    def __panel__(self) -> Viewable:
        return pn.Row(self.workflow_selector, self.pipeline_version)
