import panel as pn
import param
from panel.viewable import Viewer, Viewable


class StatusBar(Viewer):
    workflow = param.String(default=None, allow_refs=True)
    inputs = param.List(default=None, allow_refs=True)
    meta_target = param.String(default=None, allow_refs=True)
    targets = param.List(default=None, allow_refs=True)

    def __panel__(self) -> Viewable:
        workflow_text = pn.widgets.StaticText.from_param(self.param.workflow, name='Workflow')
        targets_text = pn.widgets.StaticText.from_param(self.param.targets, name='Targets', width=400)
        inputs_text = pn.widgets.StaticText.from_param(self.param.inputs, name='Inputs', width=400)
        return pn.Row(
            workflow_text,
            targets_text,
            inputs_text,
        )
