import os

from starlette.status import HTTP_404_NOT_FOUND
from tornado.web import RequestHandler


class PdfHandler(RequestHandler):
    def get(self):
        graph_dir = os.getenv('EDPSGUI_GRAPH_DIR', '.')
        basename = self.get_argument('file')
        filename = os.path.join(graph_dir, basename)
        if not basename or '/' in basename or not os.path.exists(filename):
            self.set_status(HTTP_404_NOT_FOUND)
            self.finish()
        else:
            self.set_header('Content-Type', 'application/pdf')
            with open(filename, 'rb') as f:
                self.write(f.read())


ROUTES = [('/pdf', PdfHandler, {})]
