
# TELLURICCORR_SET_PREFIX(PREFIX)
#---------------------------
AC_DEFUN([TELLURICCORR_SET_PREFIX],
[
    unset CDPATH
    # make $PIPE_HOME the default for the installation
    AC_PREFIX_DEFAULT($1)

    if test "x$prefix" = "xNONE"; then
        prefix=$ac_default_prefix
        ac_configure_args="$ac_configure_args --prefix $prefix"
    fi

    if test "x$exec_prefix" = "xNONE"; then
        exec_prefix=$prefix
    fi

])

# TELLURICCORR_SET_VERSION_INFO(VERSION, [CURRENT], [REVISION], [AGE])
#----------------------------------------------------------------
# Setup various version information, especially the libtool versioning
AC_DEFUN([TELLURICCORR_SET_VERSION_INFO],
[
    telluriccorr_version=`echo "$1" | sed -e 's/[[a-z,A-Z]].*$//'`

    telluriccorr_major_version=`echo "$telluriccorr_version" | \
        sed 's/\([[0-9]]*\).\(.*\)/\1/'`
    telluriccorr_minor_version=`echo "$telluriccorr_version" | \
        sed 's/\([[0-9]]*\).\([[0-9]]*\)\(.*\)/\2/'`
    telluriccorr_micro_version=`echo "$telluriccorr_version" | \
        sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\3/'`

    if test -z "$telluriccorr_major_version"; then telluriccorr_major_version=0
    fi

    if test -z "$telluriccorr_minor_version"; then telluriccorr_minor_version=0
    fi

    if test -z "$telluriccorr_micro_version"; then telluriccorr_micro_version=0
    fi

    TELLURICCORR_VERSION="$telluriccorr_version"
    TELLURICCORR_MAJOR_VERSION=$telluriccorr_major_version
    TELLURICCORR_MINOR_VERSION=$telluriccorr_minor_version
    TELLURICCORR_MICRO_VERSION=$telluriccorr_micro_version

    if test -z "$4"; then TELLURICCORR_INTERFACE_AGE=0
    else TELLURICCORR_INTERFACE_AGE="$4"
    fi

    TELLURICCORR_BINARY_AGE=`expr 100 '*' $TELLURICCORR_MINOR_VERSION + $TELLURICCORR_MICRO_VERSION`
    TELLURICCORR_BINARY_VERSION=`expr 10000 '*' $TELLURICCORR_MAJOR_VERSION + \
                          $TELLURICCORR_BINARY_AGE`

    AC_SUBST(TELLURICCORR_VERSION)
    AC_SUBST(TELLURICCORR_MAJOR_VERSION)
    AC_SUBST(TELLURICCORR_MINOR_VERSION)
    AC_SUBST(TELLURICCORR_MICRO_VERSION)
    AC_SUBST(TELLURICCORR_INTERFACE_AGE)
    AC_SUBST(TELLURICCORR_BINARY_VERSION)
    AC_SUBST(TELLURICCORR_BINARY_AGE)

    AC_DEFINE_UNQUOTED(TELLURICCORR_MAJOR_VERSION, $TELLURICCORR_MAJOR_VERSION,
                       [TELLURICCORR major version number])
    AC_DEFINE_UNQUOTED(TELLURICCORR_MINOR_VERSION, $TELLURICCORR_MINOR_VERSION,
                       [TELLURICCORR minor version number])
    AC_DEFINE_UNQUOTED(TELLURICCORR_MICRO_VERSION, $TELLURICCORR_MICRO_VERSION,
                       [TELLURICCORR micro version number])
    AC_DEFINE_UNQUOTED(TELLURICCORR_INTERFACE_AGE, $TELLURICCORR_INTERFACE_AGE,
                       [TELLURICCORR interface age])
    AC_DEFINE_UNQUOTED(TELLURICCORR_BINARY_VERSION, $TELLURICCORR_BINARY_VERSION,
                       [TELLURICCORR binary version number])
    AC_DEFINE_UNQUOTED(TELLURICCORR_BINARY_AGE, $TELLURICCORR_BINARY_AGE,
                       [TELLURICCORR binary age])

    ESO_SET_LIBRARY_VERSION([$2], [$3], [$4])
])


# TELLURICCORR_SET_PATHS
#------------------
# Define auxiliary directories of the installed directory tree.
AC_DEFUN([TELLURICCORR_SET_PATHS],
[

    if test -z "$plugindir"; then
        plugindir='${libdir}/esopipes-plugins/${PACKAGE}-${VERSION}'
    fi

    if test -z "$privatelibdir"; then
        privatelibdir='${libdir}/${PACKAGE}-${VERSION}'
    fi

    if test -z "$apidocdir"; then
        apidocdir='${datadir}/doc/${PACKAGE}-${VERSION}/html'
    fi

    if test -z "$pipedocsdir"; then
        pipedocsdir='${datadir}/doc/${PACKAGE}-${VERSION}'
    fi

    if test -z "$configdir"; then
       configdir='${datadir}/${PACKAGE}/config'
    fi

    if test -z "$wkfextradir"; then
        wkfextradir='${datadir}/esopipes/${PACKAGE}-${VERSION}/reflex'
    fi

    if test -z "$wkfcopydir"; then
        wkfcopydir='${datadir}/reflex/workflows/${PACKAGE}-${VERSION}'
    fi

    AC_SUBST(plugindir)
    AC_SUBST(privatelibdir)
    AC_SUBST(apidocdir)
    AC_SUBST(pipedocsdir)
    AC_SUBST(configdir)
    AC_SUBST(wkfextradir)
    AC_SUBST(wkfcopydir)


    # Define a preprocesor symbol for the plugin search paths

    AC_DEFINE_UNQUOTED(TELLURICCORR_PLUGIN_DIR, "${PACKAGE}/plugins",
                       [Plugin directory tree prefix])

    eval plugin_dir="$plugindir"
    plugin_path=`eval echo $plugin_dir | \
                sed -e "s/\/${PACKAGE}-${VERSION}.*$//"`

    AC_DEFINE_UNQUOTED(TELLURICCORR_PLUGIN_PATH, "$plugin_path",
                       [Absolute path to the plugin directory tree])

])


# TELLURICCORR_CREATE_SYMBOLS
#-----------------------
# Define include and library related makefile symbols
AC_DEFUN([TELLURICCORR_CREATE_SYMBOLS],
[

    # Symbols for package include file and library search paths

    TELLURICCORR_INCLUDES='-I$(top_srcdir)/telluriccorr'
    TELLURICCORR_LDFLAGS='-L$(top_builddir)/telluriccorr'

    # Library aliases

    LIBTELLURICCORR='$(top_builddir)/src/libtelluriccorr.la'

    # Substitute the defined symbols

    AC_SUBST(TELLURICCORR_INCLUDES)
    AC_SUBST(TELLURICCORR_LDFLAGS)

    AC_SUBST(LIBTELLURICCORR)

    # Check for CPL and user defined libraries
    AC_REQUIRE([ESO_CHECK_CPL])

    all_includes='$(TELLURICCORR_INCLUDES) $(HDRL_INCLUDES) $(CPL_INCLUDES)'
    all_ldflags='$(TELLURICCORR_LDFLAGS) $(HDRL_LDFLAGS) $(CPL_LDFLAGS)'

    AC_SUBST(all_includes)
    AC_SUBST(all_ldflags)
])
