/*
 * This file is part of the ESO Telluric Correction Library
 * Copyright (C) 2001-2018 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef MF_WRAP_H
#define MF_WRAP_H

/*----------------------------------------------------------------------------*/
/**
 *                              Includes
 */
/*----------------------------------------------------------------------------*/

#include <cpl.h>

//#include <telluriccorr.h>
/*#include <mf_wrap_fits.h>
#include <mf_wrap_data.h>
#include <mf_wrap_dfs.h>*/

#include "mf_wrap_utils.h"
#include "mf_wrap_config.h"


//#include "mf_constants.h" //?
//#include "mf_configuration.h"

CPL_BEGIN_DECLS

/*----------------------------------------------------------------------------*/
/**
 *                 Typedefs: Enumeration types
 */
/*----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/**
 *                 Defines
 */
/*----------------------------------------------------------------------------*/

#define RECIPE_NAME MOLECFIT_MODEL
#define CONTEXT     "molecfit." RECIPE_NAME

/*----------------------------------------------------------------------------*/
/**
 *                 Global variables
 */
/*----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/**
 *                 Macros
 */
/*----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/**
 *                 Typedefs: Structured types
 */
/*----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------*/
/**
 *                 Functions prototypes
 */
/*----------------------------------------------------------------------------*/
cpl_error_code set_output_filename_suffix(const char *suffix, cpl_parameterlist *parlist);

cpl_error_code map_tags_to_mf_wrap(cpl_frameset *frameset, const char *tags);

__attribute__((unused)) cpl_error_code mf_wrap_model_data(const char *fname, mf_wrap_fits *data);

cpl_error_code mf_wrap_data_check(
    mf_wrap_fits            *data,
    const cpl_parameterlist *parlist,
    mf_wrap_model_parameter *parameters,
    const cpl_boolean       *use_only_input_pri_ext
);

cpl_table *mf_wrap_molecules(
    cpl_frameset            *frameset,
    mf_wrap_fits            *data,
    const cpl_parameterlist *parlist,
    mf_wrap_model_parameter *parameters,
    const char              *suffix
);

cpl_error_code mf_wrap_wranges(
    cpl_frameset            *frameset,
    mf_wrap_fits            *data,
    const cpl_parameterlist *parlist,
    mf_wrap_model_parameter *parameters,
    cpl_table              **inc_wranges,
    cpl_table              **exc_wranges,
    cpl_table              **exc_pranges,
    const char              *suffix
);

cpl_error_code mf_wrap_kernel(
    cpl_frameset            *frameset,
    mf_wrap_model_parameter *parameters,
    mf_wrap_fits           **kernel_data,
    cpl_table              **mapping_kernel,
    const char              *suffix
);

cpl_error_code
mf_wrap_gdas(cpl_frameset *frameset, mf_wrap_model_parameter *parameters, cpl_table **gdas_user, const char *suffix);

cpl_error_code mf_wrap_atm(
    cpl_frameset *frameset,
    ///const cpl_parameterlist *parlist,
    mf_wrap_model_parameter *parameters,
    cpl_table              **atm_profile_standard,
    const char              *suffix
);

cpl_error_code mf_gdas_write(
    mf_model_results        *results,
    const cpl_parameterlist *parlist,
    const cpl_table         *gdas_user,
    cpl_frameset            *frameset,
    mf_wrap_model_parameter *parameters,
    mf_wrap_fits            *data,
    const char              *suffix
);  // FLESH THIS OUT

cpl_error_code mf_atm_write(
    mf_model_results        *results,
    const cpl_parameterlist *parlist,
    cpl_frameset            *frameset,
    mf_wrap_model_parameter *parameters,
    mf_wrap_fits            *data,
    cpl_table               *atm_profile_standard,
    const char              *suffix
);
//cpl_table *atm_profile_combined); // FLESH THIS OUT

cpl_table *mf_wrap_model_amalgamate_ranges_table(
    cpl_table  *inc_wranges_ext_table,
    const char *wave_include_str,
    const char *map_regions_str,
    const char *inp_fit_continuum_str,
    const char *continuum_n_str,
    const char *inp_fit_wlc_str,
    int         nchips,
    double      wlg2mn
);

int mf_wrap_parsReadDValsFromString(const char *str, double *vec, int vsize, int max_strlen);

int mf_wrap_parsReadIValsFromString(const char *str, int *vec, int vsize, int max_strlen);


// mf_wrap_sciframe(cpl_frameset *frameset, const cpl_parameterlist  *parlist, mf_wrap_model_parameter *parameters); // DO WE NEED THIS ??


CPL_END_DECLS


#endif /* MF_WRAP_H */
