/*
 * This file is part of the ESO Telluric Correction Library
 * Copyright (C) 2001-2018 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef MF_WRAP_CONFIG_CORR_H
#define MF_WRAP_CONFIG_CORR_H

/*----------------------------------------------------------------------------*/
/**
 *                              Includes
 */
/*----------------------------------------------------------------------------*/

#include <cpl.h>

//#include <telluriccorr.h>
#include <mf_wrap_fits.h>
/*
#include <mf_wrap_data.h>
#include <mf_wrap_dfs.h>*/

#include <mf_wrap_utils.h>
#include <mf_wrap_config.h>
//#include <telluriccorr.h>
//#include "mf_calctrans_lblrtm_results.h"

//#include "mf_constants.h" //?
//#include "mf_configuration.h"

CPL_BEGIN_DECLS

/*----------------------------------------------------------------------------*/
/**
 *                 Typedefs: Enumeration types
 */
/*----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/**
 *                 Defines
 */
/*----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------*/
/**
 *                 Global variables
 */
/*----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/**
 *                 Macros
 */
/*----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/**
 *                 Typedefs: Structured types
 */
/*----------------------------------------------------------------------------*/

typedef struct
{
    cpl_boolean
        use_only_input_pri_ext; /* If the user want to use only the SCIENCE_CALCTRANS/SCIENCE input FITS primary extension                                                            */
    int dflux_extension_data; /* If use_only_input_pri_ext == CPL_TRUE, you can provide a extension as DFLUX (error flux)                                                           */
    int mask_extension_data; /* If use_only_input_pri_ext == CPL_TRUE, you can provide a extension as MASK                                                                         */

    cpl_boolean
        suppress_extension; /* Suppress arbitrary filename extension and change for numbers : [INPUT_NAME_1] => [OUTPUT_PRODUCT_1]_1 , ... [INPUT_NAME_N] => [OUTPUT_PRODUCT_N]_N */

    const char *
        mapping_correct; /* Mapping extensions : inputs-telluric_corr,   i.e. {input_ext1-telluric_corr_ext,     ..., input_extN-telluric_corr_ext} int                        */
    cpl_table *
        mapping_correct_table; /* Mapping telluric_corr extensions cpl_table. Contains 1 columns [TELLURIC_CORR_EXT]                                                                 */

    cpl_table *fit_model_table; /* TELLURIC_CORR */

    /* Telluric correction + column parameters */
    mf_wrap_fits *
        telluric_corr; /* cpl_table's in the TELLURIC_CORR (output of molecfit_calctrans)                                                                                    */
    const char *
        column_lambda; /* TELURIC_CORR molecfit parameter header : MF_PARAMETERS_COLUMN_LAMBDA                                                                               */
    const char *
        column_flux; /* TELURIC_CORR molecfit parameter header : MF_PARAMETERS_COLUMN_FLUX                                                                                 */
    const char *
        column_dflux; /* TELURIC_CORR molecfit parameter header : MF_PARAMETERS_COLUMN_DFLUX                                                                                */
    const char *
        column_mask; /* TELURIC_CORR molecfit parameter header : MF_PARAMETERS_COLUMN_MASK                                                                                 */

    cpl_boolean chip_extensions; /* If the user want to combine the input FITS extensions  */
    const char *
        wlc_ref; /* TELURIC_CORR molecfit parameter header : MF_PARAMETERS_WAVELENGTH_FRAME                                                                                  */
    const char *
        wavelength_frame; /* TELURIC_CORR molecfit parameter header : MF_PARAMETERS_OBSERVATORY_ERF_RV_VALUE                                                                                 */
    double observing_erv_rv_value; /* values for observing_erv_rv.value */

    cpl_propertylist *
        pl; /* All input parameters to save in the output files                                                                                                   */


} mf_wrap_correct_parameter;

/*----------------------------------------------------------------------------*/
/**
 *                 Functions prototypes
 */
/*----------------------------------------------------------------------------*/


/* Fill the internal Molecfit configuration file */
//molecfit_correct_parameter * molecfit_correct_parameters(
//    const cpl_frameset               *frameset,
//    const cpl_parameterlist          *list);
//
/* Clean variables allocated in the recipe */
void mf_wrap_correct_parameter_delete(mf_wrap_correct_parameter *parameters);

mf_wrap_correct_parameter *
mf_wrap_config_corr_init(cpl_frameset *frameset, const cpl_parameterlist *list, const char *arm);


CPL_END_DECLS


#endif /* MF_WRAP_CONFIG_CORR_H */
