import os.path

import pandas as pd
import panel as pn
import param
from panel.viewable import Viewer, Viewable

from edpsgui.domain.utils import get_fits_header


class HeaderViewer(Viewer):
    filename = param.String(allow_refs=True)
    hdu = param.Selector(allow_refs=True)

    def __init__(self, **params):
        super().__init__(**params)
        self.header_button = pn.widgets.Button(name=f'Display Header #{self.hdu}', button_type='primary',
                                               disabled=self.file_not_exists)

    @pn.depends('filename')
    def file_not_exists(self):
        return not self.filename or not os.path.exists(self.filename)

    @pn.depends('hdu', watch=True)
    def update_button_name(self):
        self.header_button.name = f'Display Header #{self.hdu}'

    def header(self, event):
        if not event:
            return
        with self.header_button.param.update(loading=True, disabled=True):
            header = get_fits_header(self.filename, self.hdu)
            header_df = pd.DataFrame(
                [(key, value) for key, value in header.items() if len(key) > 0],
                columns=['Keyword', 'Value']
            )
            return pn.widgets.Tabulator(header_df, show_index=False, header_filters=True, disabled=True,
                                        pagination='local', page_size=50)

    def __panel__(self) -> Viewable:
        layout = pn.Column(
            self.header_button,
            pn.bind(self.header, self.header_button),
            height=600
        )
        return layout
