START_EDPS = """
**Start EDPS**
Start the EDPS (ESO Data Processing System) server. The EDPS server
should always be running for this GUI to work.
"""

STOP_EDPS = """
**Stop EDPS**
The EDPS server should only be stopped in case of a problem that is
likely to be caused by the server. The EDPS must then be re-started
before the GUI can be used again.
"""

START_STOP_EDPS = f"""
{START_EDPS}
{STOP_EDPS}
"""

SELECT_WORKFLOW = """
**Workflow**
Select the workflow for the data to be processed.
Only data that correspond to the selected workflow will be processed.
"""

TOPBAR_TOOLTIP = f"""
{START_STOP_EDPS}
{SELECT_WORKFLOW}
"""

SELECT_INPUT_DATA = """
**Select inputs**
Select the input files to be processed.
The selected data must correspond to the selected workflow.
"""

INSPECT_INPUT_DATA = """
**Inspect inputs**
Inspect the selected input files. All data that are recognized by the selected 
workflows will categorized and listed. 
"""

SELECT_TARGET = """
**Select target**
Select the task(s) that produce the output you want to obtain. By default, all 
tasks that produce output useful for science are pre-selected.
"""

CONFIGURE_ASSOCIATION = """
**Configure association**
Configure how calibration data are selected. The default configuration selects
unprocessed raw calibrations for re-processing if possible, and uses 
calibration data of any quality. 
"""

CREATE_DATASETS = """
**Create datasets**
Identify the science data among the selected input files, and
list them together with the necessary calibration files to process
them. Datasets that include all necessary files for processing 
will be marked as "complete". 
"""

SAVE_COMMENT = """
**Save**
Update the comment for the current dataset configuration.
"""

COPY_COMMENT = """
**Copy**
Apply this comment to the selected configurations. You can choose to _append_ it to the existing comment or _replace_ the current one entirely.
"""

COMMENT_TOOLTIP = f"""
{SAVE_COMMENT}
{COPY_COMMENT}
"""

SAVE_CONFIGURATION = """
**Save**
Save the current configuration. Only unprocessed (NEW) configurations can be modified.
"""

SAVE_AS_NEW_CONFIGURATION = """
**Save as new**
Create a new configuration based on the current one.
Once saved, you can edit it without affecting the original.
"""

COPY_CONFIGURATION = """
**Copy**
Apply the current configuration’s parameters to the selected configurations.
If a configuration has already been processed, it cannot be changed. Instead, a new version will be created.
"""

CONFIGURATION_TOOLTIP = f"""
{SAVE_CONFIGURATION}
{SAVE_AS_NEW_CONFIGURATION}
{COPY_CONFIGURATION}
"""

REDUCE_DATA = """
**Processing queue**
This section shows all datasets ready to be processed. A reduction can be 
configured and/or submitted for processing. If a previously completed reduction 
exists, it can be used to configure a new reduction.
"""

MONITOR_REDUCTION = """
**Processing monitor**
This section shows the state of submitted processing requests.
"""

EXPORT_DATA = """
**Archived data**
This section lists all datasets that have been completely processed and 
marked as to be archived in the "Processing Queue" tab. From here, the results 
can be exported using human-readable file names. 
"""
