import os.path

import panel as pn
import param
from panel.viewable import Viewer, Viewable

from edpsgui.domain.utils import get_fits_info_old


class HDUSelector(Viewer):
    filename = param.String(allow_refs=True)
    hdu = param.Selector(objects=[0], label='Select HDU')

    def __init__(self, **params):
        super().__init__(**params)

    @pn.depends('filename')
    def info(self):
        if not self.filename:
            return pn.pane.Markdown('No file selected')
        elif not os.path.exists(self.filename):
            msg = f'File {self.filename} does not exist'
            return pn.pane.Markdown(f'<span style="color:red">{msg}</span>')
        else:
            self.hdu = 0
            info, num_hdus = get_fits_info_old(self.filename)
            self.param.hdu.objects = list(range(num_hdus))
            return pn.pane.Str(info)

    def __panel__(self) -> Viewable:
        hdu_selector = pn.widgets.Select.from_param(self.param.hdu, width=200)
        layout = pn.Column(
            self.info,
            hdu_selector,
        )
        return layout
