import os
import subprocess

from astropy.samp import SAMPIntegratedClient


def send_image_to_samp(file_name: str):
    client = SAMPIntegratedClient()
    client.connect()
    message = {"samp.mtype": "image.load.fits",
               "samp.params": {"url": f"file://{file_name}"}}
    client.notify_all(message)
    client.disconnect()


def open_file_in_fv(file_name: str):
    fv = os.environ.get('EDPSGUI_FITS_VIEWER') or 'fv'
    proc = subprocess.Popen(args=[fv, file_name],
                            start_new_session=True,
                            stdout=subprocess.DEVNULL,
                            stderr=subprocess.DEVNULL)
