import panel as pn

from edpsgui.domain.reduction_repository import Reduction


def reduction_summary_viewer(r: Reduction, status: str) -> pn.pane.Markdown:
    css = """
    table, th, td {
      border: none;
      font-size: 14px;
      text-align: left;
    }
    """
    return pn.pane.Markdown(f"""
    | Dataset     | Reduction     | Workflow     | Target     | Completed     | Archived    | Status   | 
    | ----------- | ------------- | ------------ | ---------- | ------------- | ----------- | -------- |
    | {r.dataset} | {r.timestamp} | {r.workflow} | {r.target} | {r.completed} | {r.archived}| {status} |
    """, stylesheets=[css])
