import panel as pn
import param
from panel.viewable import Viewer, Viewable

from edpsgui.gui.edps_ctl import get_edps
from edpsgui.gui.job_table import JobTable


class JobBrowser(Viewer):
    edps_status = param.Boolean(default=None, allow_refs=True)

    def __init__(self, **params):
        super().__init__(**params)
        self.edps = get_edps()
        self.search_btn = pn.widgets.Button(name='Search Jobs', button_type='primary', disabled=self.edps_not_running)
        self.search_btn.on_click(self.get_jobs)
        self.delete_btn = pn.widgets.Button(name='Delete All Jobs', button_type='danger',
                                            disabled=self.edps_not_running)
        self.delete_btn.on_click(self.delete_all_jobs)
        self.job_table = JobTable()

    @pn.depends('edps_status')
    def edps_not_running(self):
        return not self.edps.is_running()

    def get_jobs(self, event):
        with self.search_btn.param.update(loading=True, disabled=True):
            self.job_table.jobs = self.edps.get_jobs()

    def delete_all_jobs(self, event):
        with self.delete_btn.param.update(loading=True, disabled=True):
            self.edps.delete_all_jobs()
            self.get_jobs(True)

    def __panel__(self) -> Viewable:
        return pn.Column(
            pn.Row(self.search_btn, self.delete_btn),
            self.job_table
        )
