# Change Log

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).


## 1.0.3

### Added
- Added method `pyesorex.parameter.Parameter.to_cplui()` for future use.

### Changed
- Allow for explicit initialization of the parameter presence flag on parameter instantiation. Added keyword argument `presence` parameter constructors. (!34)
- Added keyword argument `modified_only` with default value `True` to `pyesorex.parameter.ParameterList.as_dict()`. (!34)
- Pass only parameters which were explicitly set to a recipe implementation in method `pyesorex.pyesorex.Pyesorex.run()`. Parameters are considered as explicitly set if their parameter presence flag is `True`. See PIPE-12262. (!34)


## 1.0.2

### Added
- Add error location summary to terminal output when *PyEsoRex* exits with an error. See PIPE-12194. (pyesorex!26)
- Add tests for parameterless recipes. (pyesorex!18)

### Changed
- For compatibility with EsoRex support writing configuration files without file name extension. See PIPE-11927. (pyesorex!27)
- Make parsing the arguments to the command line option `--create-config` compatible with EsoRex, i.e. `--create-config=<filename> <recipename>` saves the recipe configuration and not the *PyEsoRex* configuration. See PIPE-12193. (pyesorex!29)

### Fixed
- Fixed failing `pyesorex -man-page` when run through `subprocess.run`. See PIPE-12174. (pyesorex!23)
- Fixed handling of recipes which do not have parameters. See PIPE-12044. (pyesorex!18, pyesorex!19, pyesorex!22)
- Fixed recipe man page not displayed due to a `TypeError` exception occurring for non-string type enumeration parameters. See PIPE-12006. (pyesorex!20)


## 1.0.1

### Added
- Add command line option `show-products` to the `pyesorex` command line tool controlling the display of the result `cpl.ui.FrameSet` returned by the `Pyesorex.run()` method. (pyesorex!10)

### Changed
- Use `shutils.move` to be able to move data products across file-system boundaries. (pyesorex!13)
- Follow symbolic links in `pyesorex.pyesorex.Pyesorex.get_python_recipes()` when looking for recipes. (pyesorex!9)
- Perform tilde expansion on `recipe-dir` command line option argument. (pyesorex!8)

### Fixed
- Fixed incorrect log message components in `pyesorex.pyesorex.Pyesorex.get_python_recipes()`. (pyesorex!6)


## 1.0.0

### Added
- Support for in-memory sof handling in PyEsoRex. Can assign iterable containing `cpl.ui.Frame` objects via sof setter. Backwards compatible with sof_location setter. (pycpl!160)
- Provide package version attribute `pyesorex.__version__`. (pyesorex!1)

### Changed
- PyEsoRex moved to a separate GitLab repo.
- Build system modernized: switch to a PEP-517 compliant build system replacing
the obsolete `setup.py` by `pyproject.toml` and `setup.cfg`. (pyesorex!1)
- Building packages uses the `pyesorex.__version__` attribute to dynamically
determine and set the package version. (pyesorex!1)

### Fixed
- Fixed code style in most Python files (pycpl!157)


## 0.9.0

### Added
- New PyEsoRex options/parameters:
  * `--params` command line option and `Pyesorex.get_params_text()` method. (pycpl!129)
  * `--help [recipe name]` and `--man-page [recipe name]` command line options added, along with a rework of their associated doc functions now properly printing the parameters. (pycpl!130)
  * `--time` option and parameter. (pycpl!133)
  * JSON format support for `--config` and `--create-config` options, and `read_config()`, `read_recipe_config()`, `write_config()` and `write_recipe_config()` methods. (pycpl!132)
  * `--products-sof` option and corresponding `write_sof()` method, and new `--products-sof-abspaths` option. (pycpl!132)
  * `--link-dir` and `--suppress-link` options and parameters, and `link_dir` property. (pycpl!138)

### Changed
- PyEsoRex now uses `cpl.ui.CRecipe.recipe_dir` to set the default value for the recipe directory. (pycpl!132)
- The pyesorex CLI will no longer display Python Tracebacks in the terminal, a short human readable message will be displayed instead. Tracebacks will be added to the log if log level is debug. (pycpl!138)
- Pyesorex now defers validation of output and link directories until recipe run time (which means `ouput_mkdir` can be set at any time), and will apply settings from `PYESOREX_CONFIG` before any other environment variable settings. (pycpl!138)

### Fixed
- PyEsoRex bug always using compile-time directory when searching for recipes is fixed (pycpl!145)
- Removed an errant `print()` from PyEsoRex. (pycpl!146)


## 0.4.0

### Added
- New PyEsoRex options/parameters:
  * `--output-dir` command line option, `output_dir` parameter and Pyesorex property, with input validation. (pycpl!119)
  * `--output-mkdir` command line option & parameter. (pycpl!119)
  * `--output-prefix` and `--suppress-prefix` command line options & parameters. (pycpl!119)


## 0.3.1

### Changed
- Updated outdated PyEsoRex help text (see https://jira.eso.org/browse/PIPE-10045, pycpl!115)

### Fixed
- Fixed critical PyEsoRex bugs
  * PyEsoRex would raise a `FileNotFoundError` exception if started when no config file existed at the default location `~/.pyesorex/pyesorex.rc` (see https://jira.eso.org/browse/PIPE-10045, pycpl!115)
  * It was not possible to change any PyEsoRex parameters from their default values due to a bug in the `pyesorex.parameter.Parameter` classes (pycpl!115)
  * It was not possible to create config files with PyEsoRex because the `CreateConfigAction` and `Pyesorex.write_config()` method had not been fully updated for the refactored parameter/command line argument handling (pycpl!115)
  * Trying to read recipe config files with a specified name resulted in an `UnboundLocalError`
  (see https://jira.eso.org/browse/PIPE-10045, pycpl!115)


## 0.3.0

### Changed
- Refactoring of PyEsoRex parameter & command line argument handling.

### Fixed
- Fixed issues with some PyEsoRex command line arguments being ignored under certain circumstances.


## 0.2.0

### Added
- API Reference Manual for both PyCPL and PyEsoRex, generated from docstrings using Sphinx. See README.md for build instructions.
- Installation options to install the requirements for building docs or running tests. See README.md for details.
- PyEsoRex now signs data products returned by recipes. Options have been added to disable either the checksums or data MD5 sums in the recipe products.
- Change log.

