# PyEsoRex &mdash; A PyCPL recipe execution tool

PyEsoRex is a CPL recipe execution tool implemented in Python 3. It performs a very similar role to
the EsoRex command line tool, and provides a very similar command line interface including the
use of the same configuration file formats.

As well as CPL recipes (written in C) PyEsoRex is able to execute PyCPL recipes written in Python
using the PyCPL library's `cpl.ui.PyRecipe` base class.

In addition to the command line interface PyEsoRex provides a comprehensive object orientated
Python API that can be used from Python code, or in interactive Python sessions.

## Installation requirements:

* Python >= 3.9
* PyCPL >= 0.9.0

PyEsoRex has no additional requirements over those required to build and install PyCPL. For a full
list of those see PyCPL's `README.md` file.

## Installation instructions:

Installation is done by running `pip` in the top level `pyesorex` source directory, e.g.
```shell
cd pyesorex`
python3 -m pip3 install --user -U .
```

The above example is for a userspace pip install with no virtual environments in use.
For a system wide install or install into a venv/conda virtual environment remove the option `--user`
from the above pip command. For more details see installation instructions in the PyEsoRex documentation.

## Documentation

The PyEsoRex source repository also contains the source for the PyEsoRex documentation.

### Prerequisites

Building this manual requires the Sphinx Python library and its dependencies. These can be installed using `pip` by specifying the `[doc]` extra rquirements when installing PyEsoRex, e.g.
```shell
cd pyesorex
python3 -m pip install -U '.[doc]'
```

### Building the documentation

First change to the docs subdirectory of the PyCPL repository, e.g. `cd pycpl/doc`. The documentation can then be built using `make`, with different make targets corresponding to different output formats. For example:

* HTML output: `make html`
* PDF output (requires LaTeX): `make latexpdf`

To list all of the available targets/formats just run `make` without a target in the `docs` directory.

After building the documentation it will be in the `pyesorex/docs/_build`

## Usage

### Command line interface

General usage:
```shell
pyesorex [pyesorex options] recipe [recipe options] sof
```
Example running a CPL recipe from the GIRAFFE pipeline:
```shell
$ pyesorex --config=demo2.rc --recipe-config=gimasterbias.rc gimasterbias --bpm-create=False gimasterbias.sof
[ INFO  ] pyesorex: This is PyEsoRex, version 1.0.1.

     ***** ESO Recipe Execution Tool, Python version 1.0.1 *****

[ INFO  ] pyesorex: Read config file '/Users/dummy/Sandbox/demo2.rc'.
[ INFO  ] pyesorex: Loaded recipe 'gimasterbias'.
[ INFO  ] pyesorex: Read config file '/Users/dummy/Sandbox/gimasterbias.rc'.
[ INFO  ] pyesorex: Running recipe 'gimasterbias'...
[ INFO  ] Creating master bias from 5 bias frames ...
[ INFO  ] Combination method is Median
[ INFO  ] Finding median of 5 images
[ INFO  ] Writing master bias image ...
[ INFO  ] Computing QC1 parameters ...
[ INFO  ] Processing product frame 'master_bias.fits' (MASTER_BIAS)
[ INFO  ] pyesorex: Recipe 'gimasterbias' complete.
[ INFO  ] pyesorex: Calculating product checksums
[ INFO  ] pyesorex: Created product master_bias.fits (in place)
[ INFO  ] pyesorex: 1 products created
[ INFO  ] pyesorex: Recipe operation(s) took 2.30 seconds to complete.
[ INFO  ] pyesorex: Total size of 5 raw input frames = 88.96 MB
[ INFO  ] pyesorex: => processing rate of 38.65 MB/s
```
For a full list of currently supported command line options run `pyesorex --help`.

### Python API

Example running a CPL recipe from the GIRAFFE pipeline:
```python
from pyesorex.pyesorex import Pyesorex

p = Pyesorex(config="demo2.rc")
p.load_recipe("gimasterbias", recipe_config="gimasterbias.rc")
p.recipe_parameters.update({"giraffe.masterbias.bpm.create": False})
p.sof_location = "gimasterbias.sof"
products = p.run()
```
For full details of the `Pyesorex` API use `help(Pyesorex)` from within a Python session.
