from typing import Any, Dict

import cpl.ui


class HelloWorldNoParameters(cpl.ui.PyRecipe):
    _name = "helloworld_no_parameters"
    _version = "1.0"
    _author = "U.N. Owen"
    _email = "unowen@somewhere.net"
    _copyright = "GPL-3.0-or-later"
    _synopsis = "PyCPL version of 'hello, world!'"
    _description = "HelloWorld without parameters."

    def __init__(self) -> None:
        super().__init__()

    def run(
        self, frameset: cpl.ui.FrameSet, settings: Dict[str, Any]
    ) -> cpl.ui.FrameSet:
        for frame in frameset:
            print(f"Hello, {frame.file}!")
        return cpl.ui.FrameSet()


class HelloWorldZeroParameters(cpl.ui.PyRecipe):
    _name = "helloworld_zero_parameters"
    _version = "1.0"
    _author = "U.N. Owen"
    _email = "unowen@somewhere.net"
    _copyright = "GPL-3.0-or-later"
    _synopsis = "PyCPL version of 'hello, world!'"
    _description = "HelloWorld with zero parameters."

    def __init__(self) -> None:
        super().__init__()

        self.parameters = cpl.ui.ParameterList(())

    def run(
            self, frameset: cpl.ui.FrameSet, settings: Dict[str, Any]
    ) -> cpl.ui.FrameSet:
        for frame in frameset:
            print(f"Hello, {frame.file}!")
        return cpl.ui.FrameSet()


class HelloWorldNoneParameters(cpl.ui.PyRecipe):
    _name = "helloworld_none_parameters"
    _version = "1.0"
    _author = "U.N. Owen"
    _email = "unowen@somewhere.net"
    _copyright = "GPL-3.0-or-later"
    _synopsis = "PyCPL version of 'hello, world!'"
    _description = "HelloWorld with None parameters."

    def __init__(self) -> None:
        super().__init__()

        # No arguments
        self.parameters = cpl.ui.ParameterList()

    def run(
            self, frameset: cpl.ui.FrameSet, settings: Dict[str, Any]
    ) -> cpl.ui.FrameSet:
        for frame in frameset:
            print(f"Hello, {frame.file}!")
        return cpl.ui.FrameSet()


class HelloWorldOneParameter(cpl.ui.PyRecipe):
    _name = "helloworld_one_parameter"
    _version = "1.0"
    _author = "U.N. Owen"
    _email = "unowen@somewhere.net"
    _copyright = "GPL-3.0-or-later"
    _synopsis = "PyCPL version of 'hello, world!'"
    _description = "HelloWorld with one parameters. First example from https://www.eso.org/sci/software/pycpl/pycpl-site/user/basics.html "

    def __init__(self) -> None:
        super().__init__()

        self.parameters = cpl.ui.ParameterList(
            (
                cpl.ui.ParameterValue(
                    name="hellouser.username",
                    context="hellouser",
                    description="User's name",
                    default="Unknown user",
                ),
            )
        )

    def run(
        self, frameset: cpl.ui.FrameSet, settings: Dict[str, Any]
    ) -> cpl.ui.FrameSet:
        print("Settings:", settings)
        if "hellouser.username" in settings:
            username = settings["hellouser.username"]
        else:
            username = "default Unknown user"
        print(f"Hi {username}")
        for frame in frameset:
            print(f"Hello, {frame.file}!")
        return cpl.ui.FrameSet()
