import copy
from pathlib import Path
import sys

import pytest

from pyesorex.pyesorex import Pyesorex
from pyesorex.__main__ import pyesorex_cli 

PATH_HERE = Path(__file__).parent
PATH_RECIPES = PATH_HERE / "recipes"
PATH_SOF = PATH_HERE / "sofs"

@pytest.mark.parametrize("recipe_name", [
    "helloworld_no_parameters",
    "helloworld_zero_parameters",
    "helloworld_none_parameters",
    "helloworld_one_parameter",
])
def test_helloworld(recipe_name):
    mypyesorex = Pyesorex(recipe_dirs=PATH_RECIPES)
    mypyesorex.recipe = recipe_name
    mypyesorex.run()

    sys_argv_org = copy.copy(sys.argv)
    sys.argv = [
        "pyesorex",
        "--recipe-dir",
        str(PATH_RECIPES),
        recipe_name,
        str(PATH_SOF / "empty.sof"),
    ]
    exit_code = pyesorex_cli()
    sys.argv = sys_argv_org
    assert exit_code is None


def test_parameter_not_set(capsys):
    sys_argv_org = copy.copy(sys.argv)
    sys.argv = [
        "pyesorex",
        "--recipe-dir",
        str(PATH_RECIPES),
        "helloworld_one_parameter",
        str(PATH_SOF / "empty.sof"),
    ]
    exit_code = pyesorex_cli()
    sys.argv = sys_argv_org
    assert exit_code is None
    captured = capsys.readouterr()
    print(captured.out)
    assert "Hi default Unknown user" in captured.out


def test_parameter_set(capsys):
    sys_argv_org = copy.copy(sys.argv)
    sys.argv = [
        "pyesorex",
        "--recipe-dir",
        str(PATH_RECIPES),
        "helloworld_one_parameter",
        "--hellouser.username=Hugo",
        str(PATH_SOF / "empty.sof"),
    ]
    exit_code = pyesorex_cli()
    sys.argv = sys_argv_org
    assert exit_code is None
    captured = capsys.readouterr()
    print(captured.out)
    assert "Hi Hugo" in captured.out


def test_parameter_set_to_default(capsys):
    sys_argv_org = copy.copy(sys.argv)
    sys.argv = [
        "pyesorex",
        "--recipe-dir",
        str(PATH_RECIPES),
        "helloworld_one_parameter",
        "--hellouser.username=Unknown user",
        str(PATH_SOF / "empty.sof"),
    ]
    exit_code = pyesorex_cli()
    sys.argv = sys_argv_org
    assert exit_code is None
    captured = capsys.readouterr()
    print(captured.out)
    assert "Hi Unknown user" in captured.out
