AC_DEFUN([AB_DOCU],
[

AC_ARG_ENABLE(
        Documentation,
        AC_HELP_STRING([--enable-Documentation], [Build the documentation (default off)]),
        ac_request_docu=$enableval,
        ac_request_docu=no)

if test "x$ac_request_docu" = xyes; then

	AC_CHECK_PROGS([ac_doxygen],doxygen,no)
	if test "x$ac_doxygen" != xno; then
      		AC_SUBST(DOXYGEN, "$ac_doxygen")
	else
	      	AC_WARN(doxygen not (properly) installed.)
	fi

        if test "x$ac_doxygen" = xyes; then
                ac_compile_html=yes
        fi

	AC_CHECK_PROGS([ac_lyx],lyx, no)
	if test "x$ac_lyx" != xno; then
      		AC_SUBST(LYX, "$ac_lyx")
	else
      		AC_WARN(lyx not (properly) installed.)
	fi


fi

AM_CONDITIONAL(COND_HTMLDOC, [test "x$ac_compile_html" = xyes])
AM_CONDITIONAL(HAVE_LYX, test x$ac_lyx = xtrue)
AM_CONDITIONAL(HAVE_DOXYGEN, test x$ac_doxygen = xtrue)

])

