/* $Id: $
 * This file is part of the SPHERE Pipeline
 * Copyright (C) 2007-2010 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: $
 * $Date: $
 * $Revision: $
 * $Name: $
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

/*-----------------------------------------------------------------------------
 Includes
 -----------------------------------------------------------------------------*/
#include <cpl.h>
#include "sph_error.h"
#include "sph_ifs_detector_persistence.h"
#include "sph_common_keywords.h"
#include "sph_ifs_tags.h"
#include "sph_utils.h"
#include "sph_shared_irdifs.h"
#include "sph_fitting.h"
#include <time.h>
/*----------------------------------------------------------------------------*/
/**
 * @defgroup sph_ifs_detector_persistence_run
 *
 * The run function for the IFS detector persistence recipe.
 *
 * @par Synopsis:
 * @code
 * typedef _module_ {
 * } module
 * @endcode
 * @par Desciption:
 *
 * This module provides ...
 */
/*----------------------------------------------------------------------------*/
/**@{*/

cpl_error_code sph_ifs_detector_persistence_run(
        sph_ifs_detector_persistence* self) {
    SPH_ERROR_CHECK_STATE_ONERR_RETURN_ERRCODE;

    sph_irdifs_detector_persistence_run(self->static_badpixel_frame,
            self->master_dark_frame, self->satframes, self->unsatframes,
            self->coll_alg, self->framecomb_parameterlist, self->rawframes,
            self->inframes, self->inparams, self->threshold_dark,
            self->threshold_ill, self->fitorder,
            self->detector_persistence_outfilename,
            SPH_IFS_TAG_DETECTOR_PERSISTENCE_CALIB,
            SPH_RECIPE_NAME_IFS_DETECTOR_PERSISTENCE, SPH_PIPELINE_NAME_IFS);

    SPH_ERROR_CHECK_STATE_ONERR_RETURN_ERRCODE;
    return CPL_ERROR_NONE;
}

/**@}*/
