/***********************************************************************************************/
/******** DANGER !! DANGER !! DANGER !! DO NOT EDIT FILE -- IT WAS GENERATED AUTOMATICALLY !!! */
/***********************************************************************************************/

/* $Id: $
 * This file is part of the SPHERE Pipeline
 * Copyright (C) 2007-2010 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: $
 * $Date: $
 * $Revision: $
 * $Name: $
 */

/*-----------------------------------------------------------------------------
 Includes
 -----------------------------------------------------------------------------*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "sph_ifs_distortion_map.h"
#include "sph_common_keywords.h"
#include "sph_ifs_keywords.h"
#include "sph_ifs_tags.h"
#include "sph_master_frame.h"
#include "sph_error.h"
#include "sph_cube.h"
#include "sph_utils.h"

#include <math.h>
#include <assert.h>
#include <cpl.h>

/*-----------------------------------------------------------------------------
  Error Codes
 -----------------------------------------------------------------------------*/

sph_error_code SPH_IFS_DISTORTION_MAP_GENERAL              = SPH_IFS_DISTORTION_MAP_ERR_START + 0;
sph_error_code SPH_IFS_DISTORTION_MAP_NO_VALID_DIT_LIST    = SPH_IFS_DISTORTION_MAP_ERR_START + 1;

sph_error_code SPH_IFS_DISTORTION_MAP_PARAMETER_MISSING    = SPH_IFS_DISTORTION_MAP_ERR_START + 3;
sph_error_code SPH_IFS_DISTORTION_MAP_FRAMES_MISSING       = SPH_IFS_DISTORTION_MAP_ERR_START + 4;

/*-----------------------------------------------------------------------------
 Private function prototypes
 -----------------------------------------------------------------------------*/

static int sph_ifs_distortion_map_create_plugin ( cpl_plugin * );
static int sph_ifs_distortion_map_exec_plugin ( cpl_plugin * );
static int sph_ifs_distortion_map_destroy_plugin ( cpl_plugin * );

/*-----------------------------------------------------------------------------
 Static variables
 -----------------------------------------------------------------------------*/

static const char* sph_ifs_distortion_map_help = 
    "RECIPE INPUT FRAMES: \n"
    "-------------------- \n"
    "Tag                           Min,Max   Description\n"
    "IFS_DISTORTION_MAP_RAW          1,500   The raw distortion frames. Should contain many point sources,\n"
    "                                        ideally using the distortion calibration hardware.\n"
    "IFS_MASTER_DFF_LONG1            0,  1   A long exposure master flat frame taken with monochromatic light.\n"
    "IFS_MASTER_DFF_LONG2            0,  1   A long exposure master flat frame taken with monochromatic light.\n"
    "IFS_MASTER_DFF_LONG3            0,  1   A long exposure master flat frame taken with monochromatic light.\n"
    "IFS_MASTER_DFF_LONG4            0,  1   A long exposure master flat frame taken with monochromatic light.\n"
    "IFS_MASTER_DFF_LONGBB           0,  1   A long exposure master flat frame taken with broad band light.\n"
    "IFS_MASTER_DFF_SHORT            0,  1   A short exposure master flat frame taken with broad band light.\n"
    "IFS_IFU_FLAT_FIELD              0,  1   Master IFU flat field (lenslet flat).\n"
    "IFS_CAL_BACKGROUND              0,  1   An optional master background frame for dark subtraction.\n"
    "IFS_MASTER_DARK                 0,  1   An optional master dark frame for dark subtraction.\n"
    "IFS_STATIC_BADPIXELMAP          0,  1   Optional static badpixel map.\n"
    "IFS_WAVECALIB                   1,  1   Wavelength calibration pixel description table.\n"
    "IFS_POINT_PATTERN               0,  1   The input positions of the expected points. Optional input, if\n"
    "                                        it is not provided, recipe will construct new point table from\n"
    "                                        input images.\n"
    "IFS_PREAMP_FLAT                 0,  1   A preamp correction flat. If provided the science frames are corrected for this\n"
    "                                        before applying other flats.\n"
    "\n"
    "RAW FRAME KEYWORDS: \n"
    "-------------------- \n"
    "Keyword                       Type   Optional  Description\n"
    "ESO INS2 DITH POSX            double Yes       The dithering position in X for the frame in pixels \n"
    "ESO INS2 DITH POSY            double Yes       The dithering position in Y for the frame in pixels \n"
    "\n"
    "DESCRIPTION:\n"
    "------------\n"
    "This recipe measures the distortion of the lenslet grid. The input\n"
    "raw frames are first reduced in the same way as for the science_dr\n"
    "recipe (allowing dither but no frame rotation), optionally including dark\n"
    "subtraction via either a master background or a master dark and optionally\n"
    "(if all flats provided) flat fielding. The resulting monochromatic\n"
    "images are then collapsed along the wavelength direction giving a single image.\n"
    "This image is then analysed to detect the point sources using simple\n"
    "thresholding, taking the user parameter as the threshold value (sigmas).\n"
    "Now the way the recipe proceeds depends on the inputs.\n"
    "\n"
    "If no input\n"
    "point pattern has been provided, the recipe will construct one from\n"
    "the reduced images detected point sources. This will then be written out\n"
    "as a product.\n"
    "\n"
    "If a input point pattern was provided, the recipe will skip this\n"
    "step and proceed directly to the measurement of the distortion. Please\n"
    "note that the distortion is measured in any case which means that the\n"
    "output distortion should be zero in case that no input point pattern was provided.\n"
    "\n"
    "The distortion map is constructed by comparing the detected point sources\n"
    "position with the expected point source position as provided in the\n"
    "input point pattern. Each comparison is done with the closest point found and\n"
    "yields one distortion vector. Upon completion, all distortion vectors\n"
    "that have a length larger than the max_distortion specified as a user\n"
    "parameter will be removed before the x and y components of the distortion\n"
    "vectors will be fit with a 2D polynomial (of the user specified fitting order).\n"
    "\n"
    "To allow for easier quality control, the recipe provides a user flag for a\n"
    "self consistency check. If this flag is set, the recipe will now apply the measured\n"
    "distortion map to the input raw data and calculate any residual distortion left.\n"
    "This residual is written out as an extra FITS file -- it should be visually inspected\n"
    "to verify that the distortion map has been calculated with sufficient accuracy in\n"
    "the detector region(s) of interest.\n"
    "RECIPE PRODUCTS: \n"
    "-------------------- \n"
    "Tag                      Format         Description\n"
    "IFS_POINT_PATTERN                  FITS[Table]    The point pattern as obtained from the input images. Only written in case that\n"
    "                                        an input point pattern was provided. This product may be used as reference\n"
    "                                        input for future runs of this recipe.\n"
    "IFS_DISTORTION_MAP                 FITS[Im(8)]    The distortion map. The distortion map is saved as an 8 extension FITS file with\n"
    "                                        the first 4 extensions containing the distortion in the x direction, the badpixels,\n"
    "                                        the rms on the distortion in x and a weightmap. The second set of 4 extensions\n"
    "                                        contain the same information but for the distortion in the y direction.\n"
    "\n"
    "PRODUCT FRAME KEYWORDS: \n"
    "-------------------- \n"
    "Keyword                       Frame          Type    Description\n"
    "\n"
;

/*-----------------------------------------------------------------------------
 Function code
 -----------------------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/
/**
 * @defgroup sph_ifs_distortion_map Create Master Dark Recipe
 *
 * This module provides the recipe plugin and relating functions for the
 * creation of the master dark .
 *
 * @par Synopsis:
 * @code
 *   #include "sph_ifs_distortion_map.h"
 * @endcode
 */
/*----------------------------------------------------------------------------*/
/**@{*/

/*****************************************************************************
 *
 *
 *      First come the static and global functions necessary for the
 *      normal working of the recipe as plugin....
 *
 *
 * ***************************************************************************/
/*----------------------------------------------------------------------------*/
/**
 @brief    Build the list of available plugins, for this module.
 @param    list    the plugin list
 @return   0 if everything is ok, 1 otherwise
 @note     Only this function is exported

 Create the recipe instance and make it available to the application
 using the interface.
 */
/*----------------------------------------------------------------------------*/
int cpl_plugin_get_info(cpl_pluginlist * list)
{
    cpl_recipe * recipe = cpl_calloc( 1, sizeof *recipe);
    cpl_plugin * plugin = &recipe->interface;

    if (cpl_plugin_init(plugin,
                        CPL_PLUGIN_API,
                        SPH_IFS_DISTORTION_MAP_VERSION,
                        CPL_PLUGIN_TYPE_RECIPE,
                        "sph_ifs_distortion_map",
                        "Measure the lenslet array distortion",
                        sph_ifs_distortion_map_help, "Ole Moeller-Nilsson <moeller@mpia-hd.mpg.de>",
                        "https://support.eso.org", cpl_get_license("SPHERE DRH","2012"),
                        sph_ifs_distortion_map_create_plugin,
                        sph_ifs_distortion_map_exec_plugin,
                        sph_ifs_distortion_map_destroy_plugin) )
    {
        cpl_msg_error( cpl_func, "Plugin initialization failed");
        (void)cpl_error_set_where( cpl_func );
        return 1;
    }

    if (cpl_pluginlist_append(list, plugin) )
    {
        cpl_msg_error( cpl_func, "Error adding plugin to list");
        (void)cpl_error_set_where( cpl_func );
        return 1;
    }
    return 0;
}

/*----------------------------------------------------------------------------*/
/**
 @brief    Setup the recipe options
 @param    plugin  the plugin
 @return   0 if everything is ok

 Defining the command-line/configuration parameters for the recipe.
 */
/*----------------------------------------------------------------------------*/
static int sph_ifs_distortion_map_create_plugin(cpl_plugin * plugin)
{
    if (cpl_error_get_code() != CPL_ERROR_NONE)
    {
        cpl_msg_error( cpl_func, "%s():%d: An error is already set: %s",
                       cpl_func, __LINE__, cpl_error_get_where());
        return (int)cpl_error_get_code();
    }

    if (plugin == NULL)
    {
        cpl_msg_error(cpl_func, "Null plugin");
        cpl_ensure_code(0, (int)CPL_ERROR_NULL_INPUT);
    }

    if (cpl_plugin_get_type(plugin) != CPL_PLUGIN_TYPE_RECIPE)
    {
        cpl_msg_error( cpl_func, "Plugin is not a recipe");
        cpl_ensure_code( 0, (int)CPL_ERROR_TYPE_MISMATCH );
    }

    if ( plugin != NULL ) {
        cpl_recipe * recipe = (cpl_recipe *)plugin;
        recipe->parameters = sph_ifs_distortion_map_create_paramlist();
        if ( recipe->parameters == NULL ) {
            return SPH_IFS_DISTORTION_MAP_GENERAL;
        }
    }
    return 0;
}

/*----------------------------------------------------------------------------*/
/**
 @brief    Testing for setup of the recipe options
 @param    plugin  the plugin
 @return   0 if everything is ok

 Wrapper to make the static plugin creation function accessible from outside
 for testing purposes.
 */
/*----------------------------------------------------------------------------*/
int sph_ifs_distortion_map_create_test(cpl_plugin * plugin)
{
    return (int)sph_ifs_distortion_map_create_plugin(plugin);
}

/*----------------------------------------------------------------------------*/
/**
 @brief    Execute the plugin instance given by the interface
 @param    plugin  the plugin
 @return   0 if everything is ok
 */
/*----------------------------------------------------------------------------*/
static int sph_ifs_distortion_map_exec_plugin(cpl_plugin * plugin)
{

    cpl_recipe*             recipe                  = NULL;
    cpl_error_code          recipe_code;
    sph_ifs_distortion_map*    sph_recipe      = NULL;
    cpl_errorstate          initial_errorstate      = cpl_errorstate_get();

    if (cpl_error_get_code() != CPL_ERROR_NONE)
    {
        cpl_msg_error( cpl_func, "%s():%d: A cpl error is already set: %s",
        cpl_func, __LINE__, cpl_error_get_where());
        return (int)cpl_error_get_code();
    }

    if (plugin == NULL)
    {
        cpl_msg_error( cpl_func, "Null plugin");
        cpl_ensure_code( 0, (int)CPL_ERROR_NULL_INPUT );
        return (int)cpl_error_get_code();
    }

    if (cpl_plugin_get_type(plugin) != CPL_PLUGIN_TYPE_RECIPE)
    {
        cpl_msg_error( cpl_func, "Plugin is not a recipe");
        cpl_ensure_code( 0, (int)CPL_ERROR_TYPE_MISMATCH );
        return (int)cpl_error_get_code();
    }

    recipe = (cpl_recipe *)plugin;

    if (recipe->parameters == NULL)
    {
        cpl_msg_error( cpl_func, "Recipe invoked with NULL parameter list");
        cpl_ensure_code( 0, (int)CPL_ERROR_NULL_INPUT );
        return (int)cpl_error_get_code();
    }

    if (recipe->frames == NULL)
    {
        cpl_msg_error( cpl_func, "Recipe invoked with NULL frame set");
        cpl_ensure_code( 0, (int)CPL_ERROR_NULL_INPUT );
        return (int)cpl_error_get_code();
    }

    sph_recipe = sph_ifs_distortion_map_new( recipe->frames, recipe->parameters );
    if ( sph_recipe == NULL ) {
        recipe_code = cpl_error_set_where(cpl_func);
    } else {

        recipe_code = sph_ifs_distortion_map_run( sph_recipe );

        sph_ifs_distortion_map_delete( sph_recipe );
    }

    if ( !cpl_errorstate_is_equal(initial_errorstate) )
    {
        cpl_errorstate_dump(initial_errorstate, CPL_FALSE, NULL);
    }
    sph_end_erex(); //close the sphere system
    return (int)(recipe_code >= CPL_ERROR_EOL /* Workaround esorex PIPE-6887 */
                 ? CPL_ERROR_EOL : recipe_code);
}

/*----------------------------------------------------------------------------*/
/**
 @brief    Destroy what has been created by the 'create' function
 @param    plugin  the plugin
 @return   0 if everything is ok
 */
/*----------------------------------------------------------------------------*/
static int sph_ifs_distortion_map_destroy_plugin(cpl_plugin * plugin)
{
    cpl_recipe * recipe;

    if (plugin == NULL)
    {
        cpl_msg_error( cpl_func, "Null plugin");
        cpl_ensure_code( 0, (int)CPL_ERROR_NULL_INPUT );
    }

    if (cpl_plugin_get_type(plugin) != CPL_PLUGIN_TYPE_RECIPE)
    {
        cpl_msg_error( cpl_func, "Plugin is not a recipe");
        cpl_ensure_code( 0, (int)CPL_ERROR_TYPE_MISMATCH );
    }

    recipe = (cpl_recipe *)plugin;

    cpl_parameterlist_delete(recipe->parameters);

    return 0;
}

/*****************************************************************************
 *
 *
 *      Here come the "Member" functions of the sph_ifs_distortion_map struct
 *
 *
 * ***************************************************************************/

/*----------------------------------------------------------------------------*/
/**
 @brief    Fill a pre-allocated parameterlist for the recipe
 @param    result A pre-allocated parameterlist
 @return   CPL_ERROR_NONE iff successful

 This function fills the standard parameterlist for the recipe

 */
/*----------------------------------------------------------------------------*/
static cpl_error_code sph_ifs_distortion_map_fill_parameterlist(cpl_parameterlist * result)
{
    cpl_parameter* p;

        /* Code to set up parameters GENERATED DO NOT EDIT */

        p = cpl_parameter_new_value("ifs.distortion_map.outfilename",
                                   CPL_TYPE_STRING,
                                   "The output filename for the product. Please also see the esorex documentation "
                                   "for naming of output products. "
                                   ,"ifs.distortion_map",
                                   "ifs_distortion_map.fits" );

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_value("ifs.distortion_map.ldt_outfilename",
                                   CPL_TYPE_STRING,
                                   "The filename of the wavelength cube output. This is mainly for debugging purposes. "
                                   ,"ifs.distortion_map",
                                   "ifs_distortion_map_ldt.fits" );

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_enum("ifs.distortion_map.coll_alg",
                                   CPL_TYPE_INT,
                                   "The collapse algorithm to use. 0 = Mean, 1 = Median, 2 = Clean mean "
                                   ,"ifs.distortion_map",
                                   1 ,
                                   3,0,1,2);

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_range("ifs.distortion_map.clean_mean.reject_high",
                                   CPL_TYPE_INT,
                                   "The clean mean reject pixels on high end. "
                                   ,"ifs.distortion_map",
                                   0 ,
                                   0,20);

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_range("ifs.distortion_map.clean_mean.reject_low",
                                   CPL_TYPE_INT,
                                   "The clean mean reject pixels on low end. "
                                   ,"ifs.distortion_map",
                                   0 ,
                                   0,20);

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_value("ifs.distortion_map.point_table_filename",
                                   CPL_TYPE_STRING,
                                   "The output filename for the point pattern table. "
                                   "Please also see the esorex documentation for naming of output "
                                   "products. "
                                   ,"ifs.distortion_map",
                                   "distortion_point_table.fits" );

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_value("ifs.distortion_map.dither",
                                   CPL_TYPE_BOOL,
                                   "Controls the use of dithering. "
                                   ,"ifs.distortion_map",
                                   0 );

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_range("ifs.distortion_map.threshold",
                                   CPL_TYPE_DOUBLE,
                                   "The threshold (sigma) for detecting the grind point sources. "
                                   ,"ifs.distortion_map",
                                   3.0 ,
                                   0.0,200.0);

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_range("ifs.distortion_map.fitting_order",
                                   CPL_TYPE_INT,
                                   "The fitting order of the 2D polynomial fit to the distortions. "
                                   ,"ifs.distortion_map",
                                   3 ,
                                   2,8);

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_range("ifs.distortion_map.max_distortion",
                                   CPL_TYPE_DOUBLE,
                                   "The maximum distortion to accept. "
                                   "Points above this value are removed before polynomial fitting. "
                                   ,"ifs.distortion_map",
                                   4.0 ,
                                   0.0,2000.0);

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_value("ifs.distortion_map.self_check",
                                   CPL_TYPE_BOOL,
                                   "Flag to set when a consistency self check is needed. "
                                   "An output is created containing the reduced input frames with the distortion map applied. "
                                   "Setting this option will double the execution time of this recipe! "
                                   ,"ifs.distortion_map",
                                   0 );

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_range("ifs.distortion_map.add_rotation",
                                   CPL_TYPE_DOUBLE,
                                   "Additional rotation angle that the measured point pattern is rotated by before attempting a match. This is applied in addition to the rotations specified in the lenslet model in the keywords of the calibration input files. The sense of direction is specified in the same sense as in the lenslet model. "
                                   ,"ifs.distortion_map",
                                   0.0 ,
                                   -360.0,360.0);

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        /* End of code to set up parameters BUT ITS STILL NOT SAFE TO EDIT! FILE IS GENERATED !*/

    return cpl_error_set_where(cpl_func);
}
/*----------------------------------------------------------------------------*/
/**
 @brief  Create and return the standard parameterlist for the recipe
 @return The standard parameterlist or NULL on error
 @note   The returned object must be deallocated using cpl_parameterlist_delete

 */
/*----------------------------------------------------------------------------*/
cpl_parameterlist* sph_ifs_distortion_map_create_paramlist(void)
{
    cpl_parameterlist* self = cpl_parameterlist_new();

    if (sph_ifs_distortion_map_fill_parameterlist(self)) {
        cpl_parameterlist_delete(self);
        self = NULL;
        (void)cpl_error_set_where(cpl_func);
    }

    return self;
}

/*----------------------------------------------------------------------------*/
/**
 @brief    Check the recipe frames, and assign them to the sph_ifs_distortion_map
           structure.
 @param    self     the sph_ifs_distortion_map recipe structure
 @return   error code of the check.

 This checks the frames that were given in the sph_ifs_distortion_map_new function
 as parameters for the correctness and completeness. If the frames needed are
 found they are also assigned to the corresponding structure members.

 The return value is the error code of the check.
 */
/*----------------------------------------------------------------------------*/
sph_error_code  sph_ifs_distortion_map_check_frames( sph_ifs_distortion_map* self )
{
    sph_error_code           rerr            = CPL_ERROR_NONE;
    /* Code to check frames GENERATED DO NOT EDIT */

    cpl_frame* aframe;
    aframe = cpl_frameset_find( self->inframes, SPH_IFS_TAG_DISTORTION_MAP_RAW );
    while ( aframe ) {
        cpl_frame_set_group( aframe, CPL_FRAME_GROUP_RAW );
        aframe = cpl_frameset_find( self->inframes, NULL );
    }
    self->raw_frameset = sph_utils_extract_frames( self->inframes, SPH_IFS_TAG_DISTORTION_MAP_RAW );
    if ( ! self->raw_frameset )
    {
        sph_error_raise( SPH_IFS_DISTORTION_MAP_FRAMES_MISSING,
                         __FILE__, __func__, __LINE__ ,
                         SPH_ERROR_ERROR,
                         "Could not extract raw_frameset frames."
                         "to use them check that they have the %s tag.",
                         SPH_IFS_TAG_DISTORTION_MAP_RAW);
        rerr = SPH_IFS_DISTORTION_MAP_FRAMES_MISSING;
        return rerr;
    }

    else {

         int numframes = (int)cpl_frameset_get_size( self->raw_frameset );
         for ( int ii = 0; ii < numframes; ++ii ) {
             cpl_frame* iframe = cpl_frameset_get_position( self->raw_frameset, ii );
             const char* ifname = cpl_frame_get_filename(iframe);
             cpl_propertylist* pl = cpl_propertylist_load(ifname, 0);
             if (pl == NULL ) {
                 sph_error_raise(cpl_error_get_code(),
                    __FILE__, __func__, __LINE__ ,SPH_ERROR_ERROR,
                 "Could not read keywords from file %s. "
                 "Either the file is not readable or corrupted. ",
                  ifname);
             }
             else {
                 rerr = cpl_frame_set_group( iframe, CPL_FRAME_GROUP_RAW );
                 cpl_propertylist_delete(pl); pl=NULL;
             }
         }
         numframes -= (int)cpl_frameset_get_size( self->raw_frameset );
         assert( numframes == 0);
    }

    aframe = cpl_frameset_find( self->inframes, SPH_IFS_TAG_DFF_LONG_CALIB );
    while ( aframe ) {
        cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
        aframe = cpl_frameset_find( self->inframes, NULL );
    }
    self->master_dff_long1_frame = sph_utils_extract_frame( self->inframes, SPH_IFS_TAG_DFF_LONG_CALIB );
    if ( ! self->master_dff_long1_frame )
    {
        sph_error_raise( SPH_IFS_DISTORTION_MAP_FRAMES_MISSING,
                         __FILE__, __func__, __LINE__ ,
                         SPH_ERROR_INFO,
                         "Could not extract master_dff_long1_frame frames."
                         "Since this is an optional frame, this is ok "
                         "and this message is just informational. If you intended, "
                         "to use them check that they have the %s tag.",
                         SPH_IFS_TAG_DFF_LONG_CALIB);
        cpl_error_reset();
    }

    else {

         rerr = cpl_frame_set_group( self->master_dff_long1_frame, CPL_FRAME_GROUP_CALIB );
    }

    aframe = cpl_frameset_find( self->inframes, SPH_IFS_TAG_DFF_LONG2_CALIB );
    while ( aframe ) {
        cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
        aframe = cpl_frameset_find( self->inframes, NULL );
    }
    self->master_dff_long2_frame = sph_utils_extract_frame( self->inframes, SPH_IFS_TAG_DFF_LONG2_CALIB );
    if ( ! self->master_dff_long2_frame )
    {
        sph_error_raise( SPH_IFS_DISTORTION_MAP_FRAMES_MISSING,
                         __FILE__, __func__, __LINE__ ,
                         SPH_ERROR_INFO,
                         "Could not extract master_dff_long2_frame frames."
                         "Since this is an optional frame, this is ok "
                         "and this message is just informational. If you intended, "
                         "to use them check that they have the %s tag.",
                         SPH_IFS_TAG_DFF_LONG2_CALIB);
        cpl_error_reset();
    }

    else {

         rerr = cpl_frame_set_group( self->master_dff_long2_frame, CPL_FRAME_GROUP_CALIB );
    }

    aframe = cpl_frameset_find( self->inframes, SPH_IFS_TAG_DFF_LONG3_CALIB );
    while ( aframe ) {
        cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
        aframe = cpl_frameset_find( self->inframes, NULL );
    }
    self->master_dff_long3_frame = sph_utils_extract_frame( self->inframes, SPH_IFS_TAG_DFF_LONG3_CALIB );
    if ( ! self->master_dff_long3_frame )
    {
        sph_error_raise( SPH_IFS_DISTORTION_MAP_FRAMES_MISSING,
                         __FILE__, __func__, __LINE__ ,
                         SPH_ERROR_INFO,
                         "Could not extract master_dff_long3_frame frames."
                         "Since this is an optional frame, this is ok "
                         "and this message is just informational. If you intended, "
                         "to use them check that they have the %s tag.",
                         SPH_IFS_TAG_DFF_LONG3_CALIB);
        cpl_error_reset();
    }

    else {

         rerr = cpl_frame_set_group( self->master_dff_long3_frame, CPL_FRAME_GROUP_CALIB );
    }

    aframe = cpl_frameset_find( self->inframes, SPH_IFS_TAG_DFF_LONG4_CALIB );
    while ( aframe ) {
        cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
        aframe = cpl_frameset_find( self->inframes, NULL );
    }
    self->master_dff_long4_frame = sph_utils_extract_frame( self->inframes, SPH_IFS_TAG_DFF_LONG4_CALIB );
    if ( ! self->master_dff_long4_frame )
    {
        sph_error_raise( SPH_IFS_DISTORTION_MAP_FRAMES_MISSING,
                         __FILE__, __func__, __LINE__ ,
                         SPH_ERROR_INFO,
                         "Could not extract master_dff_long4_frame frames."
                         "Since this is an optional frame, this is ok "
                         "and this message is just informational. If you intended, "
                         "to use them check that they have the %s tag.",
                         SPH_IFS_TAG_DFF_LONG4_CALIB);
        cpl_error_reset();
    }

    else {

         rerr = cpl_frame_set_group( self->master_dff_long4_frame, CPL_FRAME_GROUP_CALIB );
    }

    aframe = cpl_frameset_find( self->inframes, SPH_IFS_TAG_DFF_LONGBB_CALIB );
    while ( aframe ) {
        cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
        aframe = cpl_frameset_find( self->inframes, NULL );
    }
    self->master_dff_longbb_frame = sph_utils_extract_frame( self->inframes, SPH_IFS_TAG_DFF_LONGBB_CALIB );
    if ( ! self->master_dff_longbb_frame )
    {
        sph_error_raise( SPH_IFS_DISTORTION_MAP_FRAMES_MISSING,
                         __FILE__, __func__, __LINE__ ,
                         SPH_ERROR_INFO,
                         "Could not extract master_dff_longbb_frame frames."
                         "Since this is an optional frame, this is ok "
                         "and this message is just informational. If you intended, "
                         "to use them check that they have the %s tag.",
                         SPH_IFS_TAG_DFF_LONGBB_CALIB);
        cpl_error_reset();
    }

    else {

         rerr = cpl_frame_set_group( self->master_dff_longbb_frame, CPL_FRAME_GROUP_CALIB );
    }

    aframe = cpl_frameset_find( self->inframes, SPH_IFS_TAG_DFF_SHORT_CALIB );
    while ( aframe ) {
        cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
        aframe = cpl_frameset_find( self->inframes, NULL );
    }
    self->master_dff_short_frame = sph_utils_extract_frame( self->inframes, SPH_IFS_TAG_DFF_SHORT_CALIB );
    if ( ! self->master_dff_short_frame )
    {
        sph_error_raise( SPH_IFS_DISTORTION_MAP_FRAMES_MISSING,
                         __FILE__, __func__, __LINE__ ,
                         SPH_ERROR_INFO,
                         "Could not extract master_dff_short_frame frames."
                         "Since this is an optional frame, this is ok "
                         "and this message is just informational. If you intended, "
                         "to use them check that they have the %s tag.",
                         SPH_IFS_TAG_DFF_SHORT_CALIB);
        cpl_error_reset();
    }

    else {

         rerr = cpl_frame_set_group( self->master_dff_short_frame, CPL_FRAME_GROUP_CALIB );
    }

    aframe = cpl_frameset_find( self->inframes, SPH_IFS_TAG_IFU_FLAT_CALIB );
    while ( aframe ) {
        cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
        aframe = cpl_frameset_find( self->inframes, NULL );
    }
    self->master_ifu_flat_frame = sph_utils_extract_frame( self->inframes, SPH_IFS_TAG_IFU_FLAT_CALIB );
    if ( ! self->master_ifu_flat_frame )
    {
        sph_error_raise( SPH_IFS_DISTORTION_MAP_FRAMES_MISSING,
                         __FILE__, __func__, __LINE__ ,
                         SPH_ERROR_INFO,
                         "Could not extract master_ifu_flat_frame frames."
                         "Since this is an optional frame, this is ok "
                         "and this message is just informational. If you intended, "
                         "to use them check that they have the %s tag.",
                         SPH_IFS_TAG_IFU_FLAT_CALIB);
        cpl_error_reset();
    }

    else {

         rerr = cpl_frame_set_group( self->master_ifu_flat_frame, CPL_FRAME_GROUP_CALIB );
    }

    aframe = cpl_frameset_find( self->inframes, SPH_IFS_TAG_CAL_BACKGROUND_CALIB );
    while ( aframe ) {
        cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
        aframe = cpl_frameset_find( self->inframes, NULL );
    }
    self->master_background_frame = sph_utils_extract_frame( self->inframes, SPH_IFS_TAG_CAL_BACKGROUND_CALIB );
    if ( ! self->master_background_frame )
    {
        sph_error_raise( SPH_IFS_DISTORTION_MAP_FRAMES_MISSING,
                         __FILE__, __func__, __LINE__ ,
                         SPH_ERROR_INFO,
                         "Could not extract master_background_frame frames."
                         "Since this is an optional frame, this is ok "
                         "and this message is just informational. If you intended, "
                         "to use them check that they have the %s tag.",
                         SPH_IFS_TAG_CAL_BACKGROUND_CALIB);
        cpl_error_reset();
    }

    else {

         rerr = cpl_frame_set_group( self->master_background_frame, CPL_FRAME_GROUP_CALIB );
    }

    aframe = cpl_frameset_find( self->inframes, SPH_IFS_TAG_DARK_CALIB );
    while ( aframe ) {
        cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
        aframe = cpl_frameset_find( self->inframes, NULL );
    }
    self->master_dark_frame = sph_utils_extract_frame( self->inframes, SPH_IFS_TAG_DARK_CALIB );
    if ( ! self->master_dark_frame )
    {
        sph_error_raise( SPH_IFS_DISTORTION_MAP_FRAMES_MISSING,
                         __FILE__, __func__, __LINE__ ,
                         SPH_ERROR_INFO,
                         "Could not extract master_dark_frame frames."
                         "Since this is an optional frame, this is ok "
                         "and this message is just informational. If you intended, "
                         "to use them check that they have the %s tag.",
                         SPH_IFS_TAG_DARK_CALIB);
        cpl_error_reset();
    }

    else {

         rerr = cpl_frame_set_group( self->master_dark_frame, CPL_FRAME_GROUP_CALIB );
    }

    aframe = cpl_frameset_find( self->inframes, SPH_IFS_TAG_STATIC_BADPIXELMAP_CALIB );
    while ( aframe ) {
        cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
        aframe = cpl_frameset_find( self->inframes, NULL );
    }
    self->static_badpixel_frame = sph_utils_extract_frame( self->inframes, SPH_IFS_TAG_STATIC_BADPIXELMAP_CALIB );
    if ( ! self->static_badpixel_frame )
    {
        sph_error_raise( SPH_IFS_DISTORTION_MAP_FRAMES_MISSING,
                         __FILE__, __func__, __LINE__ ,
                         SPH_ERROR_INFO,
                         "Could not extract static_badpixel_frame frames."
                         "Since this is an optional frame, this is ok "
                         "and this message is just informational. If you intended, "
                         "to use them check that they have the %s tag.",
                         SPH_IFS_TAG_STATIC_BADPIXELMAP_CALIB);
        cpl_error_reset();
    }

    else {

         rerr = cpl_frame_set_group( self->static_badpixel_frame, CPL_FRAME_GROUP_CALIB );
    }

    aframe = cpl_frameset_find( self->inframes, SPH_IFS_TAG_WAVE_CALIB_CALIB );
    while ( aframe ) {
        cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
        aframe = cpl_frameset_find( self->inframes, NULL );
    }
    self->wave_calib_frame = sph_utils_extract_frame( self->inframes, SPH_IFS_TAG_WAVE_CALIB_CALIB );
    if ( ! self->wave_calib_frame )
    {
        sph_error_raise( SPH_IFS_DISTORTION_MAP_FRAMES_MISSING,
                         __FILE__, __func__, __LINE__ ,
                         SPH_ERROR_ERROR,
                         "Could not extract wave_calib_frame frames."
                         "to use them check that they have the %s tag.",
                         SPH_IFS_TAG_WAVE_CALIB_CALIB);
        rerr = SPH_IFS_DISTORTION_MAP_FRAMES_MISSING;
        return rerr;
    }

    else {

         rerr = cpl_frame_set_group( self->wave_calib_frame, CPL_FRAME_GROUP_CALIB );
    }

    aframe = cpl_frameset_find( self->inframes, SPH_IFS_TAG_POINT_PATTERN );
    while ( aframe ) {
        cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
        aframe = cpl_frameset_find( self->inframes, NULL );
    }
    self->point_pattern_frame = sph_utils_extract_frame( self->inframes, SPH_IFS_TAG_POINT_PATTERN );
    if ( ! self->point_pattern_frame )
    {
        sph_error_raise( SPH_IFS_DISTORTION_MAP_FRAMES_MISSING,
                         __FILE__, __func__, __LINE__ ,
                         SPH_ERROR_INFO,
                         "Could not extract point_pattern_frame frames."
                         "Since this is an optional frame, this is ok "
                         "and this message is just informational. If you intended, "
                         "to use them check that they have the %s tag.",
                         SPH_IFS_TAG_POINT_PATTERN);
        cpl_error_reset();
    }

    else {

         rerr = cpl_frame_set_group( self->point_pattern_frame, CPL_FRAME_GROUP_CALIB );
    }

    aframe = cpl_frameset_find( self->inframes, SPH_IFS_TAG_PREAMP_FLAT );
    while ( aframe ) {
        cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
        aframe = cpl_frameset_find( self->inframes, NULL );
    }
    self->preamp_flat = sph_utils_extract_frame( self->inframes, SPH_IFS_TAG_PREAMP_FLAT );
    if ( ! self->preamp_flat )
    {
        sph_error_raise( SPH_IFS_DISTORTION_MAP_FRAMES_MISSING,
                         __FILE__, __func__, __LINE__ ,
                         SPH_ERROR_INFO,
                         "Could not extract preamp_flat frames."
                         "Since this is an optional frame, this is ok "
                         "and this message is just informational. If you intended, "
                         "to use them check that they have the %s tag.",
                         SPH_IFS_TAG_PREAMP_FLAT);
        cpl_error_reset();
    }

    else {

         rerr = cpl_frame_set_group( self->preamp_flat, CPL_FRAME_GROUP_CALIB );
    }

    /* End of code to check frames BUT ITS STILL NOT SAFE TO EDIT! FILE IS GENERATED !*/
    self->current_raw_frameset = sph_utils_extract_frames_group( self->inframes, CPL_FRAME_GROUP_RAW );

    return rerr;
}

/*----------------------------------------------------------------------------*/
/**
 @brief    Check the recipe parameters, and assign them to the sph_ifs_distortion_map
           structure.
 @param    self     the sph_ifs_distortion_map recipe structure
 @return   error code of the check.

 This checks the parameters that were given in the sph_ifs_distortion_map_new function
 as parameters for the correctness and completeness. If the parameters needed are
 found they are also assigned to the corresponding structure members.

 The return value is the error code of the check.
 */
/*----------------------------------------------------------------------------*/
sph_error_code sph_ifs_distortion_map_check_params( sph_ifs_distortion_map* self ) {
    sph_error_code                 rerr               = CPL_ERROR_NONE;
    const cpl_parameter*           param              = NULL;

    if ( self->framecomb_parameterlist != NULL ) {
        cpl_parameterlist_delete( self->framecomb_parameterlist );
        self->framecomb_parameterlist = NULL;
    }
    self->framecomb_parameterlist = cpl_parameterlist_new();
    /* Code to check parameters GENERATED DO NOT EDIT */

    param = cpl_parameterlist_find_const( self->inparams,
                                          "ifs.distortion_map.outfilename");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "ifs.distortion_map.outfilename");
    }

    self->distortion_map_filename = cpl_parameter_get_string(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    param = cpl_parameterlist_find_const( self->inparams,
                                          "ifs.distortion_map.ldt_outfilename");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "ifs.distortion_map.ldt_outfilename");
    }

    self->distortion_map_ldt_filename = cpl_parameter_get_string(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    param = cpl_parameterlist_find_const( self->inparams,
                                          "ifs.distortion_map.coll_alg");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "ifs.distortion_map.coll_alg");
    }

    self->coll_alg = cpl_parameter_get_int(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    param = cpl_parameterlist_find_const( self->inparams,
                                          "ifs.distortion_map.clean_mean.reject_high");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "ifs.distortion_map.clean_mean.reject_high");
    }

    self->clean_mean_reject_high = cpl_parameter_get_int(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    cpl_parameterlist_append( self->framecomb_parameterlist,
                              cpl_parameter_new_range( "clean_mean.reject_high",
                                                       CPL_TYPE_INT,
                                                       NULL,
                                                       NULL,
                                                       cpl_parameter_get_int( param ) ,
                                                       0,20
                                                      )
                            );

    param = cpl_parameterlist_find_const( self->inparams,
                                          "ifs.distortion_map.clean_mean.reject_low");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "ifs.distortion_map.clean_mean.reject_low");
    }

    self->clean_mean_reject_low = cpl_parameter_get_int(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    cpl_parameterlist_append( self->framecomb_parameterlist,
                              cpl_parameter_new_range( "clean_mean.reject_low",
                                                       CPL_TYPE_INT,
                                                       NULL,
                                                       NULL,
                                                       cpl_parameter_get_int( param ) ,
                                                       0,20
                                                      )
                            );

    param = cpl_parameterlist_find_const( self->inparams,
                                          "ifs.distortion_map.point_table_filename");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "ifs.distortion_map.point_table_filename");
    }

    self->pp_outfilename = cpl_parameter_get_string(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    param = cpl_parameterlist_find_const( self->inparams,
                                          "ifs.distortion_map.dither");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "ifs.distortion_map.dither");
    }

    self->dither = cpl_parameter_get_bool(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    param = cpl_parameterlist_find_const( self->inparams,
                                          "ifs.distortion_map.threshold");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "ifs.distortion_map.threshold");
    }

    self->threshold_sigma = cpl_parameter_get_double(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    param = cpl_parameterlist_find_const( self->inparams,
                                          "ifs.distortion_map.fitting_order");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "ifs.distortion_map.fitting_order");
    }

    self->polyfit_order = cpl_parameter_get_int(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    param = cpl_parameterlist_find_const( self->inparams,
                                          "ifs.distortion_map.max_distortion");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "ifs.distortion_map.max_distortion");
    }

    self->threshold_length = cpl_parameter_get_double(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    param = cpl_parameterlist_find_const( self->inparams,
                                          "ifs.distortion_map.self_check");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "ifs.distortion_map.self_check");
    }

    self->qc_consist_check = cpl_parameter_get_bool(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    param = cpl_parameterlist_find_const( self->inparams,
                                          "ifs.distortion_map.add_rotation");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "ifs.distortion_map.add_rotation");
    }

    self->rotate = cpl_parameter_get_double(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    /* End of code to check parameters BUT ITS STILL NOT SAFE TO EDIT! FILE IS GENERATED !*/

    return rerr;
}
/*----------------------------------------------------------------------------*/
/**
 @brief    Create a new sph_ifs_distortion_map structure.

 @param    frameset     the input recipe frames
 @param    parlist      the input recipe parameters

 @return   pointer to newly created structure or NULL in case of error

 This creates a new sph_ifs_distortion_map_structure and fills the inparams and
 inframes fields with the pointers pf frameset and parlist.
 The return value is the error code of the check.
 */
/*----------------------------------------------------------------------------*/
sph_ifs_distortion_map* sph_ifs_distortion_map_new( cpl_frameset * frameset,
                                              cpl_parameterlist * parlist )
{
    sph_ifs_distortion_map*    result      = NULL;
    int                     rerr        = CPL_ERROR_NONE;

    sph_init_erex();
    if ( frameset == NULL || parlist == NULL ) {
        sph_error_raise( CPL_ERROR_NULL_INPUT, __FILE__,
                         __func__, __LINE__,
                         SPH_ERROR_ERROR,
                         "Null input pointer.");
        return NULL;
    }

    result = cpl_calloc( 1, sizeof(sph_ifs_distortion_map) );

    if ( result == NULL ) {
        sph_error_raise( SPH_IFS_DISTORTION_MAP_GENERAL, __FILE__, __func__,
                         __LINE__, SPH_ERROR_ERROR,
                         "Could not allocate the structure.");
        return result;
    }

    result->inframes = frameset;
    result->inparams = parlist;

    rerr = sph_ifs_distortion_map_check_frames( result );
    if ( rerr == CPL_ERROR_NONE) rerr = sph_ifs_distortion_map_check_params( result );

    if ( rerr != CPL_ERROR_NONE ) {
        if ( result ) {
            sph_ifs_distortion_map_delete( result );
        }
        result = NULL;
    }

    return result;
}

/*----------------------------------------------------------------------------*/
/**
 @brief    Delete the sph_ifs_distortion_map structure.

 @param    self         the structure tp delete

 @return   error code of the operation

 This creates a new sph_ifs_distortion_map_structure and fills the inparams and
 inframes fields with the pointers pf frameset and parlist.
 The return value is the error code of the check.
 */
/*----------------------------------------------------------------------------*/
sph_error_code sph_ifs_distortion_map_delete( sph_ifs_distortion_map* self )
{
    sph_error_code          rerr            = CPL_ERROR_NONE;

    if ( self == NULL ) {
        sph_error_raise( CPL_ERROR_NULL_INPUT, __FILE__,
                         __func__, __LINE__,
                         SPH_ERROR_ERROR,
                         "Null input pointer.");
        return rerr;
    }

    if ( self->framecomb_parameterlist != NULL ) {
        cpl_parameterlist_delete( self->framecomb_parameterlist );
        self->framecomb_parameterlist = NULL;
    }

    /* Code to delete recipe pointers GENERATED DO NOT EDIT */

    if ( self->raw_frameset != NULL ) {
        cpl_frameset_delete( self->raw_frameset );
        self->raw_frameset = NULL;
    }
    if ( self->master_dff_long1_frame != NULL ) {
        cpl_frame_delete( self->master_dff_long1_frame );
        self->master_dff_long1_frame = NULL;
    }
    if ( self->master_dff_long2_frame != NULL ) {
        cpl_frame_delete( self->master_dff_long2_frame );
        self->master_dff_long2_frame = NULL;
    }
    if ( self->master_dff_long3_frame != NULL ) {
        cpl_frame_delete( self->master_dff_long3_frame );
        self->master_dff_long3_frame = NULL;
    }
    if ( self->master_dff_long4_frame != NULL ) {
        cpl_frame_delete( self->master_dff_long4_frame );
        self->master_dff_long4_frame = NULL;
    }
    if ( self->master_dff_longbb_frame != NULL ) {
        cpl_frame_delete( self->master_dff_longbb_frame );
        self->master_dff_longbb_frame = NULL;
    }
    if ( self->master_dff_short_frame != NULL ) {
        cpl_frame_delete( self->master_dff_short_frame );
        self->master_dff_short_frame = NULL;
    }
    if ( self->master_ifu_flat_frame != NULL ) {
        cpl_frame_delete( self->master_ifu_flat_frame );
        self->master_ifu_flat_frame = NULL;
    }
    if ( self->master_background_frame != NULL ) {
        cpl_frame_delete( self->master_background_frame );
        self->master_background_frame = NULL;
    }
    if ( self->master_dark_frame != NULL ) {
        cpl_frame_delete( self->master_dark_frame );
        self->master_dark_frame = NULL;
    }
    if ( self->static_badpixel_frame != NULL ) {
        cpl_frame_delete( self->static_badpixel_frame );
        self->static_badpixel_frame = NULL;
    }
    if ( self->wave_calib_frame != NULL ) {
        cpl_frame_delete( self->wave_calib_frame );
        self->wave_calib_frame = NULL;
    }
    if ( self->point_pattern_frame != NULL ) {
        cpl_frame_delete( self->point_pattern_frame );
        self->point_pattern_frame = NULL;
    }
    if ( self->preamp_flat != NULL ) {
        cpl_frame_delete( self->preamp_flat );
        self->preamp_flat = NULL;
    }
 
    /* End of code to delete pointers BUT ITS STILL NOT SAFE TO EDIT! FILE IS GENERATED !*/
    if ( self->current_raw_frameset ) {
        cpl_frameset_delete(self->current_raw_frameset);
        self->current_raw_frameset = NULL;
    }
    sph_polygon_free_all();
    cpl_free(    self);
    return rerr;

}


/**@}*/
