/* $Id: $
 * This file is part of the SPHERE Pipeline
 * Copyright (C) 2007-2010 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: $
 * $Date: $
 * $Revision: $
 * $Name: $
 */

#ifndef SPH_IFS_TAGS_H_
#define SPH_IFS_TAGS_H_

#define SPH_RECIPE_NAME_IFS_MASTER_DARK              "sph_ifs_master_dark"
#define SPH_RECIPE_NAME_IFS_RON              		  "sph_ifs_ron"
#define SPH_RECIPE_NAME_IFS_GAIN              		  "sph_ifs_gain"
#define SPH_RECIPE_NAME_IFS_MASTER_DFF               "sph_ifs_master_detector_flat"
#define SPH_RECIPE_NAME_IFS_IFF                      "sph_ifs_instrument_flat"
#define SPH_RECIPE_NAME_IFS_SPECTRA_POSITIONS        "sph_ifs_spectra_positions"
#define SPH_RECIPE_NAME_IFS_WAVE_CALIB               "sph_ifs_wave_calib"
#define SPH_RECIPE_NAME_IFS_SCIENCE_DR               "sph_ifs_science_dr"
#define SPH_RECIPE_NAME_IFS_STAR_CENTER               "sph_ifs_star_center"
#define SPH_RECIPE_NAME_IFS_SIMPLE_ADI               "sph_ifs_simple_adi"
#define SPH_RECIPE_NAME_IFS_DETECTOR_PERSISTENCE     "sph_ifs_detector_persistence"
#define SPH_RECIPE_NAME_IFS_DISTORTION_MAP           "sph_ifs_distortion_map"
#define SPH_RECIPE_NAME_IFS_CAL_BACKGROUND           "sph_ifs_cal_background"
#define SPH_RECIPE_NAME_IFS_DITHERING_EFFECTS        "sph_ifs_dithering_effects"
#define SPH_RECIPE_NAME_IFS_PSF_REFERENCE            "sph_ifs_psf_reference"
#define SPH_RECIPE_NAME_IFS_FLUX_CALIB               "sph_ifs_flux_calib"
#define SPH_RECIPE_NAME_IFS_STD_PHOT                 "sph_ifs_std_phot"
#define SPH_RECIPE_NAME_IFS_SKY_CAL                  "sph_ifs_sky_cal"
#define SPH_RECIPE_NAME_IFS_SKY_FLAT                 "sph_ifs_sky_flat"
#define SPH_RECIPE_NAME_IFS_ATMOSPHERIC              "sph_ifs_atmospheric"
#define SPH_RECIPE_NAME_IFS_ASTROMETRY               "sph_ifs_astrometry"
#define SPH_RECIPE_NAME_IFS_SPEC_DECONV              "sph_ifs_spec_deconv"
#define SPH_RECIPE_NAME_IFS_XTALK_CORRECTION         "sph_ifs_xtalk_correction"
#define SPH_RECIPE_NAME_IFS_BADPIX_CORRECTION        "sph_ifs_badpix_correction"
#define SPH_RECIPE_NAME_IFS_NEW_XTALK_CORRECTION     "sph_ifs_opti_xtalk_correction"
#define SPH_PIPELINE_NAME_IFS                        PACKAGE_STRING

#define SPH_IFS_TAG_SCIENCE_RAW               		 "IFS_SCIENCE_RAW"

#define SPH_IFS_TAG_XTALK_RAW                        "IFS_XTALK_RAW"
#define SPH_IFS_TAG_XTALK_COEFFICIENTS               "IFS_XTALK_COEFFS"

#define SPH_IFS_TAG_DARK_RAW                         "IFS_DARK_RAW"
#define SPH_IFS_TAG_DARK_CALIB                       "IFS_MASTER_DARK"

#define SPH_IFS_TAG_DFF_RAW                          "IFS_DETECTOR_FLAT_FIELD_RAW"
#define SPH_IFS_TAG_DFF_CALIB                        "IFS_MASTER_DETECTOR_FLAT_FIELD"
#define SPH_IFS_TAG_DFF_LONG_CALIB                   "IFS_MASTER_DFF_LONG1"
#define SPH_IFS_TAG_DFF_LONG1_CALIB                   "IFS_MASTER_DFF_LONG1"
#define SPH_IFS_TAG_DFF_LONG2_CALIB                   "IFS_MASTER_DFF_LONG2"
#define SPH_IFS_TAG_DFF_LONG3_CALIB                   "IFS_MASTER_DFF_LONG3"
#define SPH_IFS_TAG_DFF_LONG4_CALIB                   "IFS_MASTER_DFF_LONG4"
#define SPH_IFS_TAG_DFF_LONGBB_CALIB                   "IFS_MASTER_DFF_LONGBB"
#define SPH_IFS_TAG_DFF_SHORT_CALIB                  "IFS_MASTER_DFF_SHORT"
#define SPH_IFS_TAG_DFF_FIT_CALIB                  "IFS_MASTER_DETECTOR_FLAT_FIELD_FIT"

#define SPH_IFS_TAG_LSS_FLAT                          "IFS_LARGE_SCALE_FLAT"

#define SPH_IFS_TAG_PREAMP_FLAT                          "IFS_PREAMP_FLAT"

#define SPH_IFS_TAG_FLAT_RAW                         "IFS_FLAT_FIELD_RAW"
#define SPH_IFS_TAG_FLAT_CALIB                       "IFS_INSTRUMENT_FLAT_FIELD"

#define SPH_IFS_TAG_IFU_FLAT_CALIB                    "IFS_IFU_FLAT_FIELD"

#define SPH_IFS_TAG_WAVE_CALIB_RAW               "IFS_WAVECALIB_RAW"
#define SPH_IFS_TAG_WAVE_CALIB_CALIB             "IFS_WAVECALIB"
#define SPH_IFS_TAG_WAVE_CALIB_CUBE             "IFS_WAVECALIB_CUBE"

#define SPH_IFS_TAG_SPEC_POS_RAW                 "IFS_SPECPOS_RAW"
#define SPH_IFS_TAG_SPEC_POS_CALIB               "IFS_SPECPOS"

#define SPH_IFS_TAG_SCIENCE_DR_RAW                 "IFS_SCIENCE_DR_RAW"
#define SPH_IFS_TAG_SCIENCE_DR_CALIB               "IFS_SCIENCE_DR"

#define SPH_IFS_TAG_WAFFLE_IMAGE_RAW                 "IFS_STAR_CENTER_WAFFLE_RAW"
#define SPH_IFS_TAG_WAFFLE_IMAGE                     "IFS_STAR_CENTER_WAFFLE"
#define SPH_IFS_TAG_STAR_CENTER_CALIB               "IFS_STAR_CENTER"

#define SPH_IFS_TAG_STAR_CENTER_QC                  "IFS_STAR_CENTER_QC"

#define SPH_IFS_TAG_SPEC_DECONV_CALIB                   "IFS_SPEC_DECONV"
#define SPH_IFS_TAG_SPEC_DECONV_RAW               "IFS_SPEC_DECONV_RAW"

#define SPH_IFS_TAG_SKY_FLAT_RAW                 "IFS_SKY_FLAT_RAW"
#define SPH_IFS_TAG_SKY_FLAT_CALIB               "IFS_SKY_FLAT"

#define SPH_IFS_TAG_SKY_CAL_RAW                 "IFS_SKY_CAL_RAW"
#define SPH_IFS_TAG_SKY_CAL_CALIB               "IFS_SKY_CAL"
#define SPH_IFS_TAG_SKY_CAL_FIT_CALIB               "IFS_SKY_CAL_FIT"

#define SPH_IFS_TAG_FLUX_CALIB_RAW                 "IFS_FLUX_CALIB_RAW"
#define SPH_IFS_TAG_FLUX_CALIB_CALIB               "IFS_FLUX_CALIB"

#define SPH_IFS_TAG_STD_PHOT_RAW              "IFS_STD_PHOT_RAW"
#define SPH_IFS_TAG_STD_PHOT_CALIB            "IFS_STD_PHOT"

#define SPH_IFS_TAG_ATMOSPHERIC_RAW              "IFS_ATMOSPHERIC_RAW"
#define SPH_IFS_TAG_ATMOSPHERIC_CALIB            "IFS_ATMOSPHERIC"

#define SPH_IFS_TAG_ASTROMETRY_RAW              "IFS_ASTROMETRY_RAW"
#define SPH_IFS_TAG_ASTROMETRY_CALIB            "IFS_ASTROMETRY"

#define SPH_IFS_TAG_PSF_REFERENCE_RAW                 "IFS_PSF_REFERENCE_RAW"
#define SPH_IFS_TAG_PSF_REFERENCE_CALIB               "IFS_PSF_REFERENCE"

#define SPH_IFS_TAG_RON_RAW                 "IFS_RON_RAW"
#define SPH_IFS_TAG_RON_CALIB               "IFS_RON"

#define SPH_IFS_TAG_DITHERING_EFFECTS_RAW                 "IFS_DITHERING_EFFECTS_RAW"
#define SPH_IFS_TAG_DITHERING_EFFECTS_CALIB               "IFS_DITHERING_EFFECTS"

#define SPH_IFS_TAG_GAIN_RAW                 "IFS_GAIN_RAW"
#define SPH_IFS_TAG_GAIN_CALIB               "IFS_GAIN"
#define SPH_IFS_TAG_NONLIN_CALIB               "IFS_NONLIN"
#define SPH_IFS_TAG_NONLINBAD_CALIB               "IFS_NONLIN_BADPIX"

#define SPH_IFS_TAG_CAL_BACKGROUND_RAW       "IFS_CAL_BACKGROUND_RAW"
#define SPH_IFS_TAG_CAL_BACKGROUND_CALIB               "IFS_CAL_BACKGROUND"
#define SPH_IFS_TAG_CAL_BACKGROUND_FIT_CALIB               "IFS_CAL_BACKGROUND_FIT"

#define SPH_IFS_TAG_DETECTOR_PERSISTENCE_OFF_RAW             "IFS_DETECTOR_PERSISTENCE_OFF_RAW"
#define SPH_IFS_TAG_DETECTOR_PERSISTENCE_ON_UNSAT_RAW        "IFS_DETECTOR_PERSISTENCE_ON_UNSAT_RAW"
#define SPH_IFS_TAG_DETECTOR_PERSISTENCE_ON_SAT_RAW          "IFS_DETECTOR_PERSISTENCE_ON_SAT_RAW"
#define SPH_IFS_TAG_DETECTOR_PERSISTENCE_CALIB               "IFS_DETECTOR_PERSISTENCE"

#define SPH_IFS_TAG_POINT_PATTERN						"IFS_POINT_PATTERN"

#define SPH_IFS_TAG_DISTORTION_MAP_RAW                 "IFS_DISTORTION_MAP_RAW"
#define SPH_IFS_TAG_DISTORTION_MAP_CALIB               "IFS_DISTORTION_MAP"
#define SPH_IFS_TAG_DISTORTION_MAP_REDUCED             "IFS_DISTORTION_MAP_REDUCED"
#define SPH_IFS_DISTORTION_MAP_TAG_VALID_SETTINGS 		"IFS_DISTORTION_MAP_TAG_VALID_SETTINGS"

#define SPH_IFS_TAG_HOTPIXELMAP_CALIB     "IFS_HOTPIXELMAP"
#define SPH_IFS_TAG_STATIC_BADPIXELMAP_CALIB     "IFS_STATIC_BADPIXELMAP"
#define SPH_IFS_TAG_NON_LINEAR_PIXELMAP_CALIB     "IFS_NON_LINEAR_PIXELMAP"

#define SPH_IFS_TAG_DISPERSION_MODEL_CALIB       "IFS_DISPERSION_MODEL"

#define SPH_IFS_TAG_SIMPLE_ADI_RAW       "IFS_SIMPLE_ADI_RAW"
#define SPH_IFS_TAG_SIMPLE_ADI_CALIB           "IFS_SIMPLE_ADI"

#define SPH_IFS_TAG_BADPIXEL_CORRECTION    "IFS_BADPIXEL_CORRECTION"
#define SPH_IFS_TAG_NEW_XTALK_CORRECTION   "IFS_OPTI_XTALK_CORRECTION"

#define SPH_IFS_TAG_CALIB_LINES_TABLE_CALIB      "IFS_CALIBRATION_LINES TABLE"
#define SPH_IFS_TAG_LENSLET_MODEL_CALIB          "IFS_LENSLET_MODEL"
#define SPH_IFS_MASTER_DARK_TAG_VALID_SETTINGS   "IFS_MASTER_DARK_SETTINGS"
#define SPH_IFS_RON_TAG_VALID_SETTINGS   "IFS_RON_SETTINGS"
#define SPH_IFS_GAIN_TAG_VALID_SETTINGS   "IFS_GAIN_SETTINGS"
#define SPH_IFS_CAL_BACKGROUND_TAG_VALID_SETTINGS   "IFS_CAL_BACKGROUND_SETTINGS"
#define SPH_IFS_DETECTOR_PERSISTENCE_TAG_VALID_SETTINGS   "IFS_DETECTOR_PERSISTENCE_SETTINGS"
#define SPH_IFS_MASTER_DETECTOR_FLAT_TAG_VALID_SETTINGS   "IFS_MASTER_DFF_SETTINGS"
#define SPH_IFS_INSTRUMENT_FLAT_TAG_VALID_SETTINGS   "IFS_MASTER_IFF_SETTINGS"
#define SPH_IFS_SPECTRA_POSITIONS_TAG_VALID_SETTINGS   "IFS_SPECTRA_POSITIONS_SETTINGS"
#define SPH_IFS_WAVE_CALIB_TAG_VALID_SETTINGS   "IFS_WAVE_CALIB_SETTINGS"

#define SPH_IFS_SCIENCE_DR_TAG_VALID_SETTINGS "IFS_SCIENCE_DR_TAG_VALID_SETTINGS"

#endif /* SPH_IFS_TAGS_H_ */
