/***********************************************************************************************/
/******** DANGER !! DANGER !! DANGER !! DO NOT EDIT FILE -- IT WAS GENERATED AUTOMATICALLY !!! */
/***********************************************************************************************/

/* $Id: $
 * This file is part of the SPHERE Pipeline
 * Copyright (C) 2007-2010 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: $
 * $Date: $
 * $Revision: $
 * $Name: $
 */

/*-----------------------------------------------------------------------------
 Includes
 -----------------------------------------------------------------------------*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "sph_ird_andromeda.h"
#include "sph_common_keywords.h"
#include "sph_ird_keywords.h"
#include "sph_ird_tags.h"
#include "sph_master_frame.h"
#include "sph_error.h"
#include "sph_cube.h"
#include "sph_utils.h"

#include <math.h>
#include <assert.h>
#include <cpl.h>

/*-----------------------------------------------------------------------------
  Error Codes
 -----------------------------------------------------------------------------*/

sph_error_code SPH_IRD_ANDROMEDA_GENERAL              = SPH_IRD_ANDROMEDA_ERR_START + 0;
sph_error_code SPH_IRD_ANDROMEDA_NO_VALID_DIT_LIST    = SPH_IRD_ANDROMEDA_ERR_START + 1;

sph_error_code SPH_IRD_ANDROMEDA_PARAMETER_MISSING    = SPH_IRD_ANDROMEDA_ERR_START + 3;
sph_error_code SPH_IRD_ANDROMEDA_FRAMES_MISSING       = SPH_IRD_ANDROMEDA_ERR_START + 4;

/*-----------------------------------------------------------------------------
 Private function prototypes
 -----------------------------------------------------------------------------*/

static int sph_ird_andromeda_create_plugin ( cpl_plugin * );
static int sph_ird_andromeda_exec_plugin ( cpl_plugin * );
static int sph_ird_andromeda_destroy_plugin ( cpl_plugin * );

/*-----------------------------------------------------------------------------
 Static variables
 -----------------------------------------------------------------------------*/

static const char* sph_ird_andromeda_help = 
    "RECIPE INPUT FRAMES: \n"
    "-------------------- \n"
    "Tag                           Min,Max   Description\n"
    "IRD_ANDROMEDA_RAW               1, -1   The raw science frames.\n"
    "IRD_MASTER_DARK                 1,  1   The master dark frame. Should have the same DIT and readout mode\n"
    "                                        as the raw frames.\n"
    "IRD_FLAT_FIELD                  1,  1   The instrument flat. Should have the same filter set as the\n"
    "                                        raw frames.\n"
    "IRD_DISTORTION_MAP              0,  1   The distortion map frame.\n"
    "IRD_STAR_CENTER                 0,  1   The field center frame. This frame must be as produced by the\n"
    "                                        star center recipe. If none are provided the recipe attempts\n"
    "                                        a fallback solution or makes use of the optional ASCII field center tables if provided.\n"
    "IRD_FCTABLE                     0, -1   Alternative input of set of of files of ASCII tables. The tables should each give one row\n"
    "                                        for each input science image (so, if e.g.  5 cubes of each 10 planes are this\n"
    "                                        frameset should contain 5 tables with 10 rows) with the columns centre-x centre-y centre-x centre-y angle\n"
    "                                        where centers for left and right field of view are given in pixel coordinates inside\n"
    "                                        the left/right subframe.\n"
    "IRD_FILTER_TABLE                0,  1   A filter table, used to determine SDI scaling.\n"
    "                                        This is a static calibration frame of an ASCII table defining the IRDIS filters. It is\n"
    "                                        only used if SDI is selected.\n"
    "                                        The format of this table is:\n"
    "                                        <filter name>         <central wavelength total or left FOV (microns)>   <central wavelength right or 0>\n"
    "                                        with one line for every filter. The first line is treated as the default filter in case that there are\n"
    "                                        insufficient keywords to determine the filtername in the RAW input frames.\n"
    "IRD_PSF_REFERENCE               1,  1   The PSF reference frame. This frame must contain reference PSF.\n"
    "IRD_STATIC_BADPIXELMAP          0,  1   An optional static badpixelmap. If a dark is given the badpixels\n"
    "                                        that are masked out before the fit are all pixels marked as bad\n"
    "                                        in this as well as in the dark frame. If no dark is given pixels\n"
    "                                        marked in this frame are marked as bad in the raw frames.\n"
    "\n"
    "RAW FRAME KEYWORDS: \n"
    "-------------------- \n"
    "Keyword                       Type   Optional  Description\n"
    "ESO DRS IRD DUAL FILTER LAMBDA LEFTdouble Yes       The central wavelength of the filter on left. Only needed if SDI requested. \n"
    "ESO DRS IRD DUAL FILTER LAMBDA RIGHTdouble Yes       The central wavelength of the filter on right. Only needed if SDI requested. \n"
    "ESO INS1 PAC X                double No        The dithering position in X for the frame in pixels. \n"
    "ESO INS1 PAC Y                double No        The dithering position in Y for the frame in pixels. \n"
    "ESO INS CPRT POSANG           double Yes       The rotation angle of frame in degrees. \n"
    "\n"
    "DESCRIPTION:\n"
    "------------\n"
    "This recipe uses the Andromeda algorithm (Mugnier et al. 2008) for\n"
    "planet detection. The recipe has been implemented in C following the IDL script obtained\n"
    "from L. Mugnier as much as possible.\n"
    "\n"
    "The basic reduction of raw frames follows that of the other IRDIS science recipes, in particular\n"
    "dark subtraction, flat fielding and frame centering is done as for the science_dbi recipe.\n"
    "Please see the science_dbi recipe for more details.\n"
    "Andromeda can also be used in combination with SDI by switching the use_sdi flag to TRUE.\n"
    "\n"
    "The current version is only a first attempt -- please use with care.\n"
    "KNOWN ISSUES:\n"
    "-------------\n"
    "The recipe result if very sensitive to the input parameter choice and we believe this may\n"
    "indicate a bug somewhere. We also found that obtaining useful results on some input data\n"
    "is not possible.\n"
    "\n"
    "RECIPE PRODUCTS: \n"
    "-------------------- \n"
    "Tag                      Format         Description\n"
    "IRD_ANDROMEDA                      FITS[Im(4)]    The main science frame. The FITS file contains 4 extensions: the image, the\n"
    "                                        badpixels, the rms error and a weightmap. All show the whole detector.\n"
    "\n"
    "PRODUCT FRAME KEYWORDS: \n"
    "-------------------- \n"
    "Keyword                       Frame          Type    Description\n"
    "\n"
;

/*-----------------------------------------------------------------------------
 Function code
 -----------------------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/
/**
 * @defgroup sph_ird_andromeda Create Master Dark Recipe
 *
 * This module provides the recipe plugin and relating functions for the
 * creation of the master dark .
 *
 * @par Synopsis:
 * @code
 *   #include "sph_ird_andromeda.h"
 * @endcode
 */
/*----------------------------------------------------------------------------*/
/**@{*/

/*****************************************************************************
 *
 *
 *      First come the static and global functions necessary for the
 *      normal working of the recipe as plugin....
 *
 *
 * ***************************************************************************/
/*----------------------------------------------------------------------------*/
/**
 @brief    Build the list of available plugins, for this module.
 @param    list    the plugin list
 @return   0 if everything is ok, 1 otherwise
 @note     Only this function is exported

 Create the recipe instance and make it available to the application
 using the interface.
 */
/*----------------------------------------------------------------------------*/
int cpl_plugin_get_info(cpl_pluginlist * list)
{
    cpl_recipe * recipe = cpl_calloc( 1, sizeof *recipe);
    cpl_plugin * plugin = &recipe->interface;

    if (cpl_plugin_init(plugin,
                        CPL_PLUGIN_API,
                        SPH_IRD_ANDROMEDA_VERSION,
                        CPL_PLUGIN_TYPE_RECIPE,
                        "sph_ird_andromeda",
                        "Andromeda recipe.",
                        sph_ird_andromeda_help, "Ole Moeller-Nilsson <moeller@mpia-hd.mpg.de>",
                        "https://support.eso.org", cpl_get_license("SPHERE DRH","2012"),
                        sph_ird_andromeda_create_plugin,
                        sph_ird_andromeda_exec_plugin,
                        sph_ird_andromeda_destroy_plugin) )
    {
        cpl_msg_error( cpl_func, "Plugin initialization failed");
        (void)cpl_error_set_where( cpl_func );
        return 1;
    }

    if (cpl_pluginlist_append(list, plugin) )
    {
        cpl_msg_error( cpl_func, "Error adding plugin to list");
        (void)cpl_error_set_where( cpl_func );
        return 1;
    }
    return 0;
}

/*----------------------------------------------------------------------------*/
/**
 @brief    Setup the recipe options
 @param    plugin  the plugin
 @return   0 if everything is ok

 Defining the command-line/configuration parameters for the recipe.
 */
/*----------------------------------------------------------------------------*/
static int sph_ird_andromeda_create_plugin(cpl_plugin * plugin)
{
    if (cpl_error_get_code() != CPL_ERROR_NONE)
    {
        cpl_msg_error( cpl_func, "%s():%d: An error is already set: %s",
                       cpl_func, __LINE__, cpl_error_get_where());
        return (int)cpl_error_get_code();
    }

    if (plugin == NULL)
    {
        cpl_msg_error(cpl_func, "Null plugin");
        cpl_ensure_code(0, (int)CPL_ERROR_NULL_INPUT);
    }

    if (cpl_plugin_get_type(plugin) != CPL_PLUGIN_TYPE_RECIPE)
    {
        cpl_msg_error( cpl_func, "Plugin is not a recipe");
        cpl_ensure_code( 0, (int)CPL_ERROR_TYPE_MISMATCH );
    }

    if ( plugin != NULL ) {
        cpl_recipe * recipe = (cpl_recipe *)plugin;
        recipe->parameters = sph_ird_andromeda_create_paramlist();
        if ( recipe->parameters == NULL ) {
            return SPH_IRD_ANDROMEDA_GENERAL;
        }
    }
    return 0;
}

/*----------------------------------------------------------------------------*/
/**
 @brief    Testing for setup of the recipe options
 @param    plugin  the plugin
 @return   0 if everything is ok

 Wrapper to make the static plugin creation function accessible from outside
 for testing purposes.
 */
/*----------------------------------------------------------------------------*/
int sph_ird_andromeda_create_test(cpl_plugin * plugin)
{
    return (int)sph_ird_andromeda_create_plugin(plugin);
}

/*----------------------------------------------------------------------------*/
/**
 @brief    Execute the plugin instance given by the interface
 @param    plugin  the plugin
 @return   0 if everything is ok
 */
/*----------------------------------------------------------------------------*/
static int sph_ird_andromeda_exec_plugin(cpl_plugin * plugin)
{

    cpl_recipe*             recipe                  = NULL;
    cpl_error_code          recipe_code;
    sph_ird_andromeda*    sph_recipe      = NULL;
    cpl_errorstate          initial_errorstate      = cpl_errorstate_get();

    if (cpl_error_get_code() != CPL_ERROR_NONE)
    {
        cpl_msg_error( cpl_func, "%s():%d: A cpl error is already set: %s",
        cpl_func, __LINE__, cpl_error_get_where());
        return (int)cpl_error_get_code();
    }

    if (plugin == NULL)
    {
        cpl_msg_error( cpl_func, "Null plugin");
        cpl_ensure_code( 0, (int)CPL_ERROR_NULL_INPUT );
        return (int)cpl_error_get_code();
    }

    if (cpl_plugin_get_type(plugin) != CPL_PLUGIN_TYPE_RECIPE)
    {
        cpl_msg_error( cpl_func, "Plugin is not a recipe");
        cpl_ensure_code( 0, (int)CPL_ERROR_TYPE_MISMATCH );
        return (int)cpl_error_get_code();
    }

    recipe = (cpl_recipe *)plugin;

    if (recipe->parameters == NULL)
    {
        cpl_msg_error( cpl_func, "Recipe invoked with NULL parameter list");
        cpl_ensure_code( 0, (int)CPL_ERROR_NULL_INPUT );
        return (int)cpl_error_get_code();
    }

    if (recipe->frames == NULL)
    {
        cpl_msg_error( cpl_func, "Recipe invoked with NULL frame set");
        cpl_ensure_code( 0, (int)CPL_ERROR_NULL_INPUT );
        return (int)cpl_error_get_code();
    }

    sph_recipe = sph_ird_andromeda_new( recipe->frames, recipe->parameters );
    if ( sph_recipe == NULL ) {
        recipe_code = cpl_error_set_where(cpl_func);
    } else {

        recipe_code = sph_ird_andromeda_run( sph_recipe );

        sph_ird_andromeda_delete( sph_recipe );
    }

    if ( !cpl_errorstate_is_equal(initial_errorstate) )
    {
        cpl_errorstate_dump(initial_errorstate, CPL_FALSE, NULL);
    }
    sph_end_erex(); //close the sphere system
    return (int)(recipe_code >= CPL_ERROR_EOL /* Workaround esorex PIPE-6887 */
                 ? CPL_ERROR_EOL : recipe_code);
}

/*----------------------------------------------------------------------------*/
/**
 @brief    Destroy what has been created by the 'create' function
 @param    plugin  the plugin
 @return   0 if everything is ok
 */
/*----------------------------------------------------------------------------*/
static int sph_ird_andromeda_destroy_plugin(cpl_plugin * plugin)
{
    cpl_recipe * recipe;

    if (plugin == NULL)
    {
        cpl_msg_error( cpl_func, "Null plugin");
        cpl_ensure_code( 0, (int)CPL_ERROR_NULL_INPUT );
    }

    if (cpl_plugin_get_type(plugin) != CPL_PLUGIN_TYPE_RECIPE)
    {
        cpl_msg_error( cpl_func, "Plugin is not a recipe");
        cpl_ensure_code( 0, (int)CPL_ERROR_TYPE_MISMATCH );
    }

    recipe = (cpl_recipe *)plugin;

    cpl_parameterlist_delete(recipe->parameters);

    return 0;
}

/*****************************************************************************
 *
 *
 *      Here come the "Member" functions of the sph_ird_andromeda struct
 *
 *
 * ***************************************************************************/

/*----------------------------------------------------------------------------*/
/**
 @brief    Fill a pre-allocated parameterlist for the recipe
 @param    result A pre-allocated parameterlist
 @return   CPL_ERROR_NONE iff successful

 This function fills the standard parameterlist for the recipe

 */
/*----------------------------------------------------------------------------*/
static cpl_error_code sph_ird_andromeda_fill_parameterlist(cpl_parameterlist * result)
{
    cpl_parameter* p;

        /* Code to set up parameters GENERATED DO NOT EDIT */

        p = cpl_parameter_new_value("ird.andromeda.outfilename",
                                   CPL_TYPE_STRING,
                                   "The output filename for the product. Please also see the esorex documentation "
                                   "for naming of output products. "
                                   ,"ird.andromeda",
                                   "andromeda.fits" );

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_value("ird.andromeda.left_filename",
                                   CPL_TYPE_STRING,
                                   "The output filename for the left list after pre-processing. "
                                   "Only used if only_prep flag is set. "
                                   "Please also see the esorex documentatio for naming of output products. "
                                   ,"ird.andromeda",
                                   "left_list.fits" );

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_value("ird.andromeda.right_filename",
                                   CPL_TYPE_STRING,
                                   "The output filename for the left list after pre-processing. "
                                   "Only used if only_prep flag is set. "
                                   "Please also see the esorex documentatio for naming of output products. "
                                   ,"ird.andromeda",
                                   "right_list.fits" );

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_value("ird.andromeda.keep_fctable",
                                   CPL_TYPE_BOOL,
                                   "if set to TRUE the recipes internall created field center tables are not deleted. "
                                   ,"ird.andromeda",
                                   0 );

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_enum("ird.andromeda.coll_alg",
                                   CPL_TYPE_INT,
                                   "The collapse algorithm to use. 0 = Mean, 1 = Median, 2 = Clean mean. "
                                   ,"ird.andromeda",
                                   2 ,
                                   3,0,1,2);

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_range("ird.andromeda.clean_mean.reject_high",
                                   CPL_TYPE_INT,
                                   "The clean mean reject pixels on high end. "
                                   ,"ird.andromeda",
                                   1 ,
                                   0,20);

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_range("ird.andromeda.clean_mean.reject_low",
                                   CPL_TYPE_INT,
                                   "The clean mean reject pixels on low end. "
                                   ,"ird.andromeda",
                                   1 ,
                                   0,20);

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_value("ird.andromeda.use_sdi",
                                   CPL_TYPE_BOOL,
                                   "Flag to control usage of SDI "
                                   ,"ird.andromeda",
                                   0 );

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_range("ird.andromeda.window_minx",
                                   CPL_TYPE_INT,
                                   "Window region andromeda is applied to. "
                                   ,"ird.andromeda",
                                   428 ,
                                   0,1024);

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_range("ird.andromeda.window_miny",
                                   CPL_TYPE_INT,
                                   "Window region andromeda is applied to. "
                                   ,"ird.andromeda",
                                   428 ,
                                   0,1024);

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_range("ird.andromeda.window_maxx",
                                   CPL_TYPE_INT,
                                   "Window region andromeda is applied to. "
                                   ,"ird.andromeda",
                                   628 ,
                                   0,1024);

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_range("ird.andromeda.window_maxy",
                                   CPL_TYPE_INT,
                                   "Window region andromeda is applied to. "
                                   ,"ird.andromeda",
                                   628 ,
                                   0,1024);

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_range("ird.andromeda.psf_size",
                                   CPL_TYPE_INT,
                                   "The size of the reference PSF. A central window of this size is "
                                   "extracted from the input PSF reference frame to create the PSF "
                                   "reference image to use by andromeda. "
                                   ,"ird.andromeda",
                                   32 ,
                                   0,128);

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_value("ird.andromeda.only_prep",
                                   CPL_TYPE_BOOL,
                                   "Flag to switch off andromeda so only preperatory steps are performed: "
                                   "these are dark subtraction and flat fielding, frame cropping, "
                                   "frame centering and scaling (if SDI is on). "
                                   ,"ird.andromeda",
                                   0 );

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_range("ird.andromeda.min_ang_sep",
                                   CPL_TYPE_DOUBLE,
                                   "The minimum angle seperatrion to use to create the image pairs "
                                   "for image differencing. "
                                   ,"ird.andromeda",
                                   1.0 ,
                                   0.0,45.0);

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_range("ird.andromeda.rho_min",
                                   CPL_TYPE_DOUBLE,
                                   "The minimum radius to search for. "
                                   ,"ird.andromeda",
                                   1.0 ,
                                   0.0,200.0);

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_range("ird.andromeda.rho_max",
                                   CPL_TYPE_DOUBLE,
                                   "The maximum radius to search for. "
                                   ,"ird.andromeda",
                                   10.0 ,
                                   0.0,200.0);

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_range("ird.andromeda.filter_radius",
                                   CPL_TYPE_DOUBLE,
                                   "Filter radius for ADI frame combination. A non zero value leads to suppression "
                                   "of high frequencies in the fourier domain before frame combination. The value "
                                   "expresses the minimum unsuppressed frequency as fraction of total frequency "
                                   "domain radius (a value of 1 would suppress essentially all frequencies). "
                                   ,"ird.andromeda",
                                   0.0 ,
                                   0.0,1.0);

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        /* End of code to set up parameters BUT ITS STILL NOT SAFE TO EDIT! FILE IS GENERATED !*/

    return cpl_error_set_where(cpl_func);
}
/*----------------------------------------------------------------------------*/
/**
 @brief  Create and return the standard parameterlist for the recipe
 @return The standard parameterlist or NULL on error
 @note   The returned object must be deallocated using cpl_parameterlist_delete

 */
/*----------------------------------------------------------------------------*/
cpl_parameterlist* sph_ird_andromeda_create_paramlist(void)
{
    cpl_parameterlist* self = cpl_parameterlist_new();

    if (sph_ird_andromeda_fill_parameterlist(self)) {
        cpl_parameterlist_delete(self);
        self = NULL;
        (void)cpl_error_set_where(cpl_func);
    }

    return self;
}

/*----------------------------------------------------------------------------*/
/**
 @brief    Check the recipe frames, and assign them to the sph_ird_andromeda
           structure.
 @param    self     the sph_ird_andromeda recipe structure
 @return   error code of the check.

 This checks the frames that were given in the sph_ird_andromeda_new function
 as parameters for the correctness and completeness. If the frames needed are
 found they are also assigned to the corresponding structure members.

 The return value is the error code of the check.
 */
/*----------------------------------------------------------------------------*/
sph_error_code  sph_ird_andromeda_check_frames( sph_ird_andromeda* self )
{
    sph_error_code           rerr            = CPL_ERROR_NONE;
    /* Code to check frames GENERATED DO NOT EDIT */

    cpl_frame* aframe;
    aframe = cpl_frameset_find( self->inframes, SPH_IRD_TAG_ANDROMEDA_RAW );
    while ( aframe ) {
        cpl_frame_set_group( aframe, CPL_FRAME_GROUP_RAW );
        aframe = cpl_frameset_find( self->inframes, NULL );
    }
    self->rawframes = sph_utils_extract_frames( self->inframes, SPH_IRD_TAG_ANDROMEDA_RAW );
    if ( ! self->rawframes )
    {
        sph_error_raise( SPH_IRD_ANDROMEDA_FRAMES_MISSING,
                         __FILE__, __func__, __LINE__ ,
                         SPH_ERROR_ERROR,
                         "Could not extract rawframes frames."
                         "to use them check that they have the %s tag.",
                         SPH_IRD_TAG_ANDROMEDA_RAW);
        rerr = SPH_IRD_ANDROMEDA_FRAMES_MISSING;
        return rerr;
    }

    else {

         int numframes = (int)cpl_frameset_get_size( self->rawframes );
         for ( int ii = 0; ii < numframes; ++ii ) {
             cpl_frame* iframe = cpl_frameset_get_position( self->rawframes, ii );
             const char* ifname = cpl_frame_get_filename(iframe);
             cpl_propertylist* pl = cpl_propertylist_load(ifname, 0);
             if (pl == NULL ) {
                 sph_error_raise(cpl_error_get_code(),
                    __FILE__, __func__, __LINE__ ,SPH_ERROR_ERROR,
                 "Could not read keywords from file %s. "
                 "Either the file is not readable or corrupted. ",
                  ifname);
             }
             else {
                 rerr = cpl_frame_set_group( iframe, CPL_FRAME_GROUP_RAW );
                 int haskey, okval;
                 haskey = 0;okval = 0;
                 if ( cpl_propertylist_has(pl,"ESO INS1 PAC X") )  {
                     haskey = 1;
                     if ( cpl_propertylist_get_type(pl,"ESO INS1 PAC X") == CPL_TYPE_DOUBLE )  {
                         if ( cpl_propertylist_get_double(pl,"ESO INS1 PAC X") >= -5000.0 && 
                             cpl_propertylist_get_double(pl,"ESO INS1 PAC X") <= 5000.0) okval=1;
                     } 
                     if ( haskey == 0 || okval == 0 ) {
                         sph_error_raise(CPL_ERROR_ILLEGAL_INPUT,
                            __FILE__, __func__, __LINE__ ,SPH_ERROR_ERROR,
                         "Could not read a keyword ESO INS1 PAC X from file %s. "
                         "that has __type double "
                         "and values between -5000.0 and 5000.0 "
                         "The recipe requires this. ",
                         ifname);
                     }
                 }
                 haskey = 0;okval = 0;
                 if ( cpl_propertylist_has(pl,"ESO INS1 PAC Y") )  {
                     haskey = 1;
                     if ( cpl_propertylist_get_type(pl,"ESO INS1 PAC Y") == CPL_TYPE_DOUBLE )  {
                         if ( cpl_propertylist_get_double(pl,"ESO INS1 PAC Y") >= -5000.0 && 
                             cpl_propertylist_get_double(pl,"ESO INS1 PAC Y") <= 5000.0) okval=1;
                     } 
                     if ( haskey == 0 || okval == 0 ) {
                         sph_error_raise(CPL_ERROR_ILLEGAL_INPUT,
                            __FILE__, __func__, __LINE__ ,SPH_ERROR_ERROR,
                         "Could not read a keyword ESO INS1 PAC Y from file %s. "
                         "that has __type double "
                         "and values between -5000.0 and 5000.0 "
                         "The recipe requires this. ",
                         ifname);
                     }
                 }
                 cpl_propertylist_delete(pl); pl=NULL;
             }
         }
         numframes -= (int)cpl_frameset_get_size( self->rawframes );
         assert( numframes == 0);
    }

    aframe = cpl_frameset_find( self->inframes, SPH_IRD_TAG_DARK_CALIB );
    while ( aframe ) {
        cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
        aframe = cpl_frameset_find( self->inframes, NULL );
    }
    self->dark_frame = sph_utils_extract_frame( self->inframes, SPH_IRD_TAG_DARK_CALIB );
    if ( ! self->dark_frame )
    {
        sph_error_raise( SPH_IRD_ANDROMEDA_FRAMES_MISSING,
                         __FILE__, __func__, __LINE__ ,
                         SPH_ERROR_ERROR,
                         "Could not extract dark_frame frames."
                         "to use them check that they have the %s tag.",
                         SPH_IRD_TAG_DARK_CALIB);
        rerr = SPH_IRD_ANDROMEDA_FRAMES_MISSING;
        return rerr;
    }

    else {

         rerr = cpl_frame_set_group( self->dark_frame, CPL_FRAME_GROUP_CALIB );
    }

    aframe = cpl_frameset_find( self->inframes, SPH_IRD_TAG_FLAT_CALIB );
    while ( aframe ) {
        cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
        aframe = cpl_frameset_find( self->inframes, NULL );
    }
    self->flat_frame = sph_utils_extract_frame( self->inframes, SPH_IRD_TAG_FLAT_CALIB );
    if ( ! self->flat_frame )
    {
        sph_error_raise( SPH_IRD_ANDROMEDA_FRAMES_MISSING,
                         __FILE__, __func__, __LINE__ ,
                         SPH_ERROR_ERROR,
                         "Could not extract flat_frame frames."
                         "to use them check that they have the %s tag.",
                         SPH_IRD_TAG_FLAT_CALIB);
        rerr = SPH_IRD_ANDROMEDA_FRAMES_MISSING;
        return rerr;
    }

    else {

         rerr = cpl_frame_set_group( self->flat_frame, CPL_FRAME_GROUP_CALIB );
    }

    aframe = cpl_frameset_find( self->inframes, SPH_IRD_TAG_DISTORTION_MAP_CALIB );
    while ( aframe ) {
        cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
        aframe = cpl_frameset_find( self->inframes, NULL );
    }
    self->distmap_frame = sph_utils_extract_frame( self->inframes, SPH_IRD_TAG_DISTORTION_MAP_CALIB );
    if ( ! self->distmap_frame )
    {
        sph_error_raise( SPH_IRD_ANDROMEDA_FRAMES_MISSING,
                         __FILE__, __func__, __LINE__ ,
                         SPH_ERROR_INFO,
                         "Could not extract distmap_frame frames."
                         "Since this is an optional frame, this is ok "
                         "and this message is just informational. If you intended, "
                         "to use them check that they have the %s tag.",
                         SPH_IRD_TAG_DISTORTION_MAP_CALIB);
        cpl_error_reset();
    }

    else {

         rerr = cpl_frame_set_group( self->distmap_frame, CPL_FRAME_GROUP_CALIB );
    }

    aframe = cpl_frameset_find( self->inframes, SPH_IRD_TAG_STAR_CENTER_CALIB );
    while ( aframe ) {
        cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
        aframe = cpl_frameset_find( self->inframes, NULL );
    }
    self->fcframe = sph_utils_extract_frame( self->inframes, SPH_IRD_TAG_STAR_CENTER_CALIB );
    if ( ! self->fcframe )
    {
        sph_error_raise( SPH_IRD_ANDROMEDA_FRAMES_MISSING,
                         __FILE__, __func__, __LINE__ ,
                         SPH_ERROR_INFO,
                         "Could not extract fcframe frames."
                         "Since this is an optional frame, this is ok "
                         "and this message is just informational. If you intended, "
                         "to use them check that they have the %s tag.",
                         SPH_IRD_TAG_STAR_CENTER_CALIB);
        cpl_error_reset();
    }

    else {

         rerr = cpl_frame_set_group( self->fcframe, CPL_FRAME_GROUP_CALIB );
    }

    aframe = cpl_frameset_find( self->inframes, SPH_IRD_TAG_FCTABLE_CALIB );
    while ( aframe ) {
        cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
        aframe = cpl_frameset_find( self->inframes, NULL );
    }
    self->fcasciis = sph_utils_extract_frames( self->inframes, SPH_IRD_TAG_FCTABLE_CALIB );
    if ( ! self->fcasciis )
    {
        sph_error_raise( SPH_IRD_ANDROMEDA_FRAMES_MISSING,
                         __FILE__, __func__, __LINE__ ,
                         SPH_ERROR_INFO,
                         "Could not extract fcasciis frames."
                         "Since this is an optional frame, this is ok "
                         "and this message is just informational. If you intended, "
                         "to use them check that they have the %s tag.",
                         SPH_IRD_TAG_FCTABLE_CALIB);
        cpl_error_reset();
    }

    else {

         int numframes = (int)cpl_frameset_get_size( self->fcasciis );
         for ( int ii = 0; ii < numframes; ++ii ) {
         }
         numframes -= (int)cpl_frameset_get_size( self->fcasciis );
         assert( numframes == 0);
    }

    aframe = cpl_frameset_find( self->inframes, SPH_IRD_TAG_FILTER_TABLE_CALIB );
    while ( aframe ) {
        cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
        aframe = cpl_frameset_find( self->inframes, NULL );
    }
    self->filter_frame = sph_utils_extract_frame( self->inframes, SPH_IRD_TAG_FILTER_TABLE_CALIB );
    if ( ! self->filter_frame )
    {
        sph_error_raise( SPH_IRD_ANDROMEDA_FRAMES_MISSING,
                         __FILE__, __func__, __LINE__ ,
                         SPH_ERROR_INFO,
                         "Could not extract filter_frame frames."
                         "Since this is an optional frame, this is ok "
                         "and this message is just informational. If you intended, "
                         "to use them check that they have the %s tag.",
                         SPH_IRD_TAG_FILTER_TABLE_CALIB);
        cpl_error_reset();
    }

    else {

         rerr = cpl_frame_set_group( self->filter_frame, CPL_FRAME_GROUP_CALIB );
    }

    aframe = cpl_frameset_find( self->inframes, SPH_IRD_TAG_PSF_REFERENCE_CALIB );
    while ( aframe ) {
        cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
        aframe = cpl_frameset_find( self->inframes, NULL );
    }
    self->psf_frame = sph_utils_extract_frame( self->inframes, SPH_IRD_TAG_PSF_REFERENCE_CALIB );
    if ( ! self->psf_frame )
    {
        sph_error_raise( SPH_IRD_ANDROMEDA_FRAMES_MISSING,
                         __FILE__, __func__, __LINE__ ,
                         SPH_ERROR_ERROR,
                         "Could not extract psf_frame frames."
                         "to use them check that they have the %s tag.",
                         SPH_IRD_TAG_PSF_REFERENCE_CALIB);
        rerr = SPH_IRD_ANDROMEDA_FRAMES_MISSING;
        return rerr;
    }

    else {

         rerr = cpl_frame_set_group( self->psf_frame, CPL_FRAME_GROUP_CALIB );
    }

    aframe = cpl_frameset_find( self->inframes, SPH_IRD_TAG_STATIC_BADPIXELMAP_CALIB );
    while ( aframe ) {
        cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
        aframe = cpl_frameset_find( self->inframes, NULL );
    }
    self->static_badpixel_frame = sph_utils_extract_frame( self->inframes, SPH_IRD_TAG_STATIC_BADPIXELMAP_CALIB );
    if ( ! self->static_badpixel_frame )
    {
        sph_error_raise( SPH_IRD_ANDROMEDA_FRAMES_MISSING,
                         __FILE__, __func__, __LINE__ ,
                         SPH_ERROR_INFO,
                         "Could not extract static_badpixel_frame frames."
                         "Since this is an optional frame, this is ok "
                         "and this message is just informational. If you intended, "
                         "to use them check that they have the %s tag.",
                         SPH_IRD_TAG_STATIC_BADPIXELMAP_CALIB);
        cpl_error_reset();
    }

    else {

         rerr = cpl_frame_set_group( self->static_badpixel_frame, CPL_FRAME_GROUP_CALIB );
    }

    /* End of code to check frames BUT ITS STILL NOT SAFE TO EDIT! FILE IS GENERATED !*/
    self->current_raw_frameset = sph_utils_extract_frames_group( self->inframes, CPL_FRAME_GROUP_RAW );

    return rerr;
}

/*----------------------------------------------------------------------------*/
/**
 @brief    Check the recipe parameters, and assign them to the sph_ird_andromeda
           structure.
 @param    self     the sph_ird_andromeda recipe structure
 @return   error code of the check.

 This checks the parameters that were given in the sph_ird_andromeda_new function
 as parameters for the correctness and completeness. If the parameters needed are
 found they are also assigned to the corresponding structure members.

 The return value is the error code of the check.
 */
/*----------------------------------------------------------------------------*/
sph_error_code sph_ird_andromeda_check_params( sph_ird_andromeda* self ) {
    sph_error_code                 rerr               = CPL_ERROR_NONE;
    const cpl_parameter*           param              = NULL;

    if ( self->framecomb_parameterlist != NULL ) {
        cpl_parameterlist_delete( self->framecomb_parameterlist );
        self->framecomb_parameterlist = NULL;
    }
    self->framecomb_parameterlist = cpl_parameterlist_new();
    /* Code to check parameters GENERATED DO NOT EDIT */

    param = cpl_parameterlist_find_const( self->inparams,
                                          "ird.andromeda.outfilename");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "ird.andromeda.outfilename");
    }

    self->andromeda_outfilename = cpl_parameter_get_string(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    param = cpl_parameterlist_find_const( self->inparams,
                                          "ird.andromeda.left_filename");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "ird.andromeda.left_filename");
    }

    self->leftlist_filename = cpl_parameter_get_string(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    param = cpl_parameterlist_find_const( self->inparams,
                                          "ird.andromeda.right_filename");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "ird.andromeda.right_filename");
    }

    self->rightlist_filename = cpl_parameter_get_string(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    param = cpl_parameterlist_find_const( self->inparams,
                                          "ird.andromeda.keep_fctable");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "ird.andromeda.keep_fctable");
    }

    self->keep_fctable = cpl_parameter_get_bool(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    param = cpl_parameterlist_find_const( self->inparams,
                                          "ird.andromeda.coll_alg");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "ird.andromeda.coll_alg");
    }

    self->coll_alg = cpl_parameter_get_int(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    param = cpl_parameterlist_find_const( self->inparams,
                                          "ird.andromeda.clean_mean.reject_high");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "ird.andromeda.clean_mean.reject_high");
    }

    self->clean_mean_reject_high = cpl_parameter_get_int(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    cpl_parameterlist_append( self->framecomb_parameterlist,
                              cpl_parameter_new_range( "clean_mean.reject_high",
                                                       CPL_TYPE_INT,
                                                       NULL,
                                                       NULL,
                                                       cpl_parameter_get_int( param ) ,
                                                       0,20
                                                      )
                            );

    param = cpl_parameterlist_find_const( self->inparams,
                                          "ird.andromeda.clean_mean.reject_low");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "ird.andromeda.clean_mean.reject_low");
    }

    self->clean_mean_reject_low = cpl_parameter_get_int(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    cpl_parameterlist_append( self->framecomb_parameterlist,
                              cpl_parameter_new_range( "clean_mean.reject_low",
                                                       CPL_TYPE_INT,
                                                       NULL,
                                                       NULL,
                                                       cpl_parameter_get_int( param ) ,
                                                       0,20
                                                      )
                            );

    param = cpl_parameterlist_find_const( self->inparams,
                                          "ird.andromeda.use_sdi");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "ird.andromeda.use_sdi");
    }

    self->flag_sdi = cpl_parameter_get_bool(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    param = cpl_parameterlist_find_const( self->inparams,
                                          "ird.andromeda.window_minx");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "ird.andromeda.window_minx");
    }

    self->window_minx = cpl_parameter_get_int(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    param = cpl_parameterlist_find_const( self->inparams,
                                          "ird.andromeda.window_miny");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "ird.andromeda.window_miny");
    }

    self->window_miny = cpl_parameter_get_int(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    param = cpl_parameterlist_find_const( self->inparams,
                                          "ird.andromeda.window_maxx");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "ird.andromeda.window_maxx");
    }

    self->window_maxx = cpl_parameter_get_int(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    param = cpl_parameterlist_find_const( self->inparams,
                                          "ird.andromeda.window_maxy");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "ird.andromeda.window_maxy");
    }

    self->window_maxy = cpl_parameter_get_int(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    param = cpl_parameterlist_find_const( self->inparams,
                                          "ird.andromeda.psf_size");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "ird.andromeda.psf_size");
    }

    self->psf_size = cpl_parameter_get_int(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    param = cpl_parameterlist_find_const( self->inparams,
                                          "ird.andromeda.only_prep");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "ird.andromeda.only_prep");
    }

    self->only_prep = cpl_parameter_get_bool(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    param = cpl_parameterlist_find_const( self->inparams,
                                          "ird.andromeda.min_ang_sep");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "ird.andromeda.min_ang_sep");
    }

    self->min_ang_dist = cpl_parameter_get_double(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    param = cpl_parameterlist_find_const( self->inparams,
                                          "ird.andromeda.rho_min");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "ird.andromeda.rho_min");
    }

    self->rhomin = cpl_parameter_get_double(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    param = cpl_parameterlist_find_const( self->inparams,
                                          "ird.andromeda.rho_max");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "ird.andromeda.rho_max");
    }

    self->rhomax = cpl_parameter_get_double(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    param = cpl_parameterlist_find_const( self->inparams,
                                          "ird.andromeda.filter_radius");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "ird.andromeda.filter_radius");
    }

    self->filter_radius = cpl_parameter_get_double(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    /* End of code to check parameters BUT ITS STILL NOT SAFE TO EDIT! FILE IS GENERATED !*/

    return rerr;
}
/*----------------------------------------------------------------------------*/
/**
 @brief    Create a new sph_ird_andromeda structure.

 @param    frameset     the input recipe frames
 @param    parlist      the input recipe parameters

 @return   pointer to newly created structure or NULL in case of error

 This creates a new sph_ird_andromeda_structure and fills the inparams and
 inframes fields with the pointers pf frameset and parlist.
 The return value is the error code of the check.
 */
/*----------------------------------------------------------------------------*/
sph_ird_andromeda* sph_ird_andromeda_new( cpl_frameset * frameset,
                                              cpl_parameterlist * parlist )
{
    sph_ird_andromeda*    result      = NULL;
    int                     rerr        = CPL_ERROR_NONE;

    sph_init_erex();
    if ( frameset == NULL || parlist == NULL ) {
        sph_error_raise( CPL_ERROR_NULL_INPUT, __FILE__,
                         __func__, __LINE__,
                         SPH_ERROR_ERROR,
                         "Null input pointer.");
        return NULL;
    }

    result = cpl_calloc( 1, sizeof(sph_ird_andromeda) );

    if ( result == NULL ) {
        sph_error_raise( SPH_IRD_ANDROMEDA_GENERAL, __FILE__, __func__,
                         __LINE__, SPH_ERROR_ERROR,
                         "Could not allocate the structure.");
        return result;
    }

    result->inframes = frameset;
    result->inparams = parlist;

    rerr = sph_ird_andromeda_check_frames( result );
    if ( rerr == CPL_ERROR_NONE) rerr = sph_ird_andromeda_check_params( result );

    if ( rerr != CPL_ERROR_NONE ) {
        if ( result ) {
            sph_ird_andromeda_delete( result );
        }
        result = NULL;
    }

    return result;
}

/*----------------------------------------------------------------------------*/
/**
 @brief    Delete the sph_ird_andromeda structure.

 @param    self         the structure tp delete

 @return   error code of the operation

 This creates a new sph_ird_andromeda_structure and fills the inparams and
 inframes fields with the pointers pf frameset and parlist.
 The return value is the error code of the check.
 */
/*----------------------------------------------------------------------------*/
sph_error_code sph_ird_andromeda_delete( sph_ird_andromeda* self )
{
    sph_error_code          rerr            = CPL_ERROR_NONE;

    if ( self == NULL ) {
        sph_error_raise( CPL_ERROR_NULL_INPUT, __FILE__,
                         __func__, __LINE__,
                         SPH_ERROR_ERROR,
                         "Null input pointer.");
        return rerr;
    }

    if ( self->framecomb_parameterlist != NULL ) {
        cpl_parameterlist_delete( self->framecomb_parameterlist );
        self->framecomb_parameterlist = NULL;
    }

    /* Code to delete recipe pointers GENERATED DO NOT EDIT */

    if ( self->rawframes != NULL ) {
        cpl_frameset_delete( self->rawframes );
        self->rawframes = NULL;
    }
    if ( self->dark_frame != NULL ) {
        cpl_frame_delete( self->dark_frame );
        self->dark_frame = NULL;
    }
    if ( self->flat_frame != NULL ) {
        cpl_frame_delete( self->flat_frame );
        self->flat_frame = NULL;
    }
    if ( self->distmap_frame != NULL ) {
        cpl_frame_delete( self->distmap_frame );
        self->distmap_frame = NULL;
    }
    if ( self->fcframe != NULL ) {
        cpl_frame_delete( self->fcframe );
        self->fcframe = NULL;
    }
    if ( self->fcasciis != NULL ) {
        cpl_frameset_delete( self->fcasciis );
        self->fcasciis = NULL;
    }
    if ( self->filter_frame != NULL ) {
        cpl_frame_delete( self->filter_frame );
        self->filter_frame = NULL;
    }
    if ( self->psf_frame != NULL ) {
        cpl_frame_delete( self->psf_frame );
        self->psf_frame = NULL;
    }
    if ( self->static_badpixel_frame != NULL ) {
        cpl_frame_delete( self->static_badpixel_frame );
        self->static_badpixel_frame = NULL;
    }
 
    /* End of code to delete pointers BUT ITS STILL NOT SAFE TO EDIT! FILE IS GENERATED !*/
    if ( self->current_raw_frameset ) {
        cpl_frameset_delete(self->current_raw_frameset);
        self->current_raw_frameset = NULL;
    }
    sph_polygon_free_all();
    cpl_free(    self);
    return rerr;

}


/**@}*/
