/* $Id: $
 * This file is part of the SPHERE Pipeline
 * Copyright (C) 2007-2010 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: $
 * $Date: $
 * $Revision: $
 * $Name: $
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

/*-----------------------------------------------------------------------------
 Includes
 -----------------------------------------------------------------------------*/

#include <cpl.h>
#include <math.h>
#include "sph_common_keywords.h"
#include "sph_ird_keywords.h"

#include "sph_ird_tags.h"
#include "sph_ird_gain.h"
#include "sph_master_frame.h"
#include "sph_error.h"
#include "sph_cube.h"
#include "sph_utils.h"
#include "sph_ird_instrument_model.h"
#include "sph_keyword_manager.h"
#include "sph_double_image.h"
#include "sph_fft.h"
#include "sph_ird_common_dpi.h"
/*-----------------------------------------------------------------------------
 Error Codes
 -----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/**
 * @defgroup sph_ird_common_dpi_create_ipframe Create an irdisa polarimetric double image (I,P)
 *
 * This creates a double image for DPI irdis
 *
 * @par Synopsis:
 * @code
 *   #include "sph_ird_dommon_dpi.h"
 * @endcode
 */
/*----------------------------------------------------------------------------*/
/**@{*/
sph_double_image*
sph_ird_common_dpi_create_ipframe(sph_master_frame* left,
        sph_master_frame* right) {
    sph_double_image* result = NULL;

    if (!left || !right) {
        sph_error_raise(CPL_ERROR_NULL_INPUT, __FILE__, __func__, __LINE__,
                SPH_ERROR_ERROR, "Left or right master frame missing.");
        return NULL;
    }
    result = sph_double_image_new_empty();
    result->iframe = sph_master_frame_add_master_frame_create(left, right);
    result->pframe = sph_master_frame_subtract_master_frame_create(left, right);
    return result;
}

/**@}*/
