/***********************************************************************************************/
/******** DANGER !! DANGER !! DANGER !! DO NOT EDIT FILE -- IT WAS GENERATED AUTOMATICALLY !!! */
/***********************************************************************************************/

/* $Id: $
 * This file is part of the SPHERE Pipeline
 * Copyright (C) 2007-2010 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: $
 * $Date: $
 * $Revision: $
 * $Name: $
 */

/*-----------------------------------------------------------------------------
 Includes
 -----------------------------------------------------------------------------*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "sph_ird_sky_bg.h"
#include "sph_common_keywords.h"
#include "sph_ird_keywords.h"
#include "sph_ird_tags.h"
#include "sph_master_frame.h"
#include "sph_error.h"
#include "sph_cube.h"
#include "sph_utils.h"

#include <math.h>
#include <assert.h>
#include <cpl.h>

/*-----------------------------------------------------------------------------
  Error Codes
 -----------------------------------------------------------------------------*/

sph_error_code SPH_IRD_SKY_BG_GENERAL              = SPH_IRD_SKY_BG_ERR_START + 0;
sph_error_code SPH_IRD_SKY_BG_NO_VALID_DIT_LIST    = SPH_IRD_SKY_BG_ERR_START + 1;

sph_error_code SPH_IRD_SKY_BG_PARAMETER_MISSING    = SPH_IRD_SKY_BG_ERR_START + 3;
sph_error_code SPH_IRD_SKY_BG_FRAMES_MISSING       = SPH_IRD_SKY_BG_ERR_START + 4;

/*-----------------------------------------------------------------------------
 Private function prototypes
 -----------------------------------------------------------------------------*/

static int sph_ird_sky_bg_create_plugin ( cpl_plugin * );
static int sph_ird_sky_bg_exec_plugin ( cpl_plugin * );
static int sph_ird_sky_bg_destroy_plugin ( cpl_plugin * );

/*-----------------------------------------------------------------------------
 Static variables
 -----------------------------------------------------------------------------*/

static const char* sph_ird_sky_bg_help = 
    "RECIPE INPUT FRAMES: \n"
    "-------------------- \n"
    "Tag                           Min,Max   Description\n"
    "IRD_SKY_BG_RAW                  1, -1   The raw instrument background frames\n"
    "IRD_INSTRUMENT_MODEL            0,  1   Optional frame describing a non-default IRDIS instrument model.\n"
    "                                        This is an ini style ASCII frame. See the manual for the format.\n"
    "                                        Please use this input only after consulting a DRH developer.\n"
    "IRD_STATIC_BADPIXELMAP          0,  1   An optional static badpixelmap.\n"
    "                                        The only use of this mask is to insert it as a result into the\n"
    "                                        badpixel extension and so to preempt it from being used in\n"
    "                                        the mean and RMS computation.\n"
    "\n"
    "RAW FRAME KEYWORDS: \n"
    "-------------------- \n"
    "Keyword                       Type   Optional  Description\n"
    "\n"
    "DESCRIPTION:\n"
    "------------\n"
    "This recipe deals with the creation of the sky background calibration frame.\n"
    "Only raw frames are used in this recipe. The background  is created by combining the\n"
    "input raw frames using the collapse algorithm specified (usually the clean_mean algorithm).\n"
    "\n"
    "Contrary to the master_dark recipe, no badpixel maps are created by this recipe,\n"
    "since thresholding is much more difficult on the background frames.  The recommended way\n"
    "to generate a reliable badpixel map is to use the master_dark recipe on suitable dark frames!\n"
    "\n"
    "MASTER_DARK, INS_BG, and SKY_BG frames are all for subtraction from raw input frames, thus they\n"
    "are never corrected for flat fields or other dark/background frames!\n"
    "\n"
    "\n"
    "RECIPE PRODUCTS: \n"
    "-------------------- \n"
    "Tag                      Format         Description\n"
    "IRD_SKY_BG                         FITS[Im(4)]    The resulting master dark frame.\n"
    "                                        This frame contains 4 different image extensions:\n"
    "                                        the image, badpixels, the weightmap (how many frames contribute\n"
    "                                        to each pixel), and the rms map.\n"
    "IRD_SKY_BG_FIT                     FITS[Im(4)]    The smoothed frame (2D polynomial fit) of the background. The FITS file contains 4 extensions: the image, the\n"
    "                                        badpixels, the rms error and a weightmap. Left and right frame fits are obtained\n"
    "                                        separately, but inserted into a full frame result!\n"
    "\n"
    "PRODUCT FRAME KEYWORDS: \n"
    "-------------------- \n"
    "Keyword                       Frame          Type    Description\n"
    "\n"
;

/*-----------------------------------------------------------------------------
 Function code
 -----------------------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/
/**
 * @defgroup sph_ird_sky_bg Create Master Dark Recipe
 *
 * This module provides the recipe plugin and relating functions for the
 * creation of the master dark .
 *
 * @par Synopsis:
 * @code
 *   #include "sph_ird_sky_bg.h"
 * @endcode
 */
/*----------------------------------------------------------------------------*/
/**@{*/

/*****************************************************************************
 *
 *
 *      First come the static and global functions necessary for the
 *      normal working of the recipe as plugin....
 *
 *
 * ***************************************************************************/
/*----------------------------------------------------------------------------*/
/**
 @brief    Build the list of available plugins, for this module.
 @param    list    the plugin list
 @return   0 if everything is ok, 1 otherwise
 @note     Only this function is exported

 Create the recipe instance and make it available to the application
 using the interface.
 */
/*----------------------------------------------------------------------------*/
int cpl_plugin_get_info(cpl_pluginlist * list)
{
    cpl_recipe * recipe = cpl_calloc( 1, sizeof *recipe);
    cpl_plugin * plugin = &recipe->interface;

    if (cpl_plugin_init(plugin,
                        CPL_PLUGIN_API,
                        SPH_IRD_SKY_BG_VERSION,
                        CPL_PLUGIN_TYPE_RECIPE,
                        "sph_ird_sky_bg",
                        "Creation of a sky background",
                        sph_ird_sky_bg_help, "Markus Feldt <mfeldt@mpia-hd.mpg.de>",
                        "https://support.eso.org", cpl_get_license("SPHERE DRH","2012"),
                        sph_ird_sky_bg_create_plugin,
                        sph_ird_sky_bg_exec_plugin,
                        sph_ird_sky_bg_destroy_plugin) )
    {
        cpl_msg_error( cpl_func, "Plugin initialization failed");
        (void)cpl_error_set_where( cpl_func );
        return 1;
    }

    if (cpl_pluginlist_append(list, plugin) )
    {
        cpl_msg_error( cpl_func, "Error adding plugin to list");
        (void)cpl_error_set_where( cpl_func );
        return 1;
    }
    return 0;
}

/*----------------------------------------------------------------------------*/
/**
 @brief    Setup the recipe options
 @param    plugin  the plugin
 @return   0 if everything is ok

 Defining the command-line/configuration parameters for the recipe.
 */
/*----------------------------------------------------------------------------*/
static int sph_ird_sky_bg_create_plugin(cpl_plugin * plugin)
{
    if (cpl_error_get_code() != CPL_ERROR_NONE)
    {
        cpl_msg_error( cpl_func, "%s():%d: An error is already set: %s",
                       cpl_func, __LINE__, cpl_error_get_where());
        return (int)cpl_error_get_code();
    }

    if (plugin == NULL)
    {
        cpl_msg_error(cpl_func, "Null plugin");
        cpl_ensure_code(0, (int)CPL_ERROR_NULL_INPUT);
    }

    if (cpl_plugin_get_type(plugin) != CPL_PLUGIN_TYPE_RECIPE)
    {
        cpl_msg_error( cpl_func, "Plugin is not a recipe");
        cpl_ensure_code( 0, (int)CPL_ERROR_TYPE_MISMATCH );
    }

    if ( plugin != NULL ) {
        cpl_recipe * recipe = (cpl_recipe *)plugin;
        recipe->parameters = sph_ird_sky_bg_create_paramlist();
        if ( recipe->parameters == NULL ) {
            return SPH_IRD_SKY_BG_GENERAL;
        }
    }
    return 0;
}

/*----------------------------------------------------------------------------*/
/**
 @brief    Testing for setup of the recipe options
 @param    plugin  the plugin
 @return   0 if everything is ok

 Wrapper to make the static plugin creation function accessible from outside
 for testing purposes.
 */
/*----------------------------------------------------------------------------*/
int sph_ird_sky_bg_create_test(cpl_plugin * plugin)
{
    return (int)sph_ird_sky_bg_create_plugin(plugin);
}

/*----------------------------------------------------------------------------*/
/**
 @brief    Execute the plugin instance given by the interface
 @param    plugin  the plugin
 @return   0 if everything is ok
 */
/*----------------------------------------------------------------------------*/
static int sph_ird_sky_bg_exec_plugin(cpl_plugin * plugin)
{

    cpl_recipe*             recipe                  = NULL;
    cpl_error_code          recipe_code;
    sph_ird_sky_bg*    sph_recipe      = NULL;
    cpl_errorstate          initial_errorstate      = cpl_errorstate_get();

    if (cpl_error_get_code() != CPL_ERROR_NONE)
    {
        cpl_msg_error( cpl_func, "%s():%d: A cpl error is already set: %s",
        cpl_func, __LINE__, cpl_error_get_where());
        return (int)cpl_error_get_code();
    }

    if (plugin == NULL)
    {
        cpl_msg_error( cpl_func, "Null plugin");
        cpl_ensure_code( 0, (int)CPL_ERROR_NULL_INPUT );
        return (int)cpl_error_get_code();
    }

    if (cpl_plugin_get_type(plugin) != CPL_PLUGIN_TYPE_RECIPE)
    {
        cpl_msg_error( cpl_func, "Plugin is not a recipe");
        cpl_ensure_code( 0, (int)CPL_ERROR_TYPE_MISMATCH );
        return (int)cpl_error_get_code();
    }

    recipe = (cpl_recipe *)plugin;

    if (recipe->parameters == NULL)
    {
        cpl_msg_error( cpl_func, "Recipe invoked with NULL parameter list");
        cpl_ensure_code( 0, (int)CPL_ERROR_NULL_INPUT );
        return (int)cpl_error_get_code();
    }

    if (recipe->frames == NULL)
    {
        cpl_msg_error( cpl_func, "Recipe invoked with NULL frame set");
        cpl_ensure_code( 0, (int)CPL_ERROR_NULL_INPUT );
        return (int)cpl_error_get_code();
    }

    sph_recipe = sph_ird_sky_bg_new( recipe->frames, recipe->parameters );
    if ( sph_recipe == NULL ) {
        recipe_code = cpl_error_set_where(cpl_func);
    } else {

        recipe_code = sph_ird_sky_bg_run( sph_recipe );

        sph_ird_sky_bg_delete( sph_recipe );
    }

    if ( !cpl_errorstate_is_equal(initial_errorstate) )
    {
        cpl_errorstate_dump(initial_errorstate, CPL_FALSE, NULL);
    }
    sph_end_erex(); //close the sphere system
    return (int)(recipe_code >= CPL_ERROR_EOL /* Workaround esorex PIPE-6887 */
                 ? CPL_ERROR_EOL : recipe_code);
}

/*----------------------------------------------------------------------------*/
/**
 @brief    Destroy what has been created by the 'create' function
 @param    plugin  the plugin
 @return   0 if everything is ok
 */
/*----------------------------------------------------------------------------*/
static int sph_ird_sky_bg_destroy_plugin(cpl_plugin * plugin)
{
    cpl_recipe * recipe;

    if (plugin == NULL)
    {
        cpl_msg_error( cpl_func, "Null plugin");
        cpl_ensure_code( 0, (int)CPL_ERROR_NULL_INPUT );
    }

    if (cpl_plugin_get_type(plugin) != CPL_PLUGIN_TYPE_RECIPE)
    {
        cpl_msg_error( cpl_func, "Plugin is not a recipe");
        cpl_ensure_code( 0, (int)CPL_ERROR_TYPE_MISMATCH );
    }

    recipe = (cpl_recipe *)plugin;

    cpl_parameterlist_delete(recipe->parameters);

    return 0;
}

/*****************************************************************************
 *
 *
 *      Here come the "Member" functions of the sph_ird_sky_bg struct
 *
 *
 * ***************************************************************************/

/*----------------------------------------------------------------------------*/
/**
 @brief    Fill a pre-allocated parameterlist for the recipe
 @param    result A pre-allocated parameterlist
 @return   CPL_ERROR_NONE iff successful

 This function fills the standard parameterlist for the recipe

 */
/*----------------------------------------------------------------------------*/
static cpl_error_code sph_ird_sky_bg_fill_parameterlist(cpl_parameterlist * result)
{
    cpl_parameter* p;

        /* Code to set up parameters GENERATED DO NOT EDIT */

        p = cpl_parameter_new_value("ird.sky_bg.outfilename",
                                   CPL_TYPE_STRING,
                                   "The output filename for the product. Please also see the esorex documentation "
                                   "for naming of output products. "
                                   ,"ird.sky_bg",
                                   "sky_bg.fits" );

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_value("ird.sky_bg.save_addprod",
                                   CPL_TYPE_BOOL,
                                   "Flag to signal whether additional products - in this case the smoothed "
                                   "background - should be saved. "
                                   ,"ird.sky_bg",
                                   0 );

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_value("ird.sky_bg.lsf_outfilename",
                                   CPL_TYPE_STRING,
                                   "Flag to signal whether additional products - in this case the smoothed "
                                   "background - should be saved. "
                                   ,"ird.sky_bg",
                                   "sky_bg_fit.fits" );

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_enum("ird.sky_bg.coll_alg",
                                   CPL_TYPE_INT,
                                   "The collapse algorithm to use. 0 = Mean, 1 = Median, 2 = Clean mean. "
                                   ,"ird.sky_bg",
                                   2 ,
                                   3,0,1,2);

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_range("ird.sky_bg.clean_mean.reject_low",
                                   CPL_TYPE_INT,
                                   "The clean mean reject pixels on low end. "
                                   ,"ird.sky_bg",
                                   0 ,
                                   0,20);

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_range("ird.sky_bg.clean_mean.reject_high",
                                   CPL_TYPE_INT,
                                   "The clean mean reject pixels on high end. "
                                   ,"ird.sky_bg",
                                   0 ,
                                   0,20);

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_range("ird.sky_bg.fitorder",
                                   CPL_TYPE_INT,
                                   "The fitting order to use for the 2D polynomial fit of the background.     smoothing        range       double "
                                   ,"ird.sky_bg",
                                   2 ,
                                   1,7);

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        /* End of code to set up parameters BUT ITS STILL NOT SAFE TO EDIT! FILE IS GENERATED !*/

    return cpl_error_set_where(cpl_func);
}
/*----------------------------------------------------------------------------*/
/**
 @brief  Create and return the standard parameterlist for the recipe
 @return The standard parameterlist or NULL on error
 @note   The returned object must be deallocated using cpl_parameterlist_delete

 */
/*----------------------------------------------------------------------------*/
cpl_parameterlist* sph_ird_sky_bg_create_paramlist(void)
{
    cpl_parameterlist* self = cpl_parameterlist_new();

    if (sph_ird_sky_bg_fill_parameterlist(self)) {
        cpl_parameterlist_delete(self);
        self = NULL;
        (void)cpl_error_set_where(cpl_func);
    }

    return self;
}

/*----------------------------------------------------------------------------*/
/**
 @brief    Check the recipe frames, and assign them to the sph_ird_sky_bg
           structure.
 @param    self     the sph_ird_sky_bg recipe structure
 @return   error code of the check.

 This checks the frames that were given in the sph_ird_sky_bg_new function
 as parameters for the correctness and completeness. If the frames needed are
 found they are also assigned to the corresponding structure members.

 The return value is the error code of the check.
 */
/*----------------------------------------------------------------------------*/
sph_error_code  sph_ird_sky_bg_check_frames( sph_ird_sky_bg* self )
{
    sph_error_code           rerr            = CPL_ERROR_NONE;
    /* Code to check frames GENERATED DO NOT EDIT */

    cpl_frame* aframe;
    aframe = cpl_frameset_find( self->inframes, SPH_IRD_TAG_SKY_BG_RAW );
    while ( aframe ) {
        cpl_frame_set_group( aframe, CPL_FRAME_GROUP_RAW );
        aframe = cpl_frameset_find( self->inframes, NULL );
    }
    self->rawframes = sph_utils_extract_frames( self->inframes, SPH_IRD_TAG_SKY_BG_RAW );
    if ( ! self->rawframes )
    {
        sph_error_raise( SPH_IRD_SKY_BG_FRAMES_MISSING,
                         __FILE__, __func__, __LINE__ ,
                         SPH_ERROR_ERROR,
                         "Could not extract rawframes frames."
                         "to use them check that they have the %s tag.",
                         SPH_IRD_TAG_SKY_BG_RAW);
        rerr = SPH_IRD_SKY_BG_FRAMES_MISSING;
        return rerr;
    }

    else {

         int numframes = (int)cpl_frameset_get_size( self->rawframes );
         for ( int ii = 0; ii < numframes; ++ii ) {
             cpl_frame* iframe = cpl_frameset_get_position( self->rawframes, ii );
             const char* ifname = cpl_frame_get_filename(iframe);
             cpl_propertylist* pl = cpl_propertylist_load(ifname, 0);
             if (pl == NULL ) {
                 sph_error_raise(cpl_error_get_code(),
                    __FILE__, __func__, __LINE__ ,SPH_ERROR_ERROR,
                 "Could not read keywords from file %s. "
                 "Either the file is not readable or corrupted. ",
                  ifname);
             }
             else {
                 rerr = cpl_frame_set_group( iframe, CPL_FRAME_GROUP_RAW );
                 cpl_propertylist_delete(pl); pl=NULL;
             }
         }
         numframes -= (int)cpl_frameset_get_size( self->rawframes );
         assert( numframes == 0);
    }

    aframe = cpl_frameset_find( self->inframes, SPH_IRD_TAG_INSTRUMENT_MODEL );
    while ( aframe ) {
        cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
        aframe = cpl_frameset_find( self->inframes, NULL );
    }
    self->model_frame = sph_utils_extract_frame( self->inframes, SPH_IRD_TAG_INSTRUMENT_MODEL );
    if ( ! self->model_frame )
    {
        sph_error_raise( SPH_IRD_SKY_BG_FRAMES_MISSING,
                         __FILE__, __func__, __LINE__ ,
                         SPH_ERROR_INFO,
                         "Could not extract model_frame frames."
                         "Since this is an optional frame, this is ok "
                         "and this message is just informational. If you intended, "
                         "to use them check that they have the %s tag.",
                         SPH_IRD_TAG_INSTRUMENT_MODEL);
        cpl_error_reset();
    }

    else {

         rerr = cpl_frame_set_group( self->model_frame, CPL_FRAME_GROUP_CALIB );
    }

    aframe = cpl_frameset_find( self->inframes, SPH_IRD_TAG_STATIC_BADPIXELMAP_CALIB );
    while ( aframe ) {
        cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
        aframe = cpl_frameset_find( self->inframes, NULL );
    }
    self->static_badpixel_frame = sph_utils_extract_frame( self->inframes, SPH_IRD_TAG_STATIC_BADPIXELMAP_CALIB );
    if ( ! self->static_badpixel_frame )
    {
        sph_error_raise( SPH_IRD_SKY_BG_FRAMES_MISSING,
                         __FILE__, __func__, __LINE__ ,
                         SPH_ERROR_INFO,
                         "Could not extract static_badpixel_frame frames."
                         "Since this is an optional frame, this is ok "
                         "and this message is just informational. If you intended, "
                         "to use them check that they have the %s tag.",
                         SPH_IRD_TAG_STATIC_BADPIXELMAP_CALIB);
        cpl_error_reset();
    }

    else {

         rerr = cpl_frame_set_group( self->static_badpixel_frame, CPL_FRAME_GROUP_CALIB );
    }

    /* End of code to check frames BUT ITS STILL NOT SAFE TO EDIT! FILE IS GENERATED !*/
    self->current_raw_frameset = sph_utils_extract_frames_group( self->inframes, CPL_FRAME_GROUP_RAW );

    return rerr;
}

/*----------------------------------------------------------------------------*/
/**
 @brief    Check the recipe parameters, and assign them to the sph_ird_sky_bg
           structure.
 @param    self     the sph_ird_sky_bg recipe structure
 @return   error code of the check.

 This checks the parameters that were given in the sph_ird_sky_bg_new function
 as parameters for the correctness and completeness. If the parameters needed are
 found they are also assigned to the corresponding structure members.

 The return value is the error code of the check.
 */
/*----------------------------------------------------------------------------*/
sph_error_code sph_ird_sky_bg_check_params( sph_ird_sky_bg* self ) {
    sph_error_code                 rerr               = CPL_ERROR_NONE;
    const cpl_parameter*           param              = NULL;

    if ( self->framecomb_parameterlist != NULL ) {
        cpl_parameterlist_delete( self->framecomb_parameterlist );
        self->framecomb_parameterlist = NULL;
    }
    self->framecomb_parameterlist = cpl_parameterlist_new();
    /* Code to check parameters GENERATED DO NOT EDIT */

    param = cpl_parameterlist_find_const( self->inparams,
                                          "ird.sky_bg.outfilename");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "ird.sky_bg.outfilename");
    }

    self->sky_bg_outfilename = cpl_parameter_get_string(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    param = cpl_parameterlist_find_const( self->inparams,
                                          "ird.sky_bg.save_addprod");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "ird.sky_bg.save_addprod");
    }

    self->save_addprod = cpl_parameter_get_bool(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    param = cpl_parameterlist_find_const( self->inparams,
                                          "ird.sky_bg.lsf_outfilename");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "ird.sky_bg.lsf_outfilename");
    }

    self->lsf_outfilename = cpl_parameter_get_string(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    param = cpl_parameterlist_find_const( self->inparams,
                                          "ird.sky_bg.coll_alg");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "ird.sky_bg.coll_alg");
    }

    self->coll_alg = cpl_parameter_get_int(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    param = cpl_parameterlist_find_const( self->inparams,
                                          "ird.sky_bg.clean_mean.reject_low");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "ird.sky_bg.clean_mean.reject_low");
    }

    self->clean_mean_reject_low = cpl_parameter_get_int(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    cpl_parameterlist_append( self->framecomb_parameterlist,
                              cpl_parameter_new_range( "clean_mean.reject_low",
                                                       CPL_TYPE_INT,
                                                       NULL,
                                                       NULL,
                                                       cpl_parameter_get_int( param ) ,
                                                       0,20
                                                      )
                            );

    param = cpl_parameterlist_find_const( self->inparams,
                                          "ird.sky_bg.clean_mean.reject_high");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "ird.sky_bg.clean_mean.reject_high");
    }

    self->clean_mean_reject_high = cpl_parameter_get_int(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    cpl_parameterlist_append( self->framecomb_parameterlist,
                              cpl_parameter_new_range( "clean_mean.reject_high",
                                                       CPL_TYPE_INT,
                                                       NULL,
                                                       NULL,
                                                       cpl_parameter_get_int( param ) ,
                                                       0,20
                                                      )
                            );

    param = cpl_parameterlist_find_const( self->inparams,
                                          "ird.sky_bg.fitorder");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "ird.sky_bg.fitorder");
    }

    self->order = cpl_parameter_get_int(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    /* End of code to check parameters BUT ITS STILL NOT SAFE TO EDIT! FILE IS GENERATED !*/

    return rerr;
}
/*----------------------------------------------------------------------------*/
/**
 @brief    Create a new sph_ird_sky_bg structure.

 @param    frameset     the input recipe frames
 @param    parlist      the input recipe parameters

 @return   pointer to newly created structure or NULL in case of error

 This creates a new sph_ird_sky_bg_structure and fills the inparams and
 inframes fields with the pointers pf frameset and parlist.
 The return value is the error code of the check.
 */
/*----------------------------------------------------------------------------*/
sph_ird_sky_bg* sph_ird_sky_bg_new( cpl_frameset * frameset,
                                              cpl_parameterlist * parlist )
{
    sph_ird_sky_bg*    result      = NULL;
    int                     rerr        = CPL_ERROR_NONE;

    sph_init_erex();
    if ( frameset == NULL || parlist == NULL ) {
        sph_error_raise( CPL_ERROR_NULL_INPUT, __FILE__,
                         __func__, __LINE__,
                         SPH_ERROR_ERROR,
                         "Null input pointer.");
        return NULL;
    }

    result = cpl_calloc( 1, sizeof(sph_ird_sky_bg) );

    if ( result == NULL ) {
        sph_error_raise( SPH_IRD_SKY_BG_GENERAL, __FILE__, __func__,
                         __LINE__, SPH_ERROR_ERROR,
                         "Could not allocate the structure.");
        return result;
    }

    result->inframes = frameset;
    result->inparams = parlist;

    rerr = sph_ird_sky_bg_check_frames( result );
    if ( rerr == CPL_ERROR_NONE) rerr = sph_ird_sky_bg_check_params( result );

    if ( rerr != CPL_ERROR_NONE ) {
        if ( result ) {
            sph_ird_sky_bg_delete( result );
        }
        result = NULL;
    }

    return result;
}

/*----------------------------------------------------------------------------*/
/**
 @brief    Delete the sph_ird_sky_bg structure.

 @param    self         the structure tp delete

 @return   error code of the operation

 This creates a new sph_ird_sky_bg_structure and fills the inparams and
 inframes fields with the pointers pf frameset and parlist.
 The return value is the error code of the check.
 */
/*----------------------------------------------------------------------------*/
sph_error_code sph_ird_sky_bg_delete( sph_ird_sky_bg* self )
{
    sph_error_code          rerr            = CPL_ERROR_NONE;

    if ( self == NULL ) {
        sph_error_raise( CPL_ERROR_NULL_INPUT, __FILE__,
                         __func__, __LINE__,
                         SPH_ERROR_ERROR,
                         "Null input pointer.");
        return rerr;
    }

    if ( self->framecomb_parameterlist != NULL ) {
        cpl_parameterlist_delete( self->framecomb_parameterlist );
        self->framecomb_parameterlist = NULL;
    }

    /* Code to delete recipe pointers GENERATED DO NOT EDIT */

    if ( self->rawframes != NULL ) {
        cpl_frameset_delete( self->rawframes );
        self->rawframes = NULL;
    }
    if ( self->model_frame != NULL ) {
        cpl_frame_delete( self->model_frame );
        self->model_frame = NULL;
    }
    if ( self->static_badpixel_frame != NULL ) {
        cpl_frame_delete( self->static_badpixel_frame );
        self->static_badpixel_frame = NULL;
    }
 
    /* End of code to delete pointers BUT ITS STILL NOT SAFE TO EDIT! FILE IS GENERATED !*/
    if ( self->current_raw_frameset ) {
        cpl_frameset_delete(self->current_raw_frameset);
        self->current_raw_frameset = NULL;
    }
    sph_polygon_free_all();
    cpl_free(    self);
    return rerr;

}


/**@}*/
