/***********************************************************************************************/
/******** DANGER !! DANGER !! DANGER !! DO NOT EDIT FILE -- IT WAS GENERATED AUTOMATICALLY !!! */
/***********************************************************************************************/

/* $Id: $
 * This file is part of the SPHERE Pipeline
 * Copyright (C) 2007-2010 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: $
 * $Date: $
 * $Revision: $
 * $Name: $
 */

#include "sph_error.h"
#include "sph_cube.h"
#include "sph_pixel_description_table.h"
#include "sph_ldt.h"
#include "sph_master_frame.h"
#include "sph_double_image.h"
#include "sph_triple_image.h"
#include "sph_quad_image.h"
#include "sph_zpl_exposure.h"
#include "sph_zpl_exposure_imaging.h"
#include "sph_pixel_polyfit_table.h"
#include "sph_ird_instrument_model.h"
#include "sph_fctable.h"
#include "sph_zpl_science_pol_product.h"
#include <cpl.h>
#include <config.h>

#ifndef SPH_ZPL_INTENSITY_FLAT_IMAGING_H_

#define SPH_ZPL_INTENSITY_FLAT_IMAGING_H_
#define SPH_ZPL_INTENSITY_FLAT_IMAGING_VERSION SPHERE_REC_VERSIONS

/*-------------------------------------------------------------------------------
 * The Structure Definition
 * 
 * This structure contains the members of the sph_zpl_intensity_flat_imaging that are 
 * needed by the various methods.
 * 
 * ------------------------------------------------------------------------------
 */

typedef struct _sph_zpl_intensity_flat_imaging_ {
    cpl_frameset*                   inframes                              ; /* The recipe input frames */

    cpl_frameset*                   current_raw_frameset                  ; /* The frameset for one product */

    cpl_parameterlist*        inparams                              ; /* The recipe input parameters */

    cpl_parameterlist*        framecomb_parameterlist               ; /* The recipe input parameters */

    const char*                     intensity_flat_imaging_outfilename    ; /* The parameter of zpl.intensity_flat_imaging.outfilename */

    const char*                     intensity_flat_imaging_outfilename_cam1; /* The parameter of zpl.intensity_flat_imaging.outfilename_cam1 */

    const char*                     intensity_flat_imaging_outfilename_cam2; /* The parameter of zpl.intensity_flat_imaging.outfilename_cam2 */

    short                           subtract_overscan                     ; /* The parameter of zpl.intensity_flat_imaging.subtract_overscan */

    const char*                     badpix_filename                       ; /* The parameter of zpl.intensity_flat_imaging.badpixfilename */

    const char*                     badpix_filename_cam1                  ; /* The parameter of zpl.intensity_flat_imaging.badpixfilename_cam1 */

    const char*                     badpix_filename_cam2                  ; /* The parameter of zpl.intensity_flat_imaging.badpixfilename_cam2 */

    short                           robust_fit                            ; /* The parameter of zpl.intensity_flat_imaging.robust_fit */

    short                           collapse                              ; /* The parameter of zpl.intensity_flat_imaging.collapse */

    int                             coll_alg                              ; /* The parameter of zpl.intensity_flat_imaging.coll_alg */

    int                             clean_mean_reject_high                ; /* The parameter of zpl.intensity_flat_imaging.coll_alg.clean_mean.reject_high */

    int                             clean_mean_reject_low                 ; /* The parameter of zpl.intensity_flat_imaging.coll_alg.clean_mean.reject_low */

    double                          sigma_clip                            ; /* The parameter of zpl.intensity_flat_imaging.sigma_clip */

    double                          badpix_lowtolerance                   ; /* The parameter of zpl.intensity_flat_imaging.badpix_lowtolerance */

    double                          badpix_uptolerance                    ; /* The parameter of zpl.intensity_flat_imaging.badpix_uptolerance */

    double                          badpix_chisqtolerance                 ; /* The parameter of zpl.intensity_flat_imaging.badpix_chisqtolerance */

    short                           keep_intermediate                     ; /* The parameter of zpl.intensity_flat_imaging.keep_intermediate */

    const char*                     outfilename_cam1                      ; /* The parameter of zpl.preproc.outfilename_cam1 */

    const char*                     outfilename_cam2                      ; /* The parameter of zpl.preproc.outfilename_cam2 */

    cpl_frameset*                   rawframes                             ; /* The ZPL_INT_FLAT_FIELD_IMAGING_RAW frames */

    cpl_frameset*                   preproc_frames                        ; /* The ZPL_INT_FLAT_FIELD_IMAGING_PREPROC_RAW frames */

    cpl_frameset*                   preproc_frames_cam1                   ; /* The ZPL_INT_FLAT_FIELD_IMAGING_PREPROC_CAM1 frames */

    cpl_frameset*                   preproc_frames_cam2                   ; /* The ZPL_INT_FLAT_FIELD_IMAGING_PREPROC_CAM2 frames */

    cpl_frame*                      master_bias_frame                     ; /* The ZPL_MASTER_BIAS_IMAGING frames */

    cpl_frame*                      master_bias_frame_cam1                ; /* The ZPL_MASTER_BIAS_IMAGING_CAM1 frames */

    cpl_frame*                      master_bias_frame_cam2                ; /* The ZPL_MASTER_BIAS_IMAGING_CAM2 frames */

    cpl_frame*                      master_dark_frame                     ; /* The ZPL_MASTER_DARK_IMAGING frames */

    cpl_frame*                      master_dark_frame_cam1                ; /* The ZPL_MASTER_DARK_IMAGING_CAM1 frames */

    cpl_frame*                      master_dark_frame_cam2                ; /* The ZPL_MASTER_DARK_IMAGING_CAM2 frames */

    cpl_frame*                      static_badpixel_frame                 ; /* The ZPL_STATIC_BADPIXELMAP_IMAGING frames */

    cpl_frame*                      static_badpixel_frame_cam1            ; /* The ZPL_STATIC_BADPIXELMAP_IMAGING_CAM1 frames */

    cpl_frame*                      static_badpixel_frame_cam2            ; /* The ZPL_STATIC_BADPIXELMAP_IMAGING_CAM2 frames */

    sph_double_image*               intensity_flat_field_imaging          ; /* The ZPL_INT_FLAT_FIELD_IMAGING product */

    sph_double_image*               intensity_flat_field_imaging_cam1     ; /* The ZPL_INT_FLAT_FIELD_IMAGING_CAM1 product */

    sph_double_image*               intensity_flat_field_imaging_cam2     ; /* The ZPL_INT_FLAT_FIELD_IMAGING_CAM2 product */

    sph_zpl_exposure_imaging*       linbadpix                             ; /* The ZPL_NON_LINEAR_BADPIXELMAP_IMAGING product */

    sph_zpl_exposure_imaging*       linbadpix_cam1                        ; /* The ZPL_NON_LINEAR_BADPIXELMAP_IMAGING_CAM1 product */

    sph_zpl_exposure_imaging*       linbadpix_cam2                        ; /* The ZPL_NON_LINEAR_BADPIXELMAP_IMAGING_CAM2 product */

} sph_zpl_intensity_flat_imaging;

/*-------------------------------------------------------------------------------
 * Error codes
 * 
 * Below the various error codes for this module are declared.
 * ------------------------------------------------------------------------------
 */

int sph_zpl_intensity_flat_imaging_create_test(cpl_plugin *);


/*-------------------------------------------------------------------------------
 * The methods
 * 
 * These are the methods for sph_zpl_intensity_flat_imaging.
 * 
 * ------------------------------------------------------------------------------
 */

sph_zpl_intensity_flat_imaging* sph_zpl_intensity_flat_imaging_new( cpl_frameset * frameset, 
                                              cpl_parameterlist * parlist);

sph_error_code  sph_zpl_intensity_flat_imaging_check_frames( sph_zpl_intensity_flat_imaging* self );

sph_error_code sph_zpl_intensity_flat_imaging_check_params( sph_zpl_intensity_flat_imaging* parlist );

cpl_error_code sph_zpl_intensity_flat_imaging_run( sph_zpl_intensity_flat_imaging* self );

sph_error_code sph_zpl_intensity_flat_imaging_delete( sph_zpl_intensity_flat_imaging* self );
cpl_parameterlist*  sph_zpl_intensity_flat_imaging_create_paramlist(void) CPL_ATTR_ALLOC;

/* Extra function declarations that are defined in sph_zpl_intensity_flat_imaging.c */


/* End of extra function declarations that are defined in sph_zpl_intensity_flat_imaging_run.c */



#endif /*SPH_ZPL_INTENSITY_FLAT_IMAGING_H_*/
