/***********************************************************************************************/
/******** DANGER !! DANGER !! DANGER !! DO NOT EDIT FILE -- IT WAS GENERATED AUTOMATICALLY !!! */
/***********************************************************************************************/

/* $Id: $
 * This file is part of the SPHERE Pipeline
 * Copyright (C) 2007-2010 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: $
 * $Date: $
 * $Revision: $
 * $Name: $
 */

#include "sph_error.h"
#include "sph_cube.h"
#include "sph_pixel_description_table.h"
#include "sph_ldt.h"
#include "sph_master_frame.h"
#include "sph_double_image.h"
#include "sph_triple_image.h"
#include "sph_quad_image.h"
#include "sph_zpl_exposure.h"
#include "sph_zpl_exposure_imaging.h"
#include "sph_pixel_polyfit_table.h"
#include "sph_ird_instrument_model.h"
#include "sph_fctable.h"
#include "sph_zpl_science_pol_product.h"
#include <cpl.h>
#include <config.h>

#ifndef SPH_ZPL_MODEM_EFFICIENCY_H_

#define SPH_ZPL_MODEM_EFFICIENCY_H_
#define SPH_ZPL_MODEM_EFFICIENCY_VERSION SPHERE_REC_VERSIONS

/*-------------------------------------------------------------------------------
 * The Structure Definition
 * 
 * This structure contains the members of the sph_zpl_modem_efficiency that are 
 * needed by the various methods.
 * 
 * ------------------------------------------------------------------------------
 */

typedef struct _sph_zpl_modem_efficiency_ {
    cpl_frameset*                   inframes                              ; /* The recipe input frames */

    cpl_frameset*                   current_raw_frameset                  ; /* The frameset for one product */

    cpl_parameterlist*        inparams                              ; /* The recipe input parameters */

    cpl_parameterlist*        framecomb_parameterlist               ; /* The recipe input parameters */

    const char*                     modem_efficiency_outfilename          ; /* The parameter of zpl.modem_efficiency.outfilename */

    const char*                     modem_efficiency_outfilename_cam1     ; /* The parameter of zpl.modem_efficiency.outfilename_cam1 */

    const char*                     modem_efficiency_outfilename_cam2     ; /* The parameter of zpl.modem_efficiency.outfilename_cam2 */

    const char*                     modem_efficiency_plus_outfilename     ; /* The parameter of zpl.modem_efficiency_qplus.outfilename */

    const char*                     modem_efficiency_plus_outfilename_cam1; /* The parameter of zpl.modem_efficiency_qplus.outfilename_cam1 */

    const char*                     modem_efficiency_minus_outfilename    ; /* The parameter of zpl.modem_efficiency_qminus.outfilename */

    const char*                     modem_efficiency_minus_outfilename_cam1; /* The parameter of zpl.modem_efficiency_qminus.outfilename_cam1 */

    const char*                     modem_efficiency_plus_outfilename_cam2; /* The parameter of zpl.modem_efficiency_qplus.outfilename_cam2 */

    const char*                     modem_efficiency_minus_outfilename_cam2; /* The parameter of zpl.modem_efficiency_qminus.outfilename_cam2 */

    short                           subtract_overscan                     ; /* The parameter of zpl.modem_efficiency.subtract_overscan */

    int                             coll_alg                              ; /* The parameter of zpl.modem_efficiency.coll_alg */

    int                             clean_mean_reject_high                ; /* The parameter of zpl.modem_efficiency.coll_alg.clean_mean.reject_high */

    int                             clean_mean_reject_low                 ; /* The parameter of zpl.modem_efficiency.coll_alg.clean_mean.reject_low */

    short                           keep_intermediate                     ; /* The parameter of zpl.modem_efficiency.keep_intermediate */

    const char*                     outfilename_cam1                      ; /* The parameter of zpl.preproc.outfilename_cam1 */

    const char*                     outfilename_cam2                      ; /* The parameter of zpl.preproc.outfilename_cam2 */

    cpl_frameset*                   rawframes                             ; /* The ZPL_MODEM_EFF_RAW frames */

    cpl_frameset*                   preproc_frames                        ; /* The ZPL_MODEM_EFF_PREPROC_RAW frames */

    cpl_frameset*                   preproc_frames_cam1                   ; /* The ZPL_MODEM_EFF_PREPROC_CAM1 frames */

    cpl_frameset*                   preproc_frames_cam2                   ; /* The ZPL_MODEM_EFF_PREPROC_CAM2 frames */

    cpl_frame*                      master_bias_frame                     ; /* The ZPL_MASTER_BIAS frames */

    cpl_frame*                      master_bias_frame_cam1                ; /* The ZPL_MASTER_BIAS_CAM1 frames */

    cpl_frame*                      master_bias_frame_cam2                ; /* The ZPL_MASTER_BIAS_CAM2 frames */

    cpl_frame*                      master_dark_frame                     ; /* The ZPL_MASTER_DARK frames */

    cpl_frame*                      master_dark_frame_cam1                ; /* The ZPL_MASTER_DARK_CAM1 frames */

    cpl_frame*                      master_dark_frame_cam2                ; /* The ZPL_MASTER_DARK_CAM2 frames */

    cpl_frame*                      intensity_flat_frame                  ; /* The ZPL_INT_FLAT_FIELD frames */

    cpl_frame*                      intensity_flat_frame_cam1             ; /* The ZPL_INT_FLAT_FIELD_CAM1 frames */

    cpl_frame*                      intensity_flat_frame_cam2             ; /* The ZPL_INT_FLAT_FIELD_CAM2 frames */

    cpl_frame*                      intensity_flat_frame_master           ; /* The ZPL_INT_FLAT_FIELD_MASTER frames */

    cpl_frame*                      intensity_flat_frame_master_cam1      ; /* The ZPL_INT_FLAT_FIELD_MASTER_CAM1 frames */

    cpl_frame*                      intensity_flat_frame_master_cam2      ; /* The ZPL_INT_FLAT_FIELD_MASTER_CAM2 frames */

    cpl_frame*                      polarization_flat_frame               ; /* The ZPL_POL_FLAT_FIELD frames */

    cpl_frame*                      polarization_flat_frame_cam1          ; /* The ZPL_POL_FLAT_FIELD_CAM1 frames */

    cpl_frame*                      polarization_flat_frame_cam2          ; /* The ZPL_POL_FLAT_FIELD_CAM2 frames */

    sph_master_frame*               modem_efficiency                      ; /* The ZPL_MODEM_EFF product */

    sph_master_frame*               modem_efficiency_cam1                 ; /* The ZPL_MODEM_EFF_CAM1 product */

    sph_double_image*               modem_eff_di_plus                     ; /* The ZPL_MODEM_EFF_QPLUS product */

    sph_double_image*               modem_eff_di_plus_cam1                ; /* The ZPL_MODEM_EFF_QPLUS_CAM1 product */

    sph_double_image*               modem_eff_di_minus                    ; /* The ZPL_MODEM_EFF_QMINUS product */

    sph_double_image*               modem_eff_di_minus_cam1               ; /* The ZPL_MODEM_EFF_QMINUS_CAM1 product */

    sph_master_frame*               modem_efficiency_cam2                 ; /* The ZPL_MODEM_EFF_CAM2 product */

    sph_double_image*               modem_eff_di_plus_cam2                ; /* The ZPL_MODEM_EFF_QPLUS_CAM2 product */

    sph_double_image*               modem_eff_di_minus_cam2               ; /* The ZPL_MODEM_EFF_QMINUS_CAM2 product */

} sph_zpl_modem_efficiency;

/*-------------------------------------------------------------------------------
 * Error codes
 * 
 * Below the various error codes for this module are declared.
 * ------------------------------------------------------------------------------
 */

int sph_zpl_modem_efficiency_create_test(cpl_plugin *);


/*-------------------------------------------------------------------------------
 * The methods
 * 
 * These are the methods for sph_zpl_modem_efficiency.
 * 
 * ------------------------------------------------------------------------------
 */

sph_zpl_modem_efficiency* sph_zpl_modem_efficiency_new( cpl_frameset * frameset, 
                                              cpl_parameterlist * parlist);

sph_error_code  sph_zpl_modem_efficiency_check_frames( sph_zpl_modem_efficiency* self );

sph_error_code sph_zpl_modem_efficiency_check_params( sph_zpl_modem_efficiency* parlist );

cpl_error_code sph_zpl_modem_efficiency_run( sph_zpl_modem_efficiency* self );

sph_error_code sph_zpl_modem_efficiency_delete( sph_zpl_modem_efficiency* self );
cpl_parameterlist*  sph_zpl_modem_efficiency_create_paramlist(void) CPL_ATTR_ALLOC;

/* Extra function declarations that are defined in sph_zpl_modem_efficiency.c */


/* End of extra function declarations that are defined in sph_zpl_modem_efficiency_run.c */



#endif /*SPH_ZPL_MODEM_EFFICIENCY_H_*/
