/***********************************************************************************************/
/******** DANGER !! DANGER !! DANGER !! DO NOT EDIT FILE -- IT WAS GENERATED AUTOMATICALLY !!! */
/***********************************************************************************************/

/* $Id: $
 * This file is part of the SPHERE Pipeline
 * Copyright (C) 2007-2010 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: $
 * $Date: $
 * $Revision: $
 * $Name: $
 */

/*-----------------------------------------------------------------------------
 Includes
 -----------------------------------------------------------------------------*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "sph_zpl_preproc.h"
#include "sph_common_keywords.h"
#include "sph_zpl_keywords.h"
#include "sph_zpl_tags.h"
#include "sph_master_frame.h"
#include "sph_error.h"
#include "sph_cube.h"
#include "sph_utils.h"

#include <math.h>
#include <assert.h>
#include <cpl.h>

/*-----------------------------------------------------------------------------
  Error Codes
 -----------------------------------------------------------------------------*/

sph_error_code SPH_ZPL_PREPROC_GENERAL              = SPH_ZPL_PREPROC_ERR_START + 0;
sph_error_code SPH_ZPL_PREPROC_NO_VALID_DIT_LIST    = SPH_ZPL_PREPROC_ERR_START + 1;

sph_error_code SPH_ZPL_PREPROC_PARAMETER_MISSING    = SPH_ZPL_PREPROC_ERR_START + 3;
sph_error_code SPH_ZPL_PREPROC_FRAMES_MISSING       = SPH_ZPL_PREPROC_ERR_START + 4;

/*-----------------------------------------------------------------------------
 Private function prototypes
 -----------------------------------------------------------------------------*/

static int sph_zpl_preproc_create_plugin ( cpl_plugin * );
static int sph_zpl_preproc_exec_plugin ( cpl_plugin * );
static int sph_zpl_preproc_destroy_plugin ( cpl_plugin * );

/*-----------------------------------------------------------------------------
 Static variables
 -----------------------------------------------------------------------------*/

static const char* sph_zpl_preproc_help = 
    "RECIPE INPUT FRAMES: \n"
    "-------------------- \n"
    "Tag                           Min,Max   Description\n"
    "ZPL_PREPROC_RAW                 1, -1   The raw  frames in the polarimetric modes with the two extensions  fits file format:\n"
    "                                        - first extension represents data cube of NDITS frames from camera-1 for a given DIT, including prescan/overscan area of 2 ADUs;\n"
    "                                        - second extension represents data cube of NDITS zimpol frames from camera-2 for a given DIT, including prescan/overscan area of 2 ADUs\n"
    "\n"
    "RAW FRAME KEYWORDS: \n"
    "-------------------- \n"
    "Keyword                       Type   Optional  Description\n"
    "ESO DET READ CURNAME          string Yes       KEYWORD NAME for the Detector Read Mode \n"
    "ESO DET OUT1 X                int    Yes       KEWWORD NAME for X location of output, camera-1 \n"
    "ESO DET OUT1 Y                int    Yes       KEWWORD NAME for Y location of output, camera-1 \n"
    "ESO DET OUT1 NX               int    Yes       Output-1 data pixels in X, camera-1 \n"
    "ESO DET OUT1 NY               int    Yes       Output-1 data pixels in Y, camera-1 \n"
    "ESO DET OUT1 OVSCX            int    Yes       Output overscan pixels in X, camera-1 \n"
    "ESO DET OUT1 OVSCY            int    Yes       Output-1 overscan pixels in Y, camera-1 \n"
    "ESO DET OUT1 PRSCX            int    Yes       Output-1 prescan pixels in X, camera-1 \n"
    "ESO DET OUT1 PRSCY            int    Yes       Output-1prescan pixels in Y, camera-1 \n"
    "ESO DET OUT2 X                int    Yes       KEYWORD NAME for X location of output 2, camera-1 \n"
    "ESO DET OUT2 Y                int    Yes       KEYWORD NAME for Y location of output 2, camera-1 \n"
    "ESO DET OUT2 NX               int    Yes       Output-2 data pixels in X, camera-1 \n"
    "ESO DET OUT2 NY               int    Yes       Output 2 data pixels in Y, camera-1 \n"
    "ESO DET OUT2 OVSCX            int    Yes       Output 2 overscan pixels in X, camera-1 \n"
    "ESO DET OUT2 OVSCY            int    Yes       Output-2 overscan pixels in Y, camera-1 \n"
    "ESO DET OUT2 PRSCX            int    Yes       Output-2 prescan pixels in X, camera-1 \n"
    "ESO DET OUT2 PRSCY            int    Yes       Output-2 prescan pixels in Y, camera-1 \n"
    "ESO DET OUT1 X                int    Yes       KEWWORD NAME for X location of output, camera-2 \n"
    "ESO DET OUT1 Y                int    Yes       KEWWORD NAME for Y location of output, camera-2 \n"
    "ESO DET OUT1 NX               int    Yes       Output-1 data pixels in X, camera-2 \n"
    "ESO DET OUT1 OVSCX            int    Yes       Output-1 overscan pixels in X, camera-2 \n"
    "ESO DET OUT1 OVSCY            int    Yes       Output-1 prescan pixels in Y, camera-2 \n"
    "ESO DET OUT1 PRSCX            int    Yes       Output-1 prescan pixels in X, camera-2 \n"
    "ESO DET OUT1 PRSCY            int    Yes       Output-1 prescan pixels in Y, camera-2 \n"
    "ESO DET OUT2 X                int    Yes       KEWWORD NAME for X location of output, camera-2 \n"
    "ESO DET OUT2 Y                int    Yes       KEWWORD NAME for Y location of output, camera-2 \n"
    "ESO DET OUT2 NX               int    Yes       Output-2 data pixels in X, camera-2 \n"
    "ESO DET OUT2 NY               int    Yes       Output-2 data pixels in Y, camera-2 \n"
    "ESO DET OUT2 OVSCX            int    Yes       Output 2 overscan pixels in X, camera-2 \n"
    "ESO DET OUT2 OVSCY            int    Yes       Output-2 overscan pixels in Y, camera-2 \n"
    "ESO DET OUT2 PRSCX            int    Yes       Output-2 prescan pixels in X, camera-2 \n"
    "ESO DET OUT2 PRSCY            int    Yes       Output-2 prescan pixels in Y, camera-2 \n"
    "\n"
    "DESCRIPTION:\n"
    "------------\n"
    "This recipe performs pre-processing steps for the raw data in the polarimetric modes.\n"
    "The pre-processing is an utility recipe and should be only used by off-line data reduction!\n"
    "\n"
    "The raw frame in the polarimetric modes are two extensions  fits-file format:\n"
    "-   first extension represents data cube of NDITS frames from camera-1\n"
    "    for a given DIT, including prescan /overscan area of 2 ADUs;\n"
    "\n"
    "-   second extension represents data cube of NDITS zimpol frames from\n"
    "    camera-2 for a given DIT, including prescan / overscan area of 2\n"
    "    ADUs.\n"
    "\n"
    "\n"
    "\n"
    "No other frame is used in this recipe.\n"
    "In all polarimetric ZIMPOL  modes (P1,P2,P3)  detector mode is always double-phase mode.\n"
    "In the double-phase detector mode one single ZIMPOL-exposure is output of two consecutive images/frames from one CCD:\n"
    "-   the 1 image is the k-th ZIMPOL frame recorded at phase one=Phase 0\n"
    "\n"
    "-   the 2 image is the k+1 ZIMPOL frame recorded at phase one=Phase PI\n"
    "\n"
    "\n"
    "\n"
    "Each frame contains 2-interlaced sub-frames, storing 2 complimentary polarization component images.\n"
    "The input raw cube frame should carry SPH_ZPL_TAG_PREPROC_RAW tag  is read first and then the following pre-processing\n"
    "steps are performed:\n"
    "1.  extract each camera from the each extension (>>two camera\n"
    "    cubes<<);\n"
    "\n"
    "2.  combine the 2 detector segments (ADU) into a single image >>trim\n"
    "    away<< prescan/overscan areas from images;\n"
    "\n"
    "3.  compute the mean overscan bias level from the overscan areas;\n"
    "\n"
    "4.  cut junk rows for Phase 0 (one bottom and one upper >>binned\n"
    "    pixel<< row);\n"
    "\n"
    "5.  cut junk rows for Phase PI (two upper >>binned pixel<<);\n"
    "\n"
    "6.  split into even and odd sub-frames;\n"
    "\n"
    "7.  for each two single raw images (phase 0 and pi) create a plane with\n"
    "    4 extensions;\n"
    "\n"
    "8.  create an output fits files with four images extension and one\n"
    "    binary table extension with the computed\n"
    "\n"
    "    mean values of the overscan bias level and its rms (8 cols).\n"
    "\n"
    "\n"
    "\n"
    "Since the zimpol frame is square, splitting the two sub-frames yields to the 1:2 aspect ratio.\n"
    "The output product is two fits-cube files (camera-1 and camera-2) of the ZPL EXP format specified as follows:\n"
    "phase zero odd sub-frame image;\n"
    "\n"
    "phase zero even sub-frame image;\n"
    "\n"
    "phase PI odd sub-frame image;\n"
    "\n"
    "phase PI even sub-frame;\n"
    "\n"
    "table of mean overscan bias level values and its rms (8 cols):\n"
    "\n"
    "<span>**[1-col, 2-col]**</span> ADU1 ZERO PHASE OVSC MEAN & ADU1 ZERO\n"
    "PHASE OVSC RMS\n"
    "\n"
    "<span>**[3-col, 4-col]**</span> ADU2 ZERO PHASE OVSC MEAN & ADU2 ZERO\n"
    "PHASE OVSC RMS\n"
    "\n"
    "<span>**[5-col, 6-col]**</span> ADU1 PI PHASE OVSC MEAN & ADU1 PI PHASE\n"
    "OVSC RMS\n"
    "\n"
    "<span>**[7-col, 8-col]**</span> ADU2 PI PHASE OVSC MEAN & ADU2 PI PHASE\n"
    "OVSC RMS\n"
    "\n"
    "\n"
    "These pre-processing products may be used in all subsequent polarimetric recipes.\n"
    "\n"
    "RECIPE PRODUCTS: \n"
    "-------------------- \n"
    "Tag                      Format         Description\n"
    "ZPL_PREPROC                        FITS[Im(4),Bt(1)]The output product is two fits-cube files with 5 extensions (for camera-1 and camera-2) of\n"
    "                                        the ZPL EXP format  specified as follows:\n"
    "                                        - phase zero odd sub-frame image;\n"
    "                                        - phase zero even  sub-frame  image;\n"
    "                                        - phase PI odd sub-frame image;\n"
    "                                        - phase PI even sub-frame;\n"
    "                                        table of mean overscan bias level values and its rms (8 cols):\n"
    "                                        - ADU1 ZERO PHASE OVSC MEAN, ADU1 ZERO PHASE OVSC RMS, ADU2 ZERO PHASE OVSC MEAN, ADU2 ZERO PHASE OVSC RMS,\n"
    "                                        - ADU1 PI PHASE OVSC MEAN, ADU1 PI PHASE OVSC RMS, ADU2 PI PHASE OVSC MEAN, ADU2 PI PHASE OVSC RMS\n"
    "\n"
    "PRODUCT FRAME KEYWORDS: \n"
    "-------------------- \n"
    "Keyword                       Frame          Type    Description\n"
    "\n"
;

/*-----------------------------------------------------------------------------
 Function code
 -----------------------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/
/**
 * @defgroup sph_zpl_preproc Create Master Dark Recipe
 *
 * This module provides the recipe plugin and relating functions for the
 * creation of the master dark .
 *
 * @par Synopsis:
 * @code
 *   #include "sph_zpl_preproc.h"
 * @endcode
 */
/*----------------------------------------------------------------------------*/
/**@{*/

/*****************************************************************************
 *
 *
 *      First come the static and global functions necessary for the
 *      normal working of the recipe as plugin....
 *
 *
 * ***************************************************************************/
/*----------------------------------------------------------------------------*/
/**
 @brief    Build the list of available plugins, for this module.
 @param    list    the plugin list
 @return   0 if everything is ok, 1 otherwise
 @note     Only this function is exported

 Create the recipe instance and make it available to the application
 using the interface.
 */
/*----------------------------------------------------------------------------*/
int cpl_plugin_get_info(cpl_pluginlist * list)
{
    cpl_recipe * recipe = cpl_calloc( 1, sizeof *recipe);
    cpl_plugin * plugin = &recipe->interface;

    if (cpl_plugin_init(plugin,
                        CPL_PLUGIN_API,
                        SPH_ZPL_PREPROC_VERSION,
                        CPL_PLUGIN_TYPE_RECIPE,
                        "sph_zpl_preproc",
                        "Pre-processing of the zimpol raw data, polarimetric modes (utlity recipe).",
                        sph_zpl_preproc_help, "Alexey Pavlov <pavlov@mpia-hd.mpg.de>",
                        "https://support.eso.org", cpl_get_license("SPHERE DRH","2012"),
                        sph_zpl_preproc_create_plugin,
                        sph_zpl_preproc_exec_plugin,
                        sph_zpl_preproc_destroy_plugin) )
    {
        cpl_msg_error( cpl_func, "Plugin initialization failed");
        (void)cpl_error_set_where( cpl_func );
        return 1;
    }

    if (cpl_pluginlist_append(list, plugin) )
    {
        cpl_msg_error( cpl_func, "Error adding plugin to list");
        (void)cpl_error_set_where( cpl_func );
        return 1;
    }
    return 0;
}

/*----------------------------------------------------------------------------*/
/**
 @brief    Setup the recipe options
 @param    plugin  the plugin
 @return   0 if everything is ok

 Defining the command-line/configuration parameters for the recipe.
 */
/*----------------------------------------------------------------------------*/
static int sph_zpl_preproc_create_plugin(cpl_plugin * plugin)
{
    if (cpl_error_get_code() != CPL_ERROR_NONE)
    {
        cpl_msg_error( cpl_func, "%s():%d: An error is already set: %s",
                       cpl_func, __LINE__, cpl_error_get_where());
        return (int)cpl_error_get_code();
    }

    if (plugin == NULL)
    {
        cpl_msg_error(cpl_func, "Null plugin");
        cpl_ensure_code(0, (int)CPL_ERROR_NULL_INPUT);
    }

    if (cpl_plugin_get_type(plugin) != CPL_PLUGIN_TYPE_RECIPE)
    {
        cpl_msg_error( cpl_func, "Plugin is not a recipe");
        cpl_ensure_code( 0, (int)CPL_ERROR_TYPE_MISMATCH );
    }

    if ( plugin != NULL ) {
        cpl_recipe * recipe = (cpl_recipe *)plugin;
        recipe->parameters = sph_zpl_preproc_create_paramlist();
        if ( recipe->parameters == NULL ) {
            return SPH_ZPL_PREPROC_GENERAL;
        }
    }
    return 0;
}

/*----------------------------------------------------------------------------*/
/**
 @brief    Testing for setup of the recipe options
 @param    plugin  the plugin
 @return   0 if everything is ok

 Wrapper to make the static plugin creation function accessible from outside
 for testing purposes.
 */
/*----------------------------------------------------------------------------*/
int sph_zpl_preproc_create_test(cpl_plugin * plugin)
{
    return (int)sph_zpl_preproc_create_plugin(plugin);
}

/*----------------------------------------------------------------------------*/
/**
 @brief    Execute the plugin instance given by the interface
 @param    plugin  the plugin
 @return   0 if everything is ok
 */
/*----------------------------------------------------------------------------*/
static int sph_zpl_preproc_exec_plugin(cpl_plugin * plugin)
{

    cpl_recipe*             recipe                  = NULL;
    cpl_error_code          recipe_code;
    sph_zpl_preproc*    sph_recipe      = NULL;
    cpl_errorstate          initial_errorstate      = cpl_errorstate_get();

    if (cpl_error_get_code() != CPL_ERROR_NONE)
    {
        cpl_msg_error( cpl_func, "%s():%d: A cpl error is already set: %s",
        cpl_func, __LINE__, cpl_error_get_where());
        return (int)cpl_error_get_code();
    }

    if (plugin == NULL)
    {
        cpl_msg_error( cpl_func, "Null plugin");
        cpl_ensure_code( 0, (int)CPL_ERROR_NULL_INPUT );
        return (int)cpl_error_get_code();
    }

    if (cpl_plugin_get_type(plugin) != CPL_PLUGIN_TYPE_RECIPE)
    {
        cpl_msg_error( cpl_func, "Plugin is not a recipe");
        cpl_ensure_code( 0, (int)CPL_ERROR_TYPE_MISMATCH );
        return (int)cpl_error_get_code();
    }

    recipe = (cpl_recipe *)plugin;

    if (recipe->parameters == NULL)
    {
        cpl_msg_error( cpl_func, "Recipe invoked with NULL parameter list");
        cpl_ensure_code( 0, (int)CPL_ERROR_NULL_INPUT );
        return (int)cpl_error_get_code();
    }

    if (recipe->frames == NULL)
    {
        cpl_msg_error( cpl_func, "Recipe invoked with NULL frame set");
        cpl_ensure_code( 0, (int)CPL_ERROR_NULL_INPUT );
        return (int)cpl_error_get_code();
    }

    sph_recipe = sph_zpl_preproc_new( recipe->frames, recipe->parameters );
    if ( sph_recipe == NULL ) {
        recipe_code = cpl_error_set_where(cpl_func);
    } else {

        recipe_code = sph_zpl_preproc_run( sph_recipe );

        sph_zpl_preproc_delete( sph_recipe );
    }

    if ( !cpl_errorstate_is_equal(initial_errorstate) )
    {
        cpl_errorstate_dump(initial_errorstate, CPL_FALSE, NULL);
    }
    sph_end_erex(); //close the sphere system
    return (int)(recipe_code >= CPL_ERROR_EOL /* Workaround esorex PIPE-6887 */
                 ? CPL_ERROR_EOL : recipe_code);
}

/*----------------------------------------------------------------------------*/
/**
 @brief    Destroy what has been created by the 'create' function
 @param    plugin  the plugin
 @return   0 if everything is ok
 */
/*----------------------------------------------------------------------------*/
static int sph_zpl_preproc_destroy_plugin(cpl_plugin * plugin)
{
    cpl_recipe * recipe;

    if (plugin == NULL)
    {
        cpl_msg_error( cpl_func, "Null plugin");
        cpl_ensure_code( 0, (int)CPL_ERROR_NULL_INPUT );
    }

    if (cpl_plugin_get_type(plugin) != CPL_PLUGIN_TYPE_RECIPE)
    {
        cpl_msg_error( cpl_func, "Plugin is not a recipe");
        cpl_ensure_code( 0, (int)CPL_ERROR_TYPE_MISMATCH );
    }

    recipe = (cpl_recipe *)plugin;

    cpl_parameterlist_delete(recipe->parameters);

    return 0;
}

/*****************************************************************************
 *
 *
 *      Here come the "Member" functions of the sph_zpl_preproc struct
 *
 *
 * ***************************************************************************/

/*----------------------------------------------------------------------------*/
/**
 @brief    Fill a pre-allocated parameterlist for the recipe
 @param    result A pre-allocated parameterlist
 @return   CPL_ERROR_NONE iff successful

 This function fills the standard parameterlist for the recipe

 */
/*----------------------------------------------------------------------------*/
static cpl_error_code sph_zpl_preproc_fill_parameterlist(cpl_parameterlist * result)
{
    cpl_parameter* p;

        /* Code to set up parameters GENERATED DO NOT EDIT */

        p = cpl_parameter_new_value("zpl.preproc.outfilename_cam1",
                                   CPL_TYPE_STRING,
                                   "The output postfix-filename of the pre-processed raw data for CAMERA-1. "
                                   ,"zpl.preproc",
                                   "preproc_cam_1.fits" );

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_value("zpl.preproc.outfilename_cam2",
                                   CPL_TYPE_STRING,
                                   "The output postfix-filename of the pre-processed raw data for CAMERA-2. "
                                   ,"zpl.preproc",
                                   "preproc_cam_2.fits" );

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        /* End of code to set up parameters BUT ITS STILL NOT SAFE TO EDIT! FILE IS GENERATED !*/

    return cpl_error_set_where(cpl_func);
}
/*----------------------------------------------------------------------------*/
/**
 @brief  Create and return the standard parameterlist for the recipe
 @return The standard parameterlist or NULL on error
 @note   The returned object must be deallocated using cpl_parameterlist_delete

 */
/*----------------------------------------------------------------------------*/
cpl_parameterlist* sph_zpl_preproc_create_paramlist(void)
{
    cpl_parameterlist* self = cpl_parameterlist_new();

    if (sph_zpl_preproc_fill_parameterlist(self)) {
        cpl_parameterlist_delete(self);
        self = NULL;
        (void)cpl_error_set_where(cpl_func);
    }

    return self;
}

/*----------------------------------------------------------------------------*/
/**
 @brief    Check the recipe frames, and assign them to the sph_zpl_preproc
           structure.
 @param    self     the sph_zpl_preproc recipe structure
 @return   error code of the check.

 This checks the frames that were given in the sph_zpl_preproc_new function
 as parameters for the correctness and completeness. If the frames needed are
 found they are also assigned to the corresponding structure members.

 The return value is the error code of the check.
 */
/*----------------------------------------------------------------------------*/
sph_error_code  sph_zpl_preproc_check_frames( sph_zpl_preproc* self )
{
    sph_error_code           rerr            = CPL_ERROR_NONE;
    /* Code to check frames GENERATED DO NOT EDIT */

    cpl_frame* aframe;
    aframe = cpl_frameset_find( self->inframes, SPH_ZPL_TAG_PREPROC_RAW );
    while ( aframe ) {
        cpl_frame_set_group( aframe, CPL_FRAME_GROUP_RAW );
        aframe = cpl_frameset_find( self->inframes, NULL );
    }
    self->rawframes = sph_utils_extract_frames( self->inframes, SPH_ZPL_TAG_PREPROC_RAW );
    if ( ! self->rawframes )
    {
        sph_error_raise( SPH_ZPL_PREPROC_FRAMES_MISSING,
                         __FILE__, __func__, __LINE__ ,
                         SPH_ERROR_ERROR,
                         "Could not extract rawframes frames."
                         "to use them check that they have the %s tag.",
                         SPH_ZPL_TAG_PREPROC_RAW);
        rerr = SPH_ZPL_PREPROC_FRAMES_MISSING;
        return rerr;
    }

    else {

         int numframes = (int)cpl_frameset_get_size( self->rawframes );
         for ( int ii = 0; ii < numframes; ++ii ) {
             cpl_frame* iframe = cpl_frameset_get_position( self->rawframes, ii );
             const char* ifname = cpl_frame_get_filename(iframe);
             cpl_propertylist* pl = cpl_propertylist_load(ifname, 0);
             if (pl == NULL ) {
                 sph_error_raise(cpl_error_get_code(),
                    __FILE__, __func__, __LINE__ ,SPH_ERROR_ERROR,
                 "Could not read keywords from file %s. "
                 "Either the file is not readable or corrupted. ",
                  ifname);
             }
             else {
                 rerr = cpl_frame_set_group( iframe, CPL_FRAME_GROUP_RAW );
                 cpl_propertylist_delete(pl); pl=NULL;
             }
         }
         numframes -= (int)cpl_frameset_get_size( self->rawframes );
         assert( numframes == 0);
    }

    /* End of code to check frames BUT ITS STILL NOT SAFE TO EDIT! FILE IS GENERATED !*/
    self->current_raw_frameset = sph_utils_extract_frames_group( self->inframes, CPL_FRAME_GROUP_RAW );

    return rerr;
}

/*----------------------------------------------------------------------------*/
/**
 @brief    Check the recipe parameters, and assign them to the sph_zpl_preproc
           structure.
 @param    self     the sph_zpl_preproc recipe structure
 @return   error code of the check.

 This checks the parameters that were given in the sph_zpl_preproc_new function
 as parameters for the correctness and completeness. If the parameters needed are
 found they are also assigned to the corresponding structure members.

 The return value is the error code of the check.
 */
/*----------------------------------------------------------------------------*/
sph_error_code sph_zpl_preproc_check_params( sph_zpl_preproc* self ) {
    sph_error_code                 rerr               = CPL_ERROR_NONE;
    const cpl_parameter*           param              = NULL;

    if ( self->framecomb_parameterlist != NULL ) {
        cpl_parameterlist_delete( self->framecomb_parameterlist );
        self->framecomb_parameterlist = NULL;
    }
    self->framecomb_parameterlist = cpl_parameterlist_new();
    /* Code to check parameters GENERATED DO NOT EDIT */

    param = cpl_parameterlist_find_const( self->inparams,
                                          "zpl.preproc.outfilename_cam1");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "zpl.preproc.outfilename_cam1");
    }

    self->outfilename_cam1 = cpl_parameter_get_string(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    param = cpl_parameterlist_find_const( self->inparams,
                                          "zpl.preproc.outfilename_cam2");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "zpl.preproc.outfilename_cam2");
    }

    self->outfilename_cam2 = cpl_parameter_get_string(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    /* End of code to check parameters BUT ITS STILL NOT SAFE TO EDIT! FILE IS GENERATED !*/

    return rerr;
}
/*----------------------------------------------------------------------------*/
/**
 @brief    Create a new sph_zpl_preproc structure.

 @param    frameset     the input recipe frames
 @param    parlist      the input recipe parameters

 @return   pointer to newly created structure or NULL in case of error

 This creates a new sph_zpl_preproc_structure and fills the inparams and
 inframes fields with the pointers pf frameset and parlist.
 The return value is the error code of the check.
 */
/*----------------------------------------------------------------------------*/
sph_zpl_preproc* sph_zpl_preproc_new( cpl_frameset * frameset,
                                              cpl_parameterlist * parlist )
{
    sph_zpl_preproc*    result      = NULL;
    int                     rerr        = CPL_ERROR_NONE;

    sph_init_erex();
    if ( frameset == NULL || parlist == NULL ) {
        sph_error_raise( CPL_ERROR_NULL_INPUT, __FILE__,
                         __func__, __LINE__,
                         SPH_ERROR_ERROR,
                         "Null input pointer.");
        return NULL;
    }

    result = cpl_calloc( 1, sizeof(sph_zpl_preproc) );

    if ( result == NULL ) {
        sph_error_raise( SPH_ZPL_PREPROC_GENERAL, __FILE__, __func__,
                         __LINE__, SPH_ERROR_ERROR,
                         "Could not allocate the structure.");
        return result;
    }

    result->inframes = frameset;
    result->inparams = parlist;

    rerr = sph_zpl_preproc_check_frames( result );
    if ( rerr == CPL_ERROR_NONE) rerr = sph_zpl_preproc_check_params( result );

    if ( rerr != CPL_ERROR_NONE ) {
        if ( result ) {
            sph_zpl_preproc_delete( result );
        }
        result = NULL;
    }

    return result;
}

/*----------------------------------------------------------------------------*/
/**
 @brief    Delete the sph_zpl_preproc structure.

 @param    self         the structure tp delete

 @return   error code of the operation

 This creates a new sph_zpl_preproc_structure and fills the inparams and
 inframes fields with the pointers pf frameset and parlist.
 The return value is the error code of the check.
 */
/*----------------------------------------------------------------------------*/
sph_error_code sph_zpl_preproc_delete( sph_zpl_preproc* self )
{
    sph_error_code          rerr            = CPL_ERROR_NONE;

    if ( self == NULL ) {
        sph_error_raise( CPL_ERROR_NULL_INPUT, __FILE__,
                         __func__, __LINE__,
                         SPH_ERROR_ERROR,
                         "Null input pointer.");
        return rerr;
    }

    if ( self->framecomb_parameterlist != NULL ) {
        cpl_parameterlist_delete( self->framecomb_parameterlist );
        self->framecomb_parameterlist = NULL;
    }

    /* Code to delete recipe pointers GENERATED DO NOT EDIT */

    if ( self->rawframes != NULL ) {
        cpl_frameset_delete( self->rawframes );
        self->rawframes = NULL;
    }
 
    cpl_frameset_delete(self->preproc_frameset);
    /* End of code to delete pointers BUT ITS STILL NOT SAFE TO EDIT! FILE IS GENERATED !*/
    if ( self->current_raw_frameset ) {
        cpl_frameset_delete(self->current_raw_frameset);
        self->current_raw_frameset = NULL;
    }
    sph_polygon_free_all();
    cpl_free(    self);
    return rerr;

}


/**@}*/
