/***********************************************************************************************/
/******** DANGER !! DANGER !! DANGER !! DO NOT EDIT FILE -- IT WAS GENERATED AUTOMATICALLY !!! */
/***********************************************************************************************/

/* $Id: $
 * This file is part of the SPHERE Pipeline
 * Copyright (C) 2007-2010 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: $
 * $Date: $
 * $Revision: $
 * $Name: $
 */

/*-----------------------------------------------------------------------------
 Includes
 -----------------------------------------------------------------------------*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "sph_zpl_science_imaging.h"
#include "sph_common_keywords.h"
#include "sph_zpl_keywords.h"
#include "sph_zpl_tags.h"
#include "sph_master_frame.h"
#include "sph_error.h"
#include "sph_cube.h"
#include "sph_utils.h"

#include <math.h>
#include <assert.h>
#include <cpl.h>

/*-----------------------------------------------------------------------------
  Error Codes
 -----------------------------------------------------------------------------*/

sph_error_code SPH_ZPL_SCIENCE_IMAGING_GENERAL              = SPH_ZPL_SCIENCE_IMAGING_ERR_START + 0;
sph_error_code SPH_ZPL_SCIENCE_IMAGING_NO_VALID_DIT_LIST    = SPH_ZPL_SCIENCE_IMAGING_ERR_START + 1;

sph_error_code SPH_ZPL_SCIENCE_IMAGING_PARAMETER_MISSING    = SPH_ZPL_SCIENCE_IMAGING_ERR_START + 3;
sph_error_code SPH_ZPL_SCIENCE_IMAGING_FRAMES_MISSING       = SPH_ZPL_SCIENCE_IMAGING_ERR_START + 4;

/*-----------------------------------------------------------------------------
 Private function prototypes
 -----------------------------------------------------------------------------*/

static int sph_zpl_science_imaging_create_plugin ( cpl_plugin * );
static int sph_zpl_science_imaging_exec_plugin ( cpl_plugin * );
static int sph_zpl_science_imaging_destroy_plugin ( cpl_plugin * );

/*-----------------------------------------------------------------------------
 Static variables
 -----------------------------------------------------------------------------*/

static const char* sph_zpl_science_imaging_help = 
    "RECIPE INPUT FRAMES: \n"
    "-------------------- \n"
    "Tag                           Min,Max   Description\n"
    "ZPL_SCIENCE_IMAGING_RAW         0, -1   I. NEW STYLE (split format) -- The raw frames in the imaging mode with a primary HDU and image:\n"
    "                                        - represents data cube of NDITS frames from camera-1/2 for a given DIT, including prescan/overscan area of 2 ADUs.\n"
    "                                        II. OLD STYLE -- The raw frames in the image mode with the two extensions  fits file format:\n"
    "                                        - first extension represents data cube of NDITS frames from camera-1 for a given DIT, including prescan/overscan area of 2 ADUs;\n"
    "                                        - second extension represents data cube of NDITS zimpol frames from camera-2 for a given DIT, including prescan/overscan area of 2 ADUs\n"
    "ZPL_SCIENCE_IMAGING_PREPROC_RAW  0, -1   The pre-processed raw science frames, imaging mode. To be taken with different illumination levels.\n"
    "                                        Format: ZPL EXP IMAGING\n"
    "ZPL_SCIENCE_IMAGING_PREPROC_CAM1  0, -1   The pre-processed raw science frames, imaging mode. To be taken with different illumination levels.\n"
    "                                        Format: ZPL EXP IMAGING\n"
    "ZPL_SCIENCE_IMAGING_PREPROC_CAM2  0, -1   The pre-processed raw science frames, imaging mode. To be taken with different illumination levels.\n"
    "                                        Format: ZPL EXP IMAGING\n"
    "ZPL_MASTER_BIAS_IMAGING         0,  1   The master bias imaging frame. Should have readout mode as the pre-processed raw science imaging frames.\n"
    "                                        Format: DOUBLE IMAGE\n"
    "ZPL_MASTER_BIAS_IMAGING_CAM1    0,  1   The master bias imaging frame. Should have readout mode as the pre-processed raw science imaging frames.\n"
    "                                        Format: DOUBLE IMAGE\n"
    "ZPL_MASTER_BIAS_IMAGING_CAM2    0,  1   The master bias imaging frame. Should have readout mode as the pre-processed raw science imaging frames.\n"
    "                                        Format: DOUBLE IMAGE\n"
    "ZPL_MASTER_DARK_IMAGING         0,  1   The master dark imaging frame. Should have readout mode as the pre-processed raw science imaging frames.\n"
    "                                        Format: DOUBLE IMAGE\n"
    "ZPL_MASTER_DARK_IMAGING_CAM1    0,  1   The master dark imaging frame. Should have readout mode as the pre-processed raw science imaging frames.\n"
    "                                        Format: DOUBLE IMAGE\n"
    "ZPL_MASTER_DARK_IMAGING_CAM2    0,  1   The master dark imaging frame. Should have readout mode as the pre-processed raw science imaging frames.\n"
    "                                        Format: DOUBLE IMAGE\n"
    "ZPL_INT_FLAT_FIELD_IMAGING      0,  1   The master intensity imaging flat field frame. Should have readout mode as the pre-processed raw science imaging frames.\n"
    "                                        Format: DOUBLE IMAGE\n"
    "ZPL_INT_FLAT_FIELD_IMAGING_CAM1  0,  1   The master intensity imaging flat field frame. Should have readout mode as the pre-processed raw science imaging frames.\n"
    "                                        Format: DOUBLE IMAGE\n"
    "ZPL_INT_FLAT_FIELD_IMAGING_CAM2  0,  1   The master intensity imaging flat fielf frame. Should have readout mode as the pre-processed raw science imaging frames.\n"
    "                                        Format: DOUBLE IMAGE\n"
    "ZPL_STAR_CENTER_IMG_CAM1        0,  1   The star center calibrated frame, that provides the coordinates of the\n"
    "                                        field center in order to perform a correct image de-rotation.\n"
    "                                        Format: DOUBLE IMAGE\n"
    "ZPL_STAR_CENTER_IMG_CAM2        0,  1   The star center calibrated frame, that provides the coordinates of the\n"
    "                                        field center in order to perform a correct image de-rotation.\n"
    "                                        Format: DOUBLE IMAGE\n"
    "ZPL_STAR_CENTER_IMG             0,  1   The star center calibrated frame, that provides the coordinates of the\n"
    "                                        field center in order to perform a correct image de-rotation.\n"
    "                                        Format: DOUBLE IMAGE\n"
    "ZPL_FIELD_CENTER_TABLE          0, -1   The field center table frames (to be used in the case of the off-line pipeline).\n"
    "                                        This frame can either be a FITS file (binary table) or an ASCII table.\n"
    "                                        The table should gave one row for each input science image\n"
    "                                        (so, if e.g. 5 cubes of each 10 planes are this\n"
    "                                        table should have 50 rows) with the columns center-x(I) and center-y(I),\n"
    "                                        center-x(P) and center-y(P), angle,  where centers are given in pixel coordinates.\n"
    "                                        The ascii file should have a postfix <originalname>_preproc_cam1(2).fits_fctable.txt\n"
    "                                        Note: if this file is presented the star center calibration should be omitted\n"
    "                                        Format: ASCII/Binary table\n"
    "ZPL_FILTER_TABLE                0,  1   A filter table, when present used to determine the wavelength for the Strehl estimation.\n"
    "                                        This is a static calibration frame describing the ZIMPOL filters.\n"
    "                                        The format of the FITS table is\n"
    "                                                  \n"
    "                                        10A        10A       D           D            D          D\n"
    "                                        filter_key filter_id lambda_cam1 lambda_cam2  width_cam1 width_cam2\n"
    "                                                  \n"
    "ZPL_PHOT_STAR_TABLE             0,  1   A table containing names and fluxes of standard stars. Needs to be present\n"
    "                                        if zero-point determination is required.\n"
    "                                                  \n"
    "                                        11A     10A    32A     D   D   3A   9A    10A    D   D   D   D\n"
    "                                        Target  SpT    Catalog RA  DEC OTp3 HdNum HipNum F_I F_R F_V STD_V_R_I\n"
    "                                                  \n"
    "\n"
    "RAW FRAME KEYWORDS: \n"
    "-------------------- \n"
    "Keyword                       Type   Optional  Description\n"
    "ESO DRS PC PROD TYPE          string No        This keyword is mandatory if the pre-processed data are used. \n"
    "                                               As the format of the zimpol data is complicated, this keyword is introduced in order \n"
    "                                               to garantee that the input frames are imaging pre-processed data, \n"
    "                                               produced by the sph_zpl_preproc_imaging recipe which added this keyword automatically. \n"
    "                                               The value of this keyword is set up to >>SPH PC PREPROC ZPL EXP IMAGING<<. \n"
    "                                                              \n"
    "                                               Note: if raw data are used (default), then all keywords needed for the pre-processing recipe \n"
    "                                               (see sph_zpl_preproc_imaging) must be presented in the raw data. \n"
    "                                               SPH_COMMON_KEYWORD_CAM1_DITHERING_X		double	0	0	100.0 \n"
    "                                               X-position of the arm1(camera-1) [pix] \n"
    "                                               SPH_COMMON_KEYWORD_CAM1_DITHERING_Y		double	0	0	100.0 \n"
    "                                               Y-position of the arm1(camera-1) [pix] \n"
    "                                               SPH_COMMON_KEYWORD_CAM2_DITHERING_X		double	0	0	100.0 \n"
    "                                               X-position of the arm2(camera-2) [pix] \n"
    "                                               SPH_COMMON_KEYWORD_CAM2_DITHERING_Y		double	0	0	100.0 \n"
    "                                               Y-position of the arm2(camera-2) [pix] \n"
    "                                               SPH_COMMON_KEYWORD_DROT2_MODE	string	0	0	0 \n"
    "                                               De-rotator mode: ELEV(pupil stabilized), SKY(field stabilized) \n"
    "\n"
    "DESCRIPTION:\n"
    "------------\n"
    "The recipe reduces combined science frames for the imaging modes.\n"
    "\n"
    "The input frames might be either science imaging raw frames with the ZPL_SCIENCE_IMAGING_RAW tag\n"
    "or pre-processed science imaging frames, which should carry the ZPL_SCIENCE_IMAGING_PREPROC_CAM1 and/or\n"
    "ZPL_SCIENCE_IMAGING_PREPROC_CAM2 tags, and master bias frames (if any) with the\n"
    "ZPL_MASTER_BIAS_IMAGING_CAM1 and/or ZPL_MASTER_BIAS_IMAGING_CAM2 tags, and and master dark frames (if any) with the\n"
    "ZPL_MASTER_DARK_IMAGING_CAM1 and/or ZPL_MASTER_DARK_IMAGING_CAM2 tags, and intensity flat field frames (if any) with the\n"
    "ZPL_INT_FLAT_IMAGING_CAM1 and/or ZPL_INT_FLAT_IMAGING_CAM2 tags.\n"
    "\n"
    "If input frames are raw frames, the science imaging recipe first performs the pre-processing step for all input frames (raw cubes),\n"
    "creating corresponding pre-processed frames (cubes) for both ZIMPOL cameras (see also sph_zpl_preproc_imaging for the detailed description of the\n"
    "pre-processing step).\n"
    "\n"
    "The pre-processed imaging science frames are then calibrated (for each camera) by subtracting the master imaging bias\n"
    "and the master imaging dark, and divided by the corresponding intensity imaging flat field.\n"
    "The calibrated frames are de-dithered and de-rotated and then saved as intermediate products.\n"
    "Note: the calibration frames with SPH_ZPL_TAG_STAR_CENTER_IMG_CALIB_CAM1(CAM2) tags provide the\n"
    "center coordinates to rotate around. If these calibrations are not presented the center of the\n"
    "frames will be used (normally, xc=yc=512 pixel).\n"
    "\n"
    "The final step is to combine all these calibrated, de-dithered and de-rotated\n"
    "frames, using a standard mean algorithm.\n"
    "The combined frames for both cameras are of the DOUBLE IMAGE (8 extensions)\n"
    "format specified as follows:\n"
    "- combined intensity science image, badpixel-map, ncomb-map and rms-map.\n"
    "- combined science dark image (dark current), badpixel-map, ncomb-map and rms-map.\n"
    "\n"
    "The output double image frames are reduced pipeline data products for both cameras.\n"
    "\n"
    "Some additional notes:\n"
    "-   For a point-source an estimate of the Strehl ratio may be useful.\n"
    "    The presence of a filter table frame will enable the estimation,\n"
    "    which on failure will do nothing and on success will insert Strehl\n"
    "    related QC parameters for both cameras into the product headers\n"
    "    related to the second camera.\n"
    "\n"
    "\n"
    "\n"
    "RECIPE PRODUCTS: \n"
    "-------------------- \n"
    "Tag                      Format         Description\n"
    "ZPL_SCIENCE_IMAGING_REDUCED        FITS[Im(8)]    The resulting reduced science imaging frame of the DOUBLE IMAGING format for the camera-1.\n"
    "                                        This frame contains 8 image extensions:\n"
    "                                        - science intensity image, badpixel-map, ncomb-map and rms-map;\n"
    "                                        - science dark image (dark current), badpixel-map, ncomb-map and rms-map.\n"
    "ZPL_SCIENCE_IMAGING_REDUCED_CAM1   FITS[Im(8)]    The resulting reduced science imaging frame of the DOUBLE IMAGING format for the camera-1.\n"
    "                                        This frame contains 8 image extensions:\n"
    "                                        - science intensity image, badpixel-map, ncomb-map and rms-map;\n"
    "                                        - science dark image (dark current), badpixel-map, ncomb-map and rms-map.\n"
    "ZPL_SCIENCE_IMAGING_REDUCED_CAM2   FITS[Im(8)]    The resulting reduced science imaging frame of the DOUBLE IMAGING format for the camera-2.\n"
    "                                        This frame contains 8 image extensions:\n"
    "                                        - science intensity image, badpixel-map, ncomb-map and rms-map;\n"
    "                                        - science dark image (dark current), badpixel-map, ncomb-map and rms-map.\n"
    "\n"
    "PRODUCT FRAME KEYWORDS: \n"
    "-------------------- \n"
    "Keyword                       Frame          Type    Description\n"
    "\n"
;

/*-----------------------------------------------------------------------------
 Function code
 -----------------------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/
/**
 * @defgroup sph_zpl_science_imaging Create Master Dark Recipe
 *
 * This module provides the recipe plugin and relating functions for the
 * creation of the master dark .
 *
 * @par Synopsis:
 * @code
 *   #include "sph_zpl_science_imaging.h"
 * @endcode
 */
/*----------------------------------------------------------------------------*/
/**@{*/

/*****************************************************************************
 *
 *
 *      First come the static and global functions necessary for the
 *      normal working of the recipe as plugin....
 *
 *
 * ***************************************************************************/
/*----------------------------------------------------------------------------*/
/**
 @brief    Build the list of available plugins, for this module.
 @param    list    the plugin list
 @return   0 if everything is ok, 1 otherwise
 @note     Only this function is exported

 Create the recipe instance and make it available to the application
 using the interface.
 */
/*----------------------------------------------------------------------------*/
int cpl_plugin_get_info(cpl_pluginlist * list)
{
    cpl_recipe * recipe = cpl_calloc( 1, sizeof *recipe);
    cpl_plugin * plugin = &recipe->interface;

    if (cpl_plugin_init(plugin,
                        CPL_PLUGIN_API,
                        SPH_ZPL_SCIENCE_IMAGING_VERSION,
                        CPL_PLUGIN_TYPE_RECIPE,
                        "sph_zpl_science_imaging",
                        "Reduce science frames in the imaging modes.",
                        sph_zpl_science_imaging_help, "Alexey Pavlov <pavlov@mpia-hd.mpg.de>",
                        "https://support.eso.org", cpl_get_license("SPHERE DRH","2012"),
                        sph_zpl_science_imaging_create_plugin,
                        sph_zpl_science_imaging_exec_plugin,
                        sph_zpl_science_imaging_destroy_plugin) )
    {
        cpl_msg_error( cpl_func, "Plugin initialization failed");
        (void)cpl_error_set_where( cpl_func );
        return 1;
    }

    if (cpl_pluginlist_append(list, plugin) )
    {
        cpl_msg_error( cpl_func, "Error adding plugin to list");
        (void)cpl_error_set_where( cpl_func );
        return 1;
    }
    return 0;
}

/*----------------------------------------------------------------------------*/
/**
 @brief    Setup the recipe options
 @param    plugin  the plugin
 @return   0 if everything is ok

 Defining the command-line/configuration parameters for the recipe.
 */
/*----------------------------------------------------------------------------*/
static int sph_zpl_science_imaging_create_plugin(cpl_plugin * plugin)
{
    if (cpl_error_get_code() != CPL_ERROR_NONE)
    {
        cpl_msg_error( cpl_func, "%s():%d: An error is already set: %s",
                       cpl_func, __LINE__, cpl_error_get_where());
        return (int)cpl_error_get_code();
    }

    if (plugin == NULL)
    {
        cpl_msg_error(cpl_func, "Null plugin");
        cpl_ensure_code(0, (int)CPL_ERROR_NULL_INPUT);
    }

    if (cpl_plugin_get_type(plugin) != CPL_PLUGIN_TYPE_RECIPE)
    {
        cpl_msg_error( cpl_func, "Plugin is not a recipe");
        cpl_ensure_code( 0, (int)CPL_ERROR_TYPE_MISMATCH );
    }

    if ( plugin != NULL ) {
        cpl_recipe * recipe = (cpl_recipe *)plugin;
        recipe->parameters = sph_zpl_science_imaging_create_paramlist();
        if ( recipe->parameters == NULL ) {
            return SPH_ZPL_SCIENCE_IMAGING_GENERAL;
        }
    }
    return 0;
}

/*----------------------------------------------------------------------------*/
/**
 @brief    Testing for setup of the recipe options
 @param    plugin  the plugin
 @return   0 if everything is ok

 Wrapper to make the static plugin creation function accessible from outside
 for testing purposes.
 */
/*----------------------------------------------------------------------------*/
int sph_zpl_science_imaging_create_test(cpl_plugin * plugin)
{
    return (int)sph_zpl_science_imaging_create_plugin(plugin);
}

/*----------------------------------------------------------------------------*/
/**
 @brief    Execute the plugin instance given by the interface
 @param    plugin  the plugin
 @return   0 if everything is ok
 */
/*----------------------------------------------------------------------------*/
static int sph_zpl_science_imaging_exec_plugin(cpl_plugin * plugin)
{

    cpl_recipe*             recipe                  = NULL;
    cpl_error_code          recipe_code;
    sph_zpl_science_imaging*    sph_recipe      = NULL;
    cpl_errorstate          initial_errorstate      = cpl_errorstate_get();

    if (cpl_error_get_code() != CPL_ERROR_NONE)
    {
        cpl_msg_error( cpl_func, "%s():%d: A cpl error is already set: %s",
        cpl_func, __LINE__, cpl_error_get_where());
        return (int)cpl_error_get_code();
    }

    if (plugin == NULL)
    {
        cpl_msg_error( cpl_func, "Null plugin");
        cpl_ensure_code( 0, (int)CPL_ERROR_NULL_INPUT );
        return (int)cpl_error_get_code();
    }

    if (cpl_plugin_get_type(plugin) != CPL_PLUGIN_TYPE_RECIPE)
    {
        cpl_msg_error( cpl_func, "Plugin is not a recipe");
        cpl_ensure_code( 0, (int)CPL_ERROR_TYPE_MISMATCH );
        return (int)cpl_error_get_code();
    }

    recipe = (cpl_recipe *)plugin;

    if (recipe->parameters == NULL)
    {
        cpl_msg_error( cpl_func, "Recipe invoked with NULL parameter list");
        cpl_ensure_code( 0, (int)CPL_ERROR_NULL_INPUT );
        return (int)cpl_error_get_code();
    }

    if (recipe->frames == NULL)
    {
        cpl_msg_error( cpl_func, "Recipe invoked with NULL frame set");
        cpl_ensure_code( 0, (int)CPL_ERROR_NULL_INPUT );
        return (int)cpl_error_get_code();
    }

    sph_recipe = sph_zpl_science_imaging_new( recipe->frames, recipe->parameters );
    if ( sph_recipe == NULL ) {
        recipe_code = cpl_error_set_where(cpl_func);
    } else {

        recipe_code = sph_zpl_science_imaging_run( sph_recipe );

        sph_zpl_science_imaging_delete( sph_recipe );
    }

    if ( !cpl_errorstate_is_equal(initial_errorstate) )
    {
        cpl_errorstate_dump(initial_errorstate, CPL_FALSE, NULL);
    }
    sph_end_erex(); //close the sphere system
    return (int)(recipe_code >= CPL_ERROR_EOL /* Workaround esorex PIPE-6887 */
                 ? CPL_ERROR_EOL : recipe_code);
}

/*----------------------------------------------------------------------------*/
/**
 @brief    Destroy what has been created by the 'create' function
 @param    plugin  the plugin
 @return   0 if everything is ok
 */
/*----------------------------------------------------------------------------*/
static int sph_zpl_science_imaging_destroy_plugin(cpl_plugin * plugin)
{
    cpl_recipe * recipe;

    if (plugin == NULL)
    {
        cpl_msg_error( cpl_func, "Null plugin");
        cpl_ensure_code( 0, (int)CPL_ERROR_NULL_INPUT );
    }

    if (cpl_plugin_get_type(plugin) != CPL_PLUGIN_TYPE_RECIPE)
    {
        cpl_msg_error( cpl_func, "Plugin is not a recipe");
        cpl_ensure_code( 0, (int)CPL_ERROR_TYPE_MISMATCH );
    }

    recipe = (cpl_recipe *)plugin;

    cpl_parameterlist_delete(recipe->parameters);

    return 0;
}

/*****************************************************************************
 *
 *
 *      Here come the "Member" functions of the sph_zpl_science_imaging struct
 *
 *
 * ***************************************************************************/

/*----------------------------------------------------------------------------*/
/**
 @brief    Fill a pre-allocated parameterlist for the recipe
 @param    result A pre-allocated parameterlist
 @return   CPL_ERROR_NONE iff successful

 This function fills the standard parameterlist for the recipe

 */
/*----------------------------------------------------------------------------*/
static cpl_error_code sph_zpl_science_imaging_fill_parameterlist(cpl_parameterlist * result)
{
    cpl_parameter* p;

        /* Code to set up parameters GENERATED DO NOT EDIT */

        p = cpl_parameter_new_value("zpl.science_imaging.outfilename",
                                   CPL_TYPE_STRING,
                                   "The output filename for the product, camera-1/2. Please also see the esorex documentation "
                                   "for naming of output products. "
                                   ,"zpl.science_imaging",
                                   "zpl_science_imaging.fits" );

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_value("zpl.science_imaging.outfilename_cam1",
                                   CPL_TYPE_STRING,
                                   "The output filename for the product, camera-1. Please also see the esorex documentation "
                                   "for naming of output products. "
                                   ,"zpl.science_imaging",
                                   "zpl_science_imaging_cam1.fits" );

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_value("zpl.science_imaging.outfilename_cam2",
                                   CPL_TYPE_STRING,
                                   "The output filename for the product, camera2. Please also see the esorex documentation "
                                   "for naming of output products. "
                                   ,"zpl.science_imaging",
                                   "zpl_science_imaging_cam2.fits" );

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_value("zpl.science_imaging.subtract_overscan",
                                   CPL_TYPE_BOOL,
                                   "Flag to set if the overscan mean values must be subtracted from pre-processed data (TRUE) "
                                   "Note that this parameter is applied if pre-processed data containt overscan table "
                                   ,"zpl.science_imaging",
                                   1 );

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_enum("zpl.science_imaging.coll_alg",
                                   CPL_TYPE_INT,
                                   "Set the collapse algorithm. The available algorithms: 0 = Mean, 1 = Median. Default is 0 = Mean. "
                                   ,"zpl.science_imaging",
                                   0 ,
                                   2,0,1);

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_range("zpl.science_imaging.filter_radius",
                                   CPL_TYPE_DOUBLE,
                                   "Filter radius for the frame combination. A non zero value leads to suppression "
                                   "of high frequencies in the fourier domain before frame combination. The value "
                                   "expresses the minimum unsuppressed frequency as fraction of total frequency "
                                   "domain radius (a value of 1 would suppress essentially all frequencies). "
                                   ,"zpl.science_imaging",
                                   0.0 ,
                                   0.0,1.0);

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_value("zpl.science_imaging.keep_intermediate",
                                   CPL_TYPE_BOOL,
                                   "Flag to set if intermediate date must be saved, namely pre-processed and overscan pre-processed subtracted data, linbadpix map and non-normalized products (FALSE) "
                                   ,"zpl.science_imaging",
                                   0 );

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_value("zpl.science_imaging.save_interprod",
                                   CPL_TYPE_BOOL,
                                   "Flag to set if the field center table must be saved as intermediate product (FALSE) "
                                   "Note that this parameter must be only applied for the offline pipeline "
                                   ,"zpl.science_imaging",
                                   0 );

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_value("zpl.science_imaging.star_center_iframe",
                                   CPL_TYPE_BOOL,
                                   "Flag to set if only the center coordinates of the iframe from the star center calibration frame "
                                   "should be used as a center coordinates to de-rotate iframe and pframe[dark current] (TRUE) "
                                   ,"zpl.science_imaging",
                                   1 );

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_range("zpl.science_imaging.center_xoffset_cam1",
                                   CPL_TYPE_DOUBLE,
                                   "X-offset from the center of the image for the camera-1 "
                                   ,"zpl.science_imaging",
                                   0.0 ,
                                   -512.0,512.0);

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_range("zpl.science_imaging.center_yoffset_cam1",
                                   CPL_TYPE_DOUBLE,
                                   "Y-offset from the center of the image for the camera-1 "
                                   ,"zpl.science_imaging",
                                   0.0 ,
                                   -512.0,512.0);

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_range("zpl.science_imaging.center_xoffset_cam2",
                                   CPL_TYPE_DOUBLE,
                                   "X-offset from the center of the image for the camera-2 "
                                   ,"zpl.science_imaging",
                                   0.0 ,
                                   -512.0,512.0);

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_range("zpl.science_imaging.center_yoffset_cam2",
                                   CPL_TYPE_DOUBLE,
                                   "Y-offset from the center of the image for the camera-2 "
                                   ,"zpl.science_imaging",
                                   0.0 ,
                                   -512.0,512.0);

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_value("zpl.science_imaging.star_r",
                                   CPL_TYPE_DOUBLE,
                                   "The star radius [arcsecond] used for the Strehl ratio estimate. A negative value "
                                   "disables the estimation. When AO is enabled and 0 (default) is provided 2 arcseconds are used. "
                                   "When AO is disabled and 0 is provided a radius corresponding to 500 PIXEL is used. This option is ignored in absence of a "
                                   "ZPL_FILTER_TABLE frame. "
                                   ,"zpl.science_imaging",
                                   0.0 );

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_value("zpl.science_imaging.bg_r1",
                                   CPL_TYPE_DOUBLE,
                                   "The internal radius [arcsecond] of the background used for the Strehl ratio estimate. "
                                   "When AO is enabled and 0 (default) is provided 2 arcseconds are used. "
                                   "When AO is disabled and 0 is provided a radius corresponding to 500 PIXEL is used. "
                                   "This option is ignored in absence of a ZPL_FILTER_TABLE frame. "
                                   ,"zpl.science_imaging",
                                   0.0 );

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_value("zpl.science_imaging.bg_r2",
                                   CPL_TYPE_DOUBLE,
                                   "The external radius [arcsecond] of the background used for the Strehl ratio estimate. "
                                   "When AO is enabled and 0 (default) is provided 3 arcseconds are used. "
                                   "When AO is disabled and 0 is provided a radius corresponding to all the PIXELS in the image is used. "
                                   "This option is ignored in absence of a ZPL_FILTER_TABLE frame. "
                                   ,"zpl.science_imaging",
                                   0.0 );

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_value("zpl.preproc.outfilename_cam1",
                                   CPL_TYPE_STRING,
                                   "The postfix-  of the intermediate filename of the pre-processed raw data for the CAMERA-1. "
                                   ,"zpl.preproc",
                                   "preproc_cam1.fits" );

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        p = cpl_parameter_new_value("zpl.preproc.outfilename_cam2",
                                   CPL_TYPE_STRING,
                                   "The postfix- of the  intermediate filename of the pre-processed raw data for the CAMERA-2. "
                                   ,"zpl.preproc",
                                   "preproc_cam2.fits" );

        cpl_parameter_disable(p, CPL_PARAMETER_MODE_ENV);
        cpl_parameterlist_append(result, p);
        /* End of code to set up parameters BUT ITS STILL NOT SAFE TO EDIT! FILE IS GENERATED !*/

    return cpl_error_set_where(cpl_func);
}
/*----------------------------------------------------------------------------*/
/**
 @brief  Create and return the standard parameterlist for the recipe
 @return The standard parameterlist or NULL on error
 @note   The returned object must be deallocated using cpl_parameterlist_delete

 */
/*----------------------------------------------------------------------------*/
cpl_parameterlist* sph_zpl_science_imaging_create_paramlist(void)
{
    cpl_parameterlist* self = cpl_parameterlist_new();

    if (sph_zpl_science_imaging_fill_parameterlist(self)) {
        cpl_parameterlist_delete(self);
        self = NULL;
        (void)cpl_error_set_where(cpl_func);
    }

    return self;
}

/*----------------------------------------------------------------------------*/
/**
 @brief    Check the recipe frames, and assign them to the sph_zpl_science_imaging
           structure.
 @param    self     the sph_zpl_science_imaging recipe structure
 @return   error code of the check.

 This checks the frames that were given in the sph_zpl_science_imaging_new function
 as parameters for the correctness and completeness. If the frames needed are
 found they are also assigned to the corresponding structure members.

 The return value is the error code of the check.
 */
/*----------------------------------------------------------------------------*/
sph_error_code  sph_zpl_science_imaging_check_frames( sph_zpl_science_imaging* self )
{
    sph_error_code           rerr            = CPL_ERROR_NONE;
    /* Code to check frames GENERATED DO NOT EDIT */

    cpl_frame* aframe;
    aframe = cpl_frameset_find( self->inframes, SPH_ZPL_TAG_SCIENCE_IMAGING_RAW );
    while ( aframe ) {
        cpl_frame_set_group( aframe, CPL_FRAME_GROUP_RAW );
        aframe = cpl_frameset_find( self->inframes, NULL );
    }
    self->rawframes = sph_utils_extract_frames( self->inframes, SPH_ZPL_TAG_SCIENCE_IMAGING_RAW );
    if ( ! self->rawframes )
    {
        sph_error_raise( SPH_ZPL_SCIENCE_IMAGING_FRAMES_MISSING,
                         __FILE__, __func__, __LINE__ ,
                         SPH_ERROR_INFO,
                         "Could not extract rawframes frames."
                         "Since this is an optional frame, this is ok "
                         "and this message is just informational. If you intended, "
                         "to use them check that they have the %s tag.",
                         SPH_ZPL_TAG_SCIENCE_IMAGING_RAW);
        cpl_error_reset();
    }

    else {

         int numframes = (int)cpl_frameset_get_size( self->rawframes );
         for ( int ii = 0; ii < numframes; ++ii ) {
             cpl_frame* iframe = cpl_frameset_get_position( self->rawframes, ii );
             const char* ifname = cpl_frame_get_filename(iframe);
             cpl_propertylist* pl = cpl_propertylist_load(ifname, 0);
             if (pl == NULL ) {
                 sph_error_raise(cpl_error_get_code(),
                    __FILE__, __func__, __LINE__ ,SPH_ERROR_ERROR,
                 "Could not read keywords from file %s. "
                 "Either the file is not readable or corrupted. ",
                  ifname);
             }
             else {
                 rerr = cpl_frame_set_group( iframe, CPL_FRAME_GROUP_RAW );
                 int haskey, okval;
                 haskey = 0;okval = 0;
                 if ( cpl_propertylist_has(pl,"ESO DRS PC PROD TYPE") )  {
                     haskey = 1;
                     if ( cpl_propertylist_get_type(pl,"ESO DRS PC PROD TYPE") == CPL_TYPE_STRING )  {
                         okval = 1; //Type is string so always ok
                     } 
                     if ( haskey == 0 || okval == 0 ) {
                         sph_error_raise(CPL_ERROR_ILLEGAL_INPUT,
                            __FILE__, __func__, __LINE__ ,SPH_ERROR_ERROR,
                         "Could not read a keyword ESO DRS PC PROD TYPE from file %s. "
                         "that has __type string "
                         "and values between 0.0 and 0.0 "
                         "The recipe requires this. ",
                         ifname);
                     }
                 }
                 cpl_propertylist_delete(pl); pl=NULL;
             }
         }
         numframes -= (int)cpl_frameset_get_size( self->rawframes );
         assert( numframes == 0);
    }

    aframe = cpl_frameset_find( self->inframes, SPH_ZPL_TAG_SCIENCE_IMAGING_PREPROC_RAW );
    while ( aframe ) {
        cpl_frame_set_group( aframe, CPL_FRAME_GROUP_RAW );
        aframe = cpl_frameset_find( self->inframes, NULL );
    }
    self->preproc_frames = sph_utils_extract_frames( self->inframes, SPH_ZPL_TAG_SCIENCE_IMAGING_PREPROC_RAW );
    if ( ! self->preproc_frames )
    {
        sph_error_raise( SPH_ZPL_SCIENCE_IMAGING_FRAMES_MISSING,
                         __FILE__, __func__, __LINE__ ,
                         SPH_ERROR_INFO,
                         "Could not extract preproc_frames frames."
                         "Since this is an optional frame, this is ok "
                         "and this message is just informational. If you intended, "
                         "to use them check that they have the %s tag.",
                         SPH_ZPL_TAG_SCIENCE_IMAGING_PREPROC_RAW);
        cpl_error_reset();
    }

    else {

         int numframes = (int)cpl_frameset_get_size( self->preproc_frames );
         for ( int ii = 0; ii < numframes; ++ii ) {
             cpl_frame* iframe = cpl_frameset_get_position( self->preproc_frames, ii );
             const char* ifname = cpl_frame_get_filename(iframe);
             cpl_propertylist* pl = cpl_propertylist_load(ifname, 0);
             if (pl == NULL ) {
                 sph_error_raise(cpl_error_get_code(),
                    __FILE__, __func__, __LINE__ ,SPH_ERROR_ERROR,
                 "Could not read keywords from file %s. "
                 "Either the file is not readable or corrupted. ",
                  ifname);
             }
             else {
                 rerr = cpl_frame_set_group( iframe, CPL_FRAME_GROUP_RAW );
                 int haskey, okval;
                 haskey = 0;okval = 0;
                 if ( cpl_propertylist_has(pl,"ESO DRS PC PROD TYPE") )  {
                     haskey = 1;
                     if ( cpl_propertylist_get_type(pl,"ESO DRS PC PROD TYPE") == CPL_TYPE_STRING )  {
                         okval = 1; //Type is string so always ok
                     } 
                     if ( haskey == 0 || okval == 0 ) {
                         sph_error_raise(CPL_ERROR_ILLEGAL_INPUT,
                            __FILE__, __func__, __LINE__ ,SPH_ERROR_ERROR,
                         "Could not read a keyword ESO DRS PC PROD TYPE from file %s. "
                         "that has __type string "
                         "and values between 0.0 and 0.0 "
                         "The recipe requires this. ",
                         ifname);
                     }
                 }
                 cpl_propertylist_delete(pl); pl=NULL;
             }
         }
         numframes -= (int)cpl_frameset_get_size( self->preproc_frames );
         assert( numframes == 0);
    }

    aframe = cpl_frameset_find( self->inframes, SPH_ZPL_TAG_SCIENCE_IMAGING_PREPROC_CAM1 );
    while ( aframe ) {
        cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
        aframe = cpl_frameset_find( self->inframes, NULL );
    }
    self->preproc_frames_cam1 = sph_utils_extract_frames( self->inframes, SPH_ZPL_TAG_SCIENCE_IMAGING_PREPROC_CAM1 );
    if ( ! self->preproc_frames_cam1 )
    {
        sph_error_raise( SPH_ZPL_SCIENCE_IMAGING_FRAMES_MISSING,
                         __FILE__, __func__, __LINE__ ,
                         SPH_ERROR_INFO,
                         "Could not extract preproc_frames_cam1 frames."
                         "Since this is an optional frame, this is ok "
                         "and this message is just informational. If you intended, "
                         "to use them check that they have the %s tag.",
                         SPH_ZPL_TAG_SCIENCE_IMAGING_PREPROC_CAM1);
        cpl_error_reset();
    }

    else {

         int numframes = (int)cpl_frameset_get_size( self->preproc_frames_cam1 );
         for ( int ii = 0; ii < numframes; ++ii ) {
         }
         numframes -= (int)cpl_frameset_get_size( self->preproc_frames_cam1 );
         assert( numframes == 0);
    }

    aframe = cpl_frameset_find( self->inframes, SPH_ZPL_TAG_SCIENCE_IMAGING_PREPROC_CAM2 );
    while ( aframe ) {
        cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
        aframe = cpl_frameset_find( self->inframes, NULL );
    }
    self->preproc_frames_cam2 = sph_utils_extract_frames( self->inframes, SPH_ZPL_TAG_SCIENCE_IMAGING_PREPROC_CAM2 );
    if ( ! self->preproc_frames_cam2 )
    {
        sph_error_raise( SPH_ZPL_SCIENCE_IMAGING_FRAMES_MISSING,
                         __FILE__, __func__, __LINE__ ,
                         SPH_ERROR_INFO,
                         "Could not extract preproc_frames_cam2 frames."
                         "Since this is an optional frame, this is ok "
                         "and this message is just informational. If you intended, "
                         "to use them check that they have the %s tag.",
                         SPH_ZPL_TAG_SCIENCE_IMAGING_PREPROC_CAM2);
        cpl_error_reset();
    }

    else {

         int numframes = (int)cpl_frameset_get_size( self->preproc_frames_cam2 );
         for ( int ii = 0; ii < numframes; ++ii ) {
         }
         numframes -= (int)cpl_frameset_get_size( self->preproc_frames_cam2 );
         assert( numframes == 0);
    }

    aframe = cpl_frameset_find( self->inframes, SPH_ZPL_TAG_BIAS_IMAGING_CALIB );
    while ( aframe ) {
        cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
        aframe = cpl_frameset_find( self->inframes, NULL );
    }
    self->master_bias_frame = sph_utils_extract_frame( self->inframes, SPH_ZPL_TAG_BIAS_IMAGING_CALIB );
    if ( ! self->master_bias_frame )
    {
        sph_error_raise( SPH_ZPL_SCIENCE_IMAGING_FRAMES_MISSING,
                         __FILE__, __func__, __LINE__ ,
                         SPH_ERROR_INFO,
                         "Could not extract master_bias_frame frames."
                         "Since this is an optional frame, this is ok "
                         "and this message is just informational. If you intended, "
                         "to use them check that they have the %s tag.",
                         SPH_ZPL_TAG_BIAS_IMAGING_CALIB);
        cpl_error_reset();
    }

    else {

         rerr = cpl_frame_set_group( self->master_bias_frame, CPL_FRAME_GROUP_CALIB );
    }

    aframe = cpl_frameset_find( self->inframes, SPH_ZPL_TAG_BIAS_IMAGING_CALIB_CAM1 );
    while ( aframe ) {
        cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
        aframe = cpl_frameset_find( self->inframes, NULL );
    }
    self->master_bias_frame_cam1 = sph_utils_extract_frame( self->inframes, SPH_ZPL_TAG_BIAS_IMAGING_CALIB_CAM1 );
    if ( ! self->master_bias_frame_cam1 )
    {
        sph_error_raise( SPH_ZPL_SCIENCE_IMAGING_FRAMES_MISSING,
                         __FILE__, __func__, __LINE__ ,
                         SPH_ERROR_INFO,
                         "Could not extract master_bias_frame_cam1 frames."
                         "Since this is an optional frame, this is ok "
                         "and this message is just informational. If you intended, "
                         "to use them check that they have the %s tag.",
                         SPH_ZPL_TAG_BIAS_IMAGING_CALIB_CAM1);
        cpl_error_reset();
    }

    else {

         rerr = cpl_frame_set_group( self->master_bias_frame_cam1, CPL_FRAME_GROUP_CALIB );
    }

    aframe = cpl_frameset_find( self->inframes, SPH_ZPL_TAG_BIAS_IMAGING_CALIB_CAM2 );
    while ( aframe ) {
        cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
        aframe = cpl_frameset_find( self->inframes, NULL );
    }
    self->master_bias_frame_cam2 = sph_utils_extract_frame( self->inframes, SPH_ZPL_TAG_BIAS_IMAGING_CALIB_CAM2 );
    if ( ! self->master_bias_frame_cam2 )
    {
        sph_error_raise( SPH_ZPL_SCIENCE_IMAGING_FRAMES_MISSING,
                         __FILE__, __func__, __LINE__ ,
                         SPH_ERROR_INFO,
                         "Could not extract master_bias_frame_cam2 frames."
                         "Since this is an optional frame, this is ok "
                         "and this message is just informational. If you intended, "
                         "to use them check that they have the %s tag.",
                         SPH_ZPL_TAG_BIAS_IMAGING_CALIB_CAM2);
        cpl_error_reset();
    }

    else {

         rerr = cpl_frame_set_group( self->master_bias_frame_cam2, CPL_FRAME_GROUP_CALIB );
    }

    aframe = cpl_frameset_find( self->inframes, SPH_ZPL_TAG_DARK_IMAGING_CALIB );
    while ( aframe ) {
        cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
        aframe = cpl_frameset_find( self->inframes, NULL );
    }
    self->master_dark_frame = sph_utils_extract_frame( self->inframes, SPH_ZPL_TAG_DARK_IMAGING_CALIB );
    if ( ! self->master_dark_frame )
    {
        sph_error_raise( SPH_ZPL_SCIENCE_IMAGING_FRAMES_MISSING,
                         __FILE__, __func__, __LINE__ ,
                         SPH_ERROR_INFO,
                         "Could not extract master_dark_frame frames."
                         "Since this is an optional frame, this is ok "
                         "and this message is just informational. If you intended, "
                         "to use them check that they have the %s tag.",
                         SPH_ZPL_TAG_DARK_IMAGING_CALIB);
        cpl_error_reset();
    }

    else {

         rerr = cpl_frame_set_group( self->master_dark_frame, CPL_FRAME_GROUP_CALIB );
    }

    aframe = cpl_frameset_find( self->inframes, SPH_ZPL_TAG_DARK_IMAGING_CALIB_CAM1 );
    while ( aframe ) {
        cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
        aframe = cpl_frameset_find( self->inframes, NULL );
    }
    self->master_dark_frame_cam1 = sph_utils_extract_frame( self->inframes, SPH_ZPL_TAG_DARK_IMAGING_CALIB_CAM1 );
    if ( ! self->master_dark_frame_cam1 )
    {
        sph_error_raise( SPH_ZPL_SCIENCE_IMAGING_FRAMES_MISSING,
                         __FILE__, __func__, __LINE__ ,
                         SPH_ERROR_INFO,
                         "Could not extract master_dark_frame_cam1 frames."
                         "Since this is an optional frame, this is ok "
                         "and this message is just informational. If you intended, "
                         "to use them check that they have the %s tag.",
                         SPH_ZPL_TAG_DARK_IMAGING_CALIB_CAM1);
        cpl_error_reset();
    }

    else {

         rerr = cpl_frame_set_group( self->master_dark_frame_cam1, CPL_FRAME_GROUP_CALIB );
    }

    aframe = cpl_frameset_find( self->inframes, SPH_ZPL_TAG_DARK_IMAGING_CALIB_CAM2 );
    while ( aframe ) {
        cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
        aframe = cpl_frameset_find( self->inframes, NULL );
    }
    self->master_dark_frame_cam2 = sph_utils_extract_frame( self->inframes, SPH_ZPL_TAG_DARK_IMAGING_CALIB_CAM2 );
    if ( ! self->master_dark_frame_cam2 )
    {
        sph_error_raise( SPH_ZPL_SCIENCE_IMAGING_FRAMES_MISSING,
                         __FILE__, __func__, __LINE__ ,
                         SPH_ERROR_INFO,
                         "Could not extract master_dark_frame_cam2 frames."
                         "Since this is an optional frame, this is ok "
                         "and this message is just informational. If you intended, "
                         "to use them check that they have the %s tag.",
                         SPH_ZPL_TAG_DARK_IMAGING_CALIB_CAM2);
        cpl_error_reset();
    }

    else {

         rerr = cpl_frame_set_group( self->master_dark_frame_cam2, CPL_FRAME_GROUP_CALIB );
    }

    aframe = cpl_frameset_find( self->inframes, SPH_ZPL_TAG_IFF_IMAGING_CALIB );
    while ( aframe ) {
        cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
        aframe = cpl_frameset_find( self->inframes, NULL );
    }
    self->intensity_flat_frame = sph_utils_extract_frame( self->inframes, SPH_ZPL_TAG_IFF_IMAGING_CALIB );
    if ( ! self->intensity_flat_frame )
    {
        sph_error_raise( SPH_ZPL_SCIENCE_IMAGING_FRAMES_MISSING,
                         __FILE__, __func__, __LINE__ ,
                         SPH_ERROR_INFO,
                         "Could not extract intensity_flat_frame frames."
                         "Since this is an optional frame, this is ok "
                         "and this message is just informational. If you intended, "
                         "to use them check that they have the %s tag.",
                         SPH_ZPL_TAG_IFF_IMAGING_CALIB);
        cpl_error_reset();
    }

    else {

         rerr = cpl_frame_set_group( self->intensity_flat_frame, CPL_FRAME_GROUP_CALIB );
    }

    aframe = cpl_frameset_find( self->inframes, SPH_ZPL_TAG_IFF_IMAGING_CALIB_CAM1 );
    while ( aframe ) {
        cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
        aframe = cpl_frameset_find( self->inframes, NULL );
    }
    self->intensity_flat_frame_cam1 = sph_utils_extract_frame( self->inframes, SPH_ZPL_TAG_IFF_IMAGING_CALIB_CAM1 );
    if ( ! self->intensity_flat_frame_cam1 )
    {
        sph_error_raise( SPH_ZPL_SCIENCE_IMAGING_FRAMES_MISSING,
                         __FILE__, __func__, __LINE__ ,
                         SPH_ERROR_INFO,
                         "Could not extract intensity_flat_frame_cam1 frames."
                         "Since this is an optional frame, this is ok "
                         "and this message is just informational. If you intended, "
                         "to use them check that they have the %s tag.",
                         SPH_ZPL_TAG_IFF_IMAGING_CALIB_CAM1);
        cpl_error_reset();
    }

    else {

         rerr = cpl_frame_set_group( self->intensity_flat_frame_cam1, CPL_FRAME_GROUP_CALIB );
    }

    aframe = cpl_frameset_find( self->inframes, SPH_ZPL_TAG_IFF_IMAGING_CALIB_CAM2 );
    while ( aframe ) {
        cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
        aframe = cpl_frameset_find( self->inframes, NULL );
    }
    self->intensity_flat_frame_cam2 = sph_utils_extract_frame( self->inframes, SPH_ZPL_TAG_IFF_IMAGING_CALIB_CAM2 );
    if ( ! self->intensity_flat_frame_cam2 )
    {
        sph_error_raise( SPH_ZPL_SCIENCE_IMAGING_FRAMES_MISSING,
                         __FILE__, __func__, __LINE__ ,
                         SPH_ERROR_INFO,
                         "Could not extract intensity_flat_frame_cam2 frames."
                         "Since this is an optional frame, this is ok "
                         "and this message is just informational. If you intended, "
                         "to use them check that they have the %s tag.",
                         SPH_ZPL_TAG_IFF_IMAGING_CALIB_CAM2);
        cpl_error_reset();
    }

    else {

         rerr = cpl_frame_set_group( self->intensity_flat_frame_cam2, CPL_FRAME_GROUP_CALIB );
    }

    aframe = cpl_frameset_find( self->inframes, SPH_ZPL_TAG_STAR_CENTER_IMG_CALIB_CAM1 );
    while ( aframe ) {
        cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
        aframe = cpl_frameset_find( self->inframes, NULL );
    }
    self->star_center_frame_cam1 = sph_utils_extract_frame( self->inframes, SPH_ZPL_TAG_STAR_CENTER_IMG_CALIB_CAM1 );
    if ( ! self->star_center_frame_cam1 )
    {
        sph_error_raise( SPH_ZPL_SCIENCE_IMAGING_FRAMES_MISSING,
                         __FILE__, __func__, __LINE__ ,
                         SPH_ERROR_INFO,
                         "Could not extract star_center_frame_cam1 frames."
                         "Since this is an optional frame, this is ok "
                         "and this message is just informational. If you intended, "
                         "to use them check that they have the %s tag.",
                         SPH_ZPL_TAG_STAR_CENTER_IMG_CALIB_CAM1);
        cpl_error_reset();
    }

    else {

         rerr = cpl_frame_set_group( self->star_center_frame_cam1, CPL_FRAME_GROUP_CALIB );
    }

    aframe = cpl_frameset_find( self->inframes, SPH_ZPL_TAG_STAR_CENTER_IMG_CALIB_CAM2 );
    while ( aframe ) {
        cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
        aframe = cpl_frameset_find( self->inframes, NULL );
    }
    self->star_center_frame_cam2 = sph_utils_extract_frame( self->inframes, SPH_ZPL_TAG_STAR_CENTER_IMG_CALIB_CAM2 );
    if ( ! self->star_center_frame_cam2 )
    {
        sph_error_raise( SPH_ZPL_SCIENCE_IMAGING_FRAMES_MISSING,
                         __FILE__, __func__, __LINE__ ,
                         SPH_ERROR_INFO,
                         "Could not extract star_center_frame_cam2 frames."
                         "Since this is an optional frame, this is ok "
                         "and this message is just informational. If you intended, "
                         "to use them check that they have the %s tag.",
                         SPH_ZPL_TAG_STAR_CENTER_IMG_CALIB_CAM2);
        cpl_error_reset();
    }

    else {

         rerr = cpl_frame_set_group( self->star_center_frame_cam2, CPL_FRAME_GROUP_CALIB );
    }

    aframe = cpl_frameset_find( self->inframes, SPH_ZPL_TAG_STAR_CENTER_IMG_CALIB );
    while ( aframe ) {
        cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
        aframe = cpl_frameset_find( self->inframes, NULL );
    }
    self->star_center_frame = sph_utils_extract_frame( self->inframes, SPH_ZPL_TAG_STAR_CENTER_IMG_CALIB );
    if ( ! self->star_center_frame )
    {
        sph_error_raise( SPH_ZPL_SCIENCE_IMAGING_FRAMES_MISSING,
                         __FILE__, __func__, __LINE__ ,
                         SPH_ERROR_INFO,
                         "Could not extract star_center_frame frames."
                         "Since this is an optional frame, this is ok "
                         "and this message is just informational. If you intended, "
                         "to use them check that they have the %s tag.",
                         SPH_ZPL_TAG_STAR_CENTER_IMG_CALIB);
        cpl_error_reset();
    }

    else {

         rerr = cpl_frame_set_group( self->star_center_frame, CPL_FRAME_GROUP_CALIB );
    }

    aframe = cpl_frameset_find( self->inframes, SPH_ZPL_TAG_FIELD_CENTER_CALIB );
    while ( aframe ) {
        cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
        aframe = cpl_frameset_find( self->inframes, NULL );
    }
    self->fctable_frames = sph_utils_extract_frames( self->inframes, SPH_ZPL_TAG_FIELD_CENTER_CALIB );
    if ( ! self->fctable_frames )
    {
        sph_error_raise( SPH_ZPL_SCIENCE_IMAGING_FRAMES_MISSING,
                         __FILE__, __func__, __LINE__ ,
                         SPH_ERROR_INFO,
                         "Could not extract fctable_frames frames."
                         "Since this is an optional frame, this is ok "
                         "and this message is just informational. If you intended, "
                         "to use them check that they have the %s tag.",
                         SPH_ZPL_TAG_FIELD_CENTER_CALIB);
        cpl_error_reset();
    }

    else {

         int numframes = (int)cpl_frameset_get_size( self->fctable_frames );
         for ( int ii = 0; ii < numframes; ++ii ) {
         }
         numframes -= (int)cpl_frameset_get_size( self->fctable_frames );
         assert( numframes == 0);
    }

    aframe = cpl_frameset_find( self->inframes, SPH_ZPL_TAG_FILTER_TABLE_CALIB );
    while ( aframe ) {
        cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
        aframe = cpl_frameset_find( self->inframes, NULL );
    }
    self->filter_frame = sph_utils_extract_frame( self->inframes, SPH_ZPL_TAG_FILTER_TABLE_CALIB );
    if ( ! self->filter_frame )
    {
        sph_error_raise( SPH_ZPL_SCIENCE_IMAGING_FRAMES_MISSING,
                         __FILE__, __func__, __LINE__ ,
                         SPH_ERROR_INFO,
                         "Could not extract filter_frame frames."
                         "Since this is an optional frame, this is ok "
                         "and this message is just informational. If you intended, "
                         "to use them check that they have the %s tag.",
                         SPH_ZPL_TAG_FILTER_TABLE_CALIB);
        cpl_error_reset();
    }

    else {

         rerr = cpl_frame_set_group( self->filter_frame, CPL_FRAME_GROUP_CALIB );
    }

    aframe = cpl_frameset_find( self->inframes, SPH_ZPL_TAG_PHOT_TABLE_CALIB );
    while ( aframe ) {
        cpl_frame_set_group( aframe, CPL_FRAME_GROUP_CALIB );
        aframe = cpl_frameset_find( self->inframes, NULL );
    }
    self->star_frame = sph_utils_extract_frame( self->inframes, SPH_ZPL_TAG_PHOT_TABLE_CALIB );
    if ( ! self->star_frame )
    {
        sph_error_raise( SPH_ZPL_SCIENCE_IMAGING_FRAMES_MISSING,
                         __FILE__, __func__, __LINE__ ,
                         SPH_ERROR_INFO,
                         "Could not extract star_frame frames."
                         "Since this is an optional frame, this is ok "
                         "and this message is just informational. If you intended, "
                         "to use them check that they have the %s tag.",
                         SPH_ZPL_TAG_PHOT_TABLE_CALIB);
        cpl_error_reset();
    }

    else {

         rerr = cpl_frame_set_group( self->star_frame, CPL_FRAME_GROUP_CALIB );
    }

    /* End of code to check frames BUT ITS STILL NOT SAFE TO EDIT! FILE IS GENERATED !*/
    self->current_raw_frameset = sph_utils_extract_frames_group( self->inframes, CPL_FRAME_GROUP_RAW );

    return rerr;
}

/*----------------------------------------------------------------------------*/
/**
 @brief    Check the recipe parameters, and assign them to the sph_zpl_science_imaging
           structure.
 @param    self     the sph_zpl_science_imaging recipe structure
 @return   error code of the check.

 This checks the parameters that were given in the sph_zpl_science_imaging_new function
 as parameters for the correctness and completeness. If the parameters needed are
 found they are also assigned to the corresponding structure members.

 The return value is the error code of the check.
 */
/*----------------------------------------------------------------------------*/
sph_error_code sph_zpl_science_imaging_check_params( sph_zpl_science_imaging* self ) {
    sph_error_code                 rerr               = CPL_ERROR_NONE;
    const cpl_parameter*           param              = NULL;

    if ( self->framecomb_parameterlist != NULL ) {
        cpl_parameterlist_delete( self->framecomb_parameterlist );
        self->framecomb_parameterlist = NULL;
    }
    self->framecomb_parameterlist = cpl_parameterlist_new();
    /* Code to check parameters GENERATED DO NOT EDIT */

    param = cpl_parameterlist_find_const( self->inparams,
                                          "zpl.science_imaging.outfilename");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "zpl.science_imaging.outfilename");
    }

    self->science_imaging_outfilename = cpl_parameter_get_string(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    param = cpl_parameterlist_find_const( self->inparams,
                                          "zpl.science_imaging.outfilename_cam1");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "zpl.science_imaging.outfilename_cam1");
    }

    self->science_imaging_outfilename_cam1 = cpl_parameter_get_string(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    param = cpl_parameterlist_find_const( self->inparams,
                                          "zpl.science_imaging.outfilename_cam2");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "zpl.science_imaging.outfilename_cam2");
    }

    self->science_imaging_outfilename_cam2 = cpl_parameter_get_string(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    param = cpl_parameterlist_find_const( self->inparams,
                                          "zpl.science_imaging.subtract_overscan");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "zpl.science_imaging.subtract_overscan");
    }

    self->subtract_overscan = cpl_parameter_get_bool(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    param = cpl_parameterlist_find_const( self->inparams,
                                          "zpl.science_imaging.coll_alg");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "zpl.science_imaging.coll_alg");
    }

    self->coll_alg = cpl_parameter_get_int(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    param = cpl_parameterlist_find_const( self->inparams,
                                          "zpl.science_imaging.filter_radius");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "zpl.science_imaging.filter_radius");
    }

    self->filter_radius = cpl_parameter_get_double(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    param = cpl_parameterlist_find_const( self->inparams,
                                          "zpl.science_imaging.keep_intermediate");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "zpl.science_imaging.keep_intermediate");
    }

    self->keep_intermediate = cpl_parameter_get_bool(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    param = cpl_parameterlist_find_const( self->inparams,
                                          "zpl.science_imaging.save_interprod");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "zpl.science_imaging.save_interprod");
    }

    self->save_interprod = cpl_parameter_get_bool(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    param = cpl_parameterlist_find_const( self->inparams,
                                          "zpl.science_imaging.star_center_iframe");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "zpl.science_imaging.star_center_iframe");
    }

    self->star_center_iframe = cpl_parameter_get_bool(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    param = cpl_parameterlist_find_const( self->inparams,
                                          "zpl.science_imaging.center_xoffset_cam1");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "zpl.science_imaging.center_xoffset_cam1");
    }

    self->center_xoffset_cam1 = cpl_parameter_get_double(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    param = cpl_parameterlist_find_const( self->inparams,
                                          "zpl.science_imaging.center_yoffset_cam1");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "zpl.science_imaging.center_yoffset_cam1");
    }

    self->center_yoffset_cam1 = cpl_parameter_get_double(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    param = cpl_parameterlist_find_const( self->inparams,
                                          "zpl.science_imaging.center_xoffset_cam2");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "zpl.science_imaging.center_xoffset_cam2");
    }

    self->center_xoffset_cam2 = cpl_parameter_get_double(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    param = cpl_parameterlist_find_const( self->inparams,
                                          "zpl.science_imaging.center_yoffset_cam2");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "zpl.science_imaging.center_yoffset_cam2");
    }

    self->center_yoffset_cam2 = cpl_parameter_get_double(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    param = cpl_parameterlist_find_const( self->inparams,
                                          "zpl.science_imaging.star_r");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "zpl.science_imaging.star_r");
    }

    self->star_r = cpl_parameter_get_double(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    param = cpl_parameterlist_find_const( self->inparams,
                                          "zpl.science_imaging.bg_r1");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "zpl.science_imaging.bg_r1");
    }

    self->bg_r1 = cpl_parameter_get_double(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    param = cpl_parameterlist_find_const( self->inparams,
                                          "zpl.science_imaging.bg_r2");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "zpl.science_imaging.bg_r2");
    }

    self->bg_r2 = cpl_parameter_get_double(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    param = cpl_parameterlist_find_const( self->inparams,
                                          "zpl.preproc.outfilename_cam1");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "zpl.preproc.outfilename_cam1");
    }

    self->outfilename_cam1 = cpl_parameter_get_string(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    param = cpl_parameterlist_find_const( self->inparams,
                                          "zpl.preproc.outfilename_cam2");
    if (param == NULL) {
        return cpl_error_set_message(cpl_func, CPL_ERROR_UNSUPPORTED_MODE,
                                     "Recipe parameter missing: "
                                     "zpl.preproc.outfilename_cam2");
    }

    self->outfilename_cam2 = cpl_parameter_get_string(param);
    if (cpl_error_get_code()) {
        return cpl_error_set_where(cpl_func);
    }

    /* End of code to check parameters BUT ITS STILL NOT SAFE TO EDIT! FILE IS GENERATED !*/

    return rerr;
}
/*----------------------------------------------------------------------------*/
/**
 @brief    Create a new sph_zpl_science_imaging structure.

 @param    frameset     the input recipe frames
 @param    parlist      the input recipe parameters

 @return   pointer to newly created structure or NULL in case of error

 This creates a new sph_zpl_science_imaging_structure and fills the inparams and
 inframes fields with the pointers pf frameset and parlist.
 The return value is the error code of the check.
 */
/*----------------------------------------------------------------------------*/
sph_zpl_science_imaging* sph_zpl_science_imaging_new( cpl_frameset * frameset,
                                              cpl_parameterlist * parlist )
{
    sph_zpl_science_imaging*    result      = NULL;
    int                     rerr        = CPL_ERROR_NONE;

    sph_init_erex();
    if ( frameset == NULL || parlist == NULL ) {
        sph_error_raise( CPL_ERROR_NULL_INPUT, __FILE__,
                         __func__, __LINE__,
                         SPH_ERROR_ERROR,
                         "Null input pointer.");
        return NULL;
    }

    result = cpl_calloc( 1, sizeof(sph_zpl_science_imaging) );

    if ( result == NULL ) {
        sph_error_raise( SPH_ZPL_SCIENCE_IMAGING_GENERAL, __FILE__, __func__,
                         __LINE__, SPH_ERROR_ERROR,
                         "Could not allocate the structure.");
        return result;
    }

    result->inframes = frameset;
    result->inparams = parlist;

    rerr = sph_zpl_science_imaging_check_frames( result );
    if ( rerr == CPL_ERROR_NONE) rerr = sph_zpl_science_imaging_check_params( result );

    if ( rerr != CPL_ERROR_NONE ) {
        if ( result ) {
            sph_zpl_science_imaging_delete( result );
        }
        result = NULL;
    }

    return result;
}

/*----------------------------------------------------------------------------*/
/**
 @brief    Delete the sph_zpl_science_imaging structure.

 @param    self         the structure tp delete

 @return   error code of the operation

 This creates a new sph_zpl_science_imaging_structure and fills the inparams and
 inframes fields with the pointers pf frameset and parlist.
 The return value is the error code of the check.
 */
/*----------------------------------------------------------------------------*/
sph_error_code sph_zpl_science_imaging_delete( sph_zpl_science_imaging* self )
{
    sph_error_code          rerr            = CPL_ERROR_NONE;

    if ( self == NULL ) {
        sph_error_raise( CPL_ERROR_NULL_INPUT, __FILE__,
                         __func__, __LINE__,
                         SPH_ERROR_ERROR,
                         "Null input pointer.");
        return rerr;
    }

    if ( self->framecomb_parameterlist != NULL ) {
        cpl_parameterlist_delete( self->framecomb_parameterlist );
        self->framecomb_parameterlist = NULL;
    }

    /* Code to delete recipe pointers GENERATED DO NOT EDIT */

    if ( self->rawframes != NULL ) {
        cpl_frameset_delete( self->rawframes );
        self->rawframes = NULL;
    }
    if ( self->preproc_frames != NULL ) {
        cpl_frameset_delete( self->preproc_frames );
        self->preproc_frames = NULL;
    }
    if ( self->preproc_frames_cam1 != NULL ) {
        cpl_frameset_delete( self->preproc_frames_cam1 );
        self->preproc_frames_cam1 = NULL;
    }
    if ( self->preproc_frames_cam2 != NULL ) {
        cpl_frameset_delete( self->preproc_frames_cam2 );
        self->preproc_frames_cam2 = NULL;
    }
    if ( self->master_bias_frame != NULL ) {
        cpl_frame_delete( self->master_bias_frame );
        self->master_bias_frame = NULL;
    }
    if ( self->master_bias_frame_cam1 != NULL ) {
        cpl_frame_delete( self->master_bias_frame_cam1 );
        self->master_bias_frame_cam1 = NULL;
    }
    if ( self->master_bias_frame_cam2 != NULL ) {
        cpl_frame_delete( self->master_bias_frame_cam2 );
        self->master_bias_frame_cam2 = NULL;
    }
    if ( self->master_dark_frame != NULL ) {
        cpl_frame_delete( self->master_dark_frame );
        self->master_dark_frame = NULL;
    }
    if ( self->master_dark_frame_cam1 != NULL ) {
        cpl_frame_delete( self->master_dark_frame_cam1 );
        self->master_dark_frame_cam1 = NULL;
    }
    if ( self->master_dark_frame_cam2 != NULL ) {
        cpl_frame_delete( self->master_dark_frame_cam2 );
        self->master_dark_frame_cam2 = NULL;
    }
    if ( self->intensity_flat_frame != NULL ) {
        cpl_frame_delete( self->intensity_flat_frame );
        self->intensity_flat_frame = NULL;
    }
    if ( self->intensity_flat_frame_cam1 != NULL ) {
        cpl_frame_delete( self->intensity_flat_frame_cam1 );
        self->intensity_flat_frame_cam1 = NULL;
    }
    if ( self->intensity_flat_frame_cam2 != NULL ) {
        cpl_frame_delete( self->intensity_flat_frame_cam2 );
        self->intensity_flat_frame_cam2 = NULL;
    }
    if ( self->star_center_frame_cam1 != NULL ) {
        cpl_frame_delete( self->star_center_frame_cam1 );
        self->star_center_frame_cam1 = NULL;
    }
    if ( self->star_center_frame_cam2 != NULL ) {
        cpl_frame_delete( self->star_center_frame_cam2 );
        self->star_center_frame_cam2 = NULL;
    }
    if ( self->star_center_frame != NULL ) {
        cpl_frame_delete( self->star_center_frame );
        self->star_center_frame = NULL;
    }
    if ( self->fctable_frames != NULL ) {
        cpl_frameset_delete( self->fctable_frames );
        self->fctable_frames = NULL;
    }
    if ( self->filter_frame != NULL ) {
        cpl_frame_delete( self->filter_frame );
        self->filter_frame = NULL;
    }
    if ( self->star_frame != NULL ) {
        cpl_frame_delete( self->star_frame );
        self->star_frame = NULL;
    }
 
    sph_double_image_delete(self->science_imaging_di);
    sph_double_image_delete(self->science_imaging_di_cam1);
    sph_double_image_delete(self->science_imaging_di_cam2);
    /* End of code to delete pointers BUT ITS STILL NOT SAFE TO EDIT! FILE IS GENERATED !*/
    if ( self->current_raw_frameset ) {
        cpl_frameset_delete(self->current_raw_frameset);
        self->current_raw_frameset = NULL;
    }
    sph_polygon_free_all();
    cpl_free(    self);
    return rerr;

}


/**@}*/
