/***********************************************************************************************/
/******** DANGER !! DANGER !! DANGER !! DO NOT EDIT FILE -- IT WAS GENERATED AUTOMATICALLY !!! */
/***********************************************************************************************/

/* $Id: $
 * This file is part of the SPHERE Pipeline
 * Copyright (C) 2007-2010 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: $
 * $Date: $
 * $Revision: $
 * $Name: $
 */

#include "sph_error.h"
#include "sph_cube.h"
#include "sph_pixel_description_table.h"
#include "sph_ldt.h"
#include "sph_master_frame.h"
#include "sph_double_image.h"
#include "sph_triple_image.h"
#include "sph_quad_image.h"
#include "sph_zpl_exposure.h"
#include "sph_zpl_exposure_imaging.h"
#include "sph_pixel_polyfit_table.h"
#include "sph_ird_instrument_model.h"
#include "sph_fctable.h"
#include "sph_zpl_science_pol_product.h"
#include <cpl.h>
#include <config.h>

#ifndef SPH_ZPL_SCIENCE_IMAGING_H_

#define SPH_ZPL_SCIENCE_IMAGING_H_
#define SPH_ZPL_SCIENCE_IMAGING_VERSION SPHERE_REC_VERSIONS

/*-------------------------------------------------------------------------------
 * The Structure Definition
 * 
 * This structure contains the members of the sph_zpl_science_imaging that are 
 * needed by the various methods.
 * 
 * ------------------------------------------------------------------------------
 */

typedef struct _sph_zpl_science_imaging_ {
    cpl_frameset*                   inframes                              ; /* The recipe input frames */

    cpl_frameset*                   current_raw_frameset                  ; /* The frameset for one product */

    cpl_parameterlist*        inparams                              ; /* The recipe input parameters */

    cpl_parameterlist*        framecomb_parameterlist               ; /* The recipe input parameters */

    const char*                     science_imaging_outfilename           ; /* The parameter of zpl.science_imaging.outfilename */

    const char*                     science_imaging_outfilename_cam1      ; /* The parameter of zpl.science_imaging.outfilename_cam1 */

    const char*                     science_imaging_outfilename_cam2      ; /* The parameter of zpl.science_imaging.outfilename_cam2 */

    short                           subtract_overscan                     ; /* The parameter of zpl.science_imaging.subtract_overscan */

    int                             coll_alg                              ; /* The parameter of zpl.science_imaging.coll_alg */

    double                          filter_radius                         ; /* The parameter of zpl.science_imaging.filter_radius */

    short                           keep_intermediate                     ; /* The parameter of zpl.science_imaging.keep_intermediate */

    short                           save_interprod                        ; /* The parameter of zpl.science_imaging.save_interprod */

    short                           star_center_iframe                    ; /* The parameter of zpl.science_imaging.star_center_iframe */

    double                          center_xoffset_cam1                   ; /* The parameter of zpl.science_imaging.center_xoffset_cam1 */

    double                          center_yoffset_cam1                   ; /* The parameter of zpl.science_imaging.center_yoffset_cam1 */

    double                          center_xoffset_cam2                   ; /* The parameter of zpl.science_imaging.center_xoffset_cam2 */

    double                          center_yoffset_cam2                   ; /* The parameter of zpl.science_imaging.center_yoffset_cam2 */

    double                          star_r                                ; /* The parameter of zpl.science_imaging.star_r */

    double                          bg_r1                                 ; /* The parameter of zpl.science_imaging.bg_r1 */

    double                          bg_r2                                 ; /* The parameter of zpl.science_imaging.bg_r2 */

    const char*                     outfilename_cam1                      ; /* The parameter of zpl.preproc.outfilename_cam1 */

    const char*                     outfilename_cam2                      ; /* The parameter of zpl.preproc.outfilename_cam2 */

    cpl_frameset*                   rawframes                             ; /* The ZPL_SCIENCE_IMAGING_RAW frames */

    cpl_frameset*                   preproc_frames                        ; /* The ZPL_SCIENCE_IMAGING_PREPROC_RAW frames */

    cpl_frameset*                   preproc_frames_cam1                   ; /* The ZPL_SCIENCE_IMAGING_PREPROC_CAM1 frames */

    cpl_frameset*                   preproc_frames_cam2                   ; /* The ZPL_SCIENCE_IMAGING_PREPROC_CAM2 frames */

    cpl_frame*                      master_bias_frame                     ; /* The ZPL_MASTER_BIAS_IMAGING frames */

    cpl_frame*                      master_bias_frame_cam1                ; /* The ZPL_MASTER_BIAS_IMAGING_CAM1 frames */

    cpl_frame*                      master_bias_frame_cam2                ; /* The ZPL_MASTER_BIAS_IMAGING_CAM2 frames */

    cpl_frame*                      master_dark_frame                     ; /* The ZPL_MASTER_DARK_IMAGING frames */

    cpl_frame*                      master_dark_frame_cam1                ; /* The ZPL_MASTER_DARK_IMAGING_CAM1 frames */

    cpl_frame*                      master_dark_frame_cam2                ; /* The ZPL_MASTER_DARK_IMAGING_CAM2 frames */

    cpl_frame*                      intensity_flat_frame                  ; /* The ZPL_INT_FLAT_FIELD_IMAGING frames */

    cpl_frame*                      intensity_flat_frame_cam1             ; /* The ZPL_INT_FLAT_FIELD_IMAGING_CAM1 frames */

    cpl_frame*                      intensity_flat_frame_cam2             ; /* The ZPL_INT_FLAT_FIELD_IMAGING_CAM2 frames */

    cpl_frame*                      star_center_frame_cam1                ; /* The ZPL_STAR_CENTER_IMG_CAM1 frames */

    cpl_frame*                      star_center_frame_cam2                ; /* The ZPL_STAR_CENTER_IMG_CAM2 frames */

    cpl_frame*                      star_center_frame                     ; /* The ZPL_STAR_CENTER_IMG frames */

    cpl_frameset*                   fctable_frames                        ; /* The ZPL_FIELD_CENTER_TABLE frames */

    cpl_frame*                      filter_frame                          ; /* The ZPL_FILTER_TABLE frames */

    cpl_frame*                      star_frame                            ; /* The ZPL_PHOT_STAR_TABLE frames */

    sph_double_image*               science_imaging_di                    ; /* The ZPL_SCIENCE_IMAGING_REDUCED product */

    sph_double_image*               science_imaging_di_cam1               ; /* The ZPL_SCIENCE_IMAGING_REDUCED_CAM1 product */

    sph_double_image*               science_imaging_di_cam2               ; /* The ZPL_SCIENCE_IMAGING_REDUCED_CAM2 product */

} sph_zpl_science_imaging;

/*-------------------------------------------------------------------------------
 * Error codes
 * 
 * Below the various error codes for this module are declared.
 * ------------------------------------------------------------------------------
 */

int sph_zpl_science_imaging_create_test(cpl_plugin *);


/*-------------------------------------------------------------------------------
 * The methods
 * 
 * These are the methods for sph_zpl_science_imaging.
 * 
 * ------------------------------------------------------------------------------
 */

sph_zpl_science_imaging* sph_zpl_science_imaging_new( cpl_frameset * frameset, 
                                              cpl_parameterlist * parlist);

sph_error_code  sph_zpl_science_imaging_check_frames( sph_zpl_science_imaging* self );

sph_error_code sph_zpl_science_imaging_check_params( sph_zpl_science_imaging* parlist );

cpl_error_code sph_zpl_science_imaging_run( sph_zpl_science_imaging* self );

sph_error_code sph_zpl_science_imaging_delete( sph_zpl_science_imaging* self );
cpl_parameterlist*  sph_zpl_science_imaging_create_paramlist(void) CPL_ATTR_ALLOC;

/* Extra function declarations that are defined in sph_zpl_science_imaging.c */


/* End of extra function declarations that are defined in sph_zpl_science_imaging_run.c */



#endif /*SPH_ZPL_SCIENCE_IMAGING_H_*/
