/* $Id: $
 * This file is part of the SPHERE Pipeline
 * Copyright (C) 2007-2010 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: $
 * $Date: $
 * $Revision: $
 * $Name: $
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

/*-----------------------------------------------------------------------------
 Includes
 -----------------------------------------------------------------------------*/
#include <cpl.h>
#include "sph_error.h"
#ifndef SPH_BACKGROUND_H_
#define SPH_BACKGROUND_H_

cpl_frameset*
sph_background_apply_to_raw_cubes(
		cpl_frameset* flat_frames, cpl_frameset* dark_frames);

cpl_frame*
sph_background_choose_bg_frame_frame(
		cpl_frameset* bg_frames,
		cpl_frame* raw_frame );

cpl_frame*
sph_background_subtract_background( cpl_frame* raw_frame, cpl_frame* bg_frame );

cpl_frame*
sph_background_choose_bg_frame_dit(
		cpl_frameset* bg_frames,
		double dit );

double
sph_background_get_dit( cpl_frame* aframe );

#endif /* SPH_BACKGOUND_H_ */
