/* $Id: $
 * This file is part of the SPHERE Pipeline
 * Copyright (C) 2007-2010 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: $
 * $Date: $
 * $Revision: $
 * $Name: $
 */
#ifndef SPH_DATASET_PEAK_H_
#define SPH_DATASET_PEAK_H_

#include "sph_dataset.h"


typedef struct _sph_dataset_peak_ 
{
    sph_dataset*        dat;
    struct _sph_dataset_peak_*   next;
    struct _sph_dataset_peak_*   prev;
    struct _sph_dataset_peak_*   parent;
    struct _sph_dataset_peak_*   firstchild;
    
    int                minpixels;
    
    float              maxpos;
    float              meanval;
    float              meanpos;
    float              medianval;
    float              totval;
    
    float              frac_threshold;
    float              frac_acc;
    
} sph_dataset_peak;


sph_dataset_peak*
sph_dataset_peak_new_root( sph_dataset* dat );

sph_dataset_peak*
sph_dataset_peak_new_sub( sph_dataset_peak* parent, double fthresh );

int 
sph_dataset_peak_find_subpeaks( sph_dataset_peak* self );

int 
sph_dataset_peak_delete( sph_dataset_peak* self );

int 
sph_dataset_peak_get_number_subpeaks( sph_dataset_peak* self );

#endif /*SPH_DATASET_PEAK_H_*/
