/* $Id: $
 * This file is part of the SPHERE Pipeline
 * Copyright (C) 2007-2010 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: $
 * $Date: $
 * $Revision: $
 * $Name: $
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

/*-----------------------------------------------------------------------------
 Includes
 -----------------------------------------------------------------------------*/
#include <cpl.h>
#include "sph_error.h"
#ifndef SPH_DIFFERENTIAL_IMAGING_H_
#define SPH_DIFFERENTIAL_IMAGING_H_
#include "sph_fft.h"
#include "sph_ird_instrument_model.h"
#include "sph_framecombination.h"

typedef struct sph_differential_imaging____ {
    sph_fft*        fft;
    cpl_frameset*   rawframes;
    int             ditherf; // flag if de-dithering needed
    int             scalef; // flag if scaling (SDI) needed
    int             rotatef; //flag if rotation (ADI) needed
    sph_master_frame*   dark;
    sph_master_frame*   flat;
    sph_distortion_model* distmap;
    cpl_image*          leftbpix;
    cpl_image*          rightbpix;
    cpl_image*          leftimage;
    cpl_image*          rightimage;
    double              dx;
    double              dy;
    double              scale;
    double              angle;
    cpl_frame*          current_frame;
    int                 nplanes;
    int                 currentplane;
    int                 iscube;
    int                 extension;
} sph_differential_imaging;

cpl_frameset*
sph_differential_imaging_calculate_speckles(
        const cpl_frameset* all_frames, int maxframes,
        sph_collapse_algorithm coll_alg,
        cpl_array** assoc_array)
    CPL_ATTR_ALLOC;

sph_differential_imaging*
sph_differential_imaging_new(cpl_frameset* rawframes)
    CPL_ATTR_ALLOC;
void
sph_differential_imaging_delete( sph_differential_imaging* self );
sph_error_code
sph_differential_imaging_set_flags( sph_differential_imaging* self,
        int ditherin, int scalein, int rotatein);
sph_error_code
sph_differential_imaging_set_transforms( sph_differential_imaging* self,
        double dx, double dy, double scale, double angle);
sph_error_code
sph_differential_imaging_set_dither( sph_differential_imaging* self,
        double dx, double dy) ;
sph_error_code
sph_differential_imaging_set_scale( sph_differential_imaging* self,
        double scale) ;
sph_error_code
sph_differential_imaging_set_angle( sph_differential_imaging* self,
        double angle) ;
sph_master_frame*
sph_differential_imaging_get_next_calibrated_raw_master(
        sph_differential_imaging* self)
    CPL_ATTR_ALLOC;

sph_error_code
sph_differential_imaging_set_calibrations( sph_differential_imaging* self,
        sph_master_frame* dark, sph_master_frame* flat,
        sph_distortion_model* distmap) ;

cpl_image*
sph_differential_imaging_get_next_raw(sph_differential_imaging* self)
    CPL_ATTR_ALLOC;

cpl_image*
sph_differential_imaging_get_next_calibrated_raw(
        sph_differential_imaging* self,
        cpl_image** bpixmap, cpl_image** wmap)
    CPL_ATTR_ALLOC;

sph_error_code
sph_differential_imaging_set_left_image( sph_differential_imaging* self,
        cpl_image* leftframe, cpl_image* leftbadpix);
sph_error_code
sph_differential_imaging_set_right_image( sph_differential_imaging* self,
        cpl_image* rightframe, cpl_image* rightbadpix);

sph_error_code
sph_differential_imaging_set_extension( sph_differential_imaging* self,
        unsigned int extn);

#endif /* SPH_DIFFERENTIAL_IMAGING_H_ */
