/* $Id: $
 * This file is part of the SPHERE Pipeline
 * Copyright (C) 2007-2010 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: $
 * $Date: $
 * $Revision: $
 * $Name: $
 */

#ifndef SPH_FITTING_H_
#define SPH_FITTING_H_

/*-----------------------------------------------------------------------------
 Includes
 -----------------------------------------------------------------------------*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "sph_error.h"

#include <cpl.h>

#include <gsl/gsl_multifit_nlin.h>
#include <gsl/gsl_roots.h>


typedef struct sph_fitting_fit_robust_params__ {
    int     n;
    double* xdata;
    double* ydata;
    double  median;
} _sph_fitting_fit_robust_params;

typedef struct sph_fitting_fit_robust_ws____ {
    gsl_root_fsolver *s;
    gsl_function F;
    _sph_fitting_fit_robust_params params;
    double errest;


} _sph_fitting_fit_robust_ws_;

int sph_fitting_lm_dero(size_t n, double* r, double* y, double* sigma_y,
                        double* init, cpl_vector* fit, cpl_vector* fiterr);

int sph_fitting_fit_gauss2D(const cpl_image* im,
                            const cpl_image* im_err,
                            double* xpos, double* ypos,
                            double *xwidth, double * ywidth,
                            double boxfactor,
                            double boxborder);

int sph_fitting_fit_gauss2D_all(const cpl_image* im,
                                const cpl_image* im_err,
                                cpl_array * ar_fit,
                                const cpl_array * do_fit,
                                double boxfactor,
                                double boxborder);

cpl_polynomial*
sph_fitting_fit_poly1d( cpl_vector* xvals,
        cpl_vector* yvals,
        cpl_vector* err,
        int mind,
        int maxdeg,
        int allowshift, double guess, double* chisq)
    CPL_ATTR_ALLOC;

cpl_polynomial*
sph_fitting_fit_poly2d(const cpl_vector* xvals, const cpl_vector* yvals,
                       const cpl_vector* zvals, double* chisq,
                       int maxdeg1, int maxdeg2)
    CPL_ATTR_ALLOC;

cpl_error_code sph_fitting_fit_poly2d_1(cpl_polynomial* self,
                                        const cpl_matrix* xypos,
                                        const cpl_vector* zvals,
                                        double* chisq,
                                        cpl_size mindeg,
                                        cpl_size maxdeg);

cpl_image*
sph_fitting_fit_robust_imlist(cpl_imagelist* imlist,
                              cpl_vector* xvals,
                              double x_lo,
                              double x_hi,
                              cpl_image** offset,
                              cpl_image* errimage)
    CPL_ATTR_ALLOC;


double
sph_fitting_fit_robust(
        cpl_vector* xvals,
        cpl_vector* yvals,
        double x_lo,
        double x_i,
        double* offset);

cpl_vector*
sph_fitting_estimate_error(cpl_polynomial* poly,
                           cpl_vector* xvals,
                           cpl_vector* yvals,
                           cpl_vector* err,
                           cpl_vector** means_o)
    CPL_ATTR_ALLOC;

#endif /* SPH_FITTING_H_ */
