/* $Id: $
 * This file is part of the SPHERE Pipeline
 * Copyright (C) 2007-2010 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: $
 * $Date: $
 * $Revision: $
 * $Name: $
 */
#ifndef SPH_FRAMELIST_H_
#define SPH_FRAMELIST_H_

#include "sph_error.h"
#include <cpl.h>

enum sph_framelist_criteria {
    CONSTANT_LAMBDA     = 1,
    CONSTANT_TEXP       = 2,
    CONSTANT_OFFSETX    = 3,
    CONSTANT_OFFSETY    = 4
};

typedef struct _sph_framelist_
{
    cpl_frameset**  framesets;
    double*         values;
    int             nsets;
} sph_framelist;

extern const int SPH_FRAMELIST_LAMDA_TOLERANCE;
extern const int SPH_FRAMELIST_MAX_SETS;

extern sph_error_code SPH_FRAMELIST_FRAMES_GENERAL;
extern sph_error_code SPH_FRAMELIST_FRAMES_MISSING;
extern sph_error_code SPH_FRAMELIST_SET_OUT_OF_BOUNDS;
extern sph_error_code SPH_FRAMELIST_NO_VALID_DITS;

sph_framelist* sph_framelist_new(void);

sph_framelist* sph_framelist_create( cpl_frameset* inframes, 
                                     const char* czKeyword,
                                     double tolerance
                                    );

cpl_image*  sph_framelist_create_cpl_image( sph_framelist* self, 
                                            int set, 
                                            int frameno,
                                            cpl_type type,
                                            int plane,
                                            int extension);

sph_framelist* sph_framelist_create_from_dit( cpl_frameset* inframes, 
                                              cpl_frame* dit_frame );

sph_framelist* 
sph_framelist_create_from_mean( cpl_frameset* inframes, 
                                double tolerance, 
                                cpl_mask* badpix,
                                cpl_vector* means );
sph_framelist* sph_framelist_create_from_dither( cpl_frameset* inframes, const char* keyx, const char* keyy )
               CPL_ATTR_ALLOC;
cpl_frameset* sph_framelist_get_by_value( sph_framelist* self, double value, double tolerance );

//sph_error_code sph_framelist_subtract_dark( sph_framelist* self, sph_cube* dark );

void sph_framelist_delete( sph_framelist* self);

#endif /*SPH_FRAMELIST_H_*/
