/* $Id: $
 * This file is part of the SPHERE Pipeline
 * Copyright (C) 2007-2010 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: $
 * $Date: $
 * $Revision: $
 * $Name: $
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

/*-----------------------------------------------------------------------------
 Includes
 -----------------------------------------------------------------------------*/
#include <cpl.h>
#include "sph_error.h"
#ifndef SPH_LOCI_H_
#define SPH_LOCI_H_
#include "sph_loci_subsection.h"

typedef enum _sph_loci_division_scheme_ {
    SPH_LOCI_NORMAL,
    SPH_LOCI_FINE
} sph_loci_div_scheme;

typedef struct _sph_loci_ {
    sph_loci_subsection**   subsections;
    double      ndelta;
    double      Na;
    double      g;
    double      dr;
    double      W;
    double      maxR;
    double      minR;
    double      cx;
    double      cy;
    int         nbads;
    cpl_vector* rings_radii;
    cpl_vector* rings_max_indices;
    cpl_vector* rings_min_indices;
    int         nsubsections;
    cpl_frameset*       frameset;
    int         loaded_subsect_minindex;
    int         loaded_subsect_maxindex;
} sph_loci;


sph_loci*
sph_loci_new_empty(void);
sph_error_code
sph_loci_draw_subsections(sph_loci* self, cpl_image* image);
int sph_loci_get_number_sections( sph_loci* self );

int sph_loci_load_new_subsection_set( sph_loci* self );

cpl_vector* sph_loci_calculate_weights( sph_loci* self,
        int subsection, int target_id,
        cpl_vector* angles_start,
        cpl_vector* angles_stop);

cpl_image* sph_loci_calculate_ref_image( sph_loci* self,
        int subsection,  cpl_vector* weights );

sph_error_code
sph_loci_set_frameset(sph_loci* self,cpl_frameset* frameset);

cpl_vector*
sph_loci_calculate_radial_profile( cpl_image* image,
        double cx, double cy, cpl_vector* dist_vals);

sph_error_code
sph_loci_subtract_radial_profile(cpl_image* image,
        double cx, double cy,
        cpl_vector* dist_vals, cpl_vector* yvals);
sph_loci*
sph_loci_new(double Na, double W, double ndelta,
        double cx, double cy, double g, double minR, double maxR);

cpl_vector*
sph_loci_get_valid_set(sph_loci* self,
        int subsectid,
        int targetid,
        cpl_vector* angles_start,
        cpl_vector* angles_stop);

sph_error_code
sph_loci_init_subsections(sph_loci* self,double dr,sph_loci_div_scheme scheme);
cpl_imagelist* sph_loci_calculate_imagelist( sph_loci* self,
        int subsection,
        cpl_vector* angles_start,
        cpl_vector* angles_stop);


cpl_image*
sph_loci_process_single(sph_loci* self,
        int         targetid,
        int         nx,
        int         ny,
        cpl_vector* angles_start,
        cpl_vector* angles_stop);

void
sph_loci_delete(sph_loci* self);


#endif /* SPH_LOCI_H_ */
