/* $Id: $
 * This file is part of the SPHERE Pipeline
 * Copyright (C) 2007-2010 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: $
 * $Date: $
 * $Revision: $
 * $Name: $
 */


#ifndef SPH_PIXEL_POLYFIT_H_
#define SPH_PIXEL_POLYFIT_H_

/*-----------------------------------------------------------------------------
                                   Includes
 -----------------------------------------------------------------------------*/

#include <cpl.h>

/*-----------------------------------------------------------------------------
                                   New types
 -----------------------------------------------------------------------------*/

typedef struct _sph_pixel_polyfit_
{
    cpl_size                nx;  /* number pixel x */
    cpl_size                ny;  /* number pixel y */
    int                     order; /* Order of the polynomial fit */
    cpl_imagelist*          fit;   /* The fitted coefficients */
    cpl_image*              error; /* The error image, or NULL */
    const double**          pfit;  /* Direct access to fit */
    const cpl_binary**      pbpm;  /* Direct access to bpm of fit */
} sph_pixel_polyfit;

/*-----------------------------------------------------------------------------
                              Function prototypes
 -----------------------------------------------------------------------------*/

sph_pixel_polyfit* sph_pixel_polyfit_wrap(cpl_imagelist*, cpl_image*)
    CPL_ATTR_ALLOC;

void sph_pixel_polyfit_delete(sph_pixel_polyfit*);

#endif /*SPH_PIXEL_POLYFIT_H_*/
