/* $Id: $
 * This file is part of the SPHERE Pipeline
 * Copyright (C) 2007-2010 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: $
 * $Date: $
 * $Revision: $
 * $Name: $
 */


#ifndef SPH_PIXEL_POLYFIT_TABLE_H_
#define SPH_PIXEL_POLYFIT_TABLE_H_

#include "sph_error.h"
#include "sph_master_frame.h"
#include <cpl.h>

typedef struct _sph_pixel_polyfit_table_
{
    int                     nx;  // number pixel x
    int                     ny;  // number pixel y
    int                     order; // Order of the polynomials used for fitting
    cpl_table*              table; // The table storing fit parameters
} sph_pixel_polyfit_table;

sph_pixel_polyfit_table*
sph_pixel_polyfit_table_new(int nx, int ny, int order)
    CPL_ATTR_ALLOC;
sph_pixel_polyfit_table*
sph_pixel_polyfit_table_new_from_imlist(const cpl_imagelist* imlist,
                                        const cpl_image*     errimage)
    CPL_ATTR_ALLOC;
void
sph_pixel_polyfit_table_delete( sph_pixel_polyfit_table* self );

cpl_polynomial*
sph_pixel_polyfit_table_get( const sph_pixel_polyfit_table* self,
                             int nx, int ny,
                             double* mse )
    CPL_ATTR_ALLOC;

cpl_error_code
sph_pixel_polyfit_table_set(sph_pixel_polyfit_table* self,
                            int nx, int ny,
                            double mse, cpl_polynomial* poly );

sph_pixel_polyfit_table*
sph_pixel_polyfit_table_load(  const char* fitsfilename )
    CPL_ATTR_ALLOC;

cpl_error_code
sph_pixel_polyfit_table_save(const sph_pixel_polyfit_table* self,
                             const char* fitsfilename);
cpl_error_code
sph_pixel_polyfit_table_save_cube(const sph_pixel_polyfit_table* self,
                                  const char* fitsfilename);

cpl_error_code
sph_pixel_polyfit_table_set_invalid(sph_pixel_polyfit_table* self,
                            int nx, int ny );

sph_master_frame*
sph_pixel_polyfit_table_get_coeff_as_image( const sph_pixel_polyfit_table* self,
                                            int order )
    CPL_ATTR_ALLOC;

cpl_mask*
sph_pixel_polyfit_table_create_badpixel_mask( const sph_pixel_polyfit_table* self,
                                              double badpix_lowtolerance,
                                              double badpix_uptolerance,
                                              double badpix_chisqtolerance)
    CPL_ATTR_ALLOC;

#endif /*SPH_PIXEL_POLYFIT_TABLE_H_*/
