/* $Id: $
 * This file is part of the SPHERE Pipeline
 * Copyright (C) 2007-2010 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: $
 * $Date: $
 * $Revision: $
 * $Name: $
 */
#ifndef SPH_SMART_IMAGELIST_H_
#define SPH_SMART_IMAGELIST_H_

#include <cpl.h>
#include "sph_master_frame.h"
#include "sph_cube.h"
typedef struct _sph_detector_region
{
    int                     ll_x;
    int                     ll_y;
    int                     ur_x;
    int                     ur_y;
} sph_detector_region;

typedef struct _sph_smart_imagelist
{
    int                     nx ;        /* Image size in x */
    int                     ny ;        /* Image size in y */    
    int                     nregions;
    int                     cubemode;   /* Raw frames are cubes */
    sph_detector_region*    regions;    /* array of regions */
    const cpl_frameset*     frameset;   /* Frameset to use */
    sph_cube*               cube;       /* cube to use */
    const cpl_frame*        manyplaneframe;       /* frame with many planes */
    int                     extension;
    long int                maxmem;
} sph_smart_imagelist;

extern const int SPH_SMART_IMAGELIST_MAX_IMAGES;
extern const long long int SPH_MAX_MEMORY_FOR_FRAMES;

sph_smart_imagelist* sph_smart_imagelist_new(void)
    CPL_ATTR_ALLOC;

sph_smart_imagelist* sph_smart_imagelist_create(const cpl_frameset* inframes,
                                                unsigned int extension )
    CPL_ATTR_ALLOC;

sph_error_code sph_smart_imagelist_get_raw_median_properties( sph_smart_imagelist* self,
        cpl_propertylist* pl);

cpl_imagelist*  sph_smart_imagelist_get_set(sph_smart_imagelist*, int)
    CPL_ATTR_ALLOC;

cpl_imagelist*  sph_smart_imagelist_get_set_cube( sph_smart_imagelist* self, 
                                            int set)
    CPL_ATTR_ALLOC;
cpl_imagelist*  sph_smart_imagelist_get_set_manyplanes(const sph_smart_imagelist*,
                                                       int)
    CPL_ATTR_ALLOC;

sph_master_frame*
sph_smart_imagelist_reassemble_master_frame( const sph_smart_imagelist* self, 
                                             sph_master_frame** image_arr)
    CPL_ATTR_ALLOC;
sph_smart_imagelist* sph_smart_imagelist_create_cube( sph_smart_imagelist* self, 
                                                      sph_cube* incube, int extension );
sph_smart_imagelist* sph_smart_imagelist_create_manyplanes( sph_smart_imagelist* self, cpl_frame* inframe, int extension );
int sph_smart_imagelist_delete( sph_smart_imagelist* self);


#endif /*SPH_SMART_IMAGELIST_H_*/
