/* $Id: $
 * This file is part of the SPHERE Pipeline
 * Copyright (C) 2007-2010 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef SPH_UTILS_H_
#define SPH_UTILS_H_

#include "sph_error.h"
#include "sph_double_image.h"

#include <cpl.h>

// Keyword that defines an exposure from a single frame
// (i.e. no PI phase images)
#define SPH_ZPL_KEYWORD_SINGLE                  "ESO DRS ZPL SINGLE"

sph_error_code
sph_init(void);
sph_error_code
sph_init_erex(void);

sph_error_code
sph_init_debug(void);

sph_error_code
sph_init_debug_verbose(void);

sph_error_code
sph_end(void);
sph_error_code
sph_end_erex(void);

const char* sph_get_license( void );

cpl_frameset*
sph_utils_extract_frames( const cpl_frameset* frameset, const char* tag )
    CPL_ATTR_ALLOC;

cpl_propertylist*
sph_utils_create_calib_propertylist( void )
    CPL_ATTR_ALLOC;

cpl_frame*
sph_utils_create_calib_frame( const char* outframename, cpl_frame_type frametype,
                              cpl_frame_level framelevel, cpl_frameset* inframes,
                              const cpl_parameterlist* parlist, const char* prod_tag,
                              const char* recid, const char* pipelineid, cpl_frame* inherit_frame )
    CPL_ATTR_ALLOC;
int
sph_utils_get_dit_id( const cpl_frame* inframe, const cpl_frame* dit_list );

cpl_frame*
sph_utils_create_default_dit_list( const char* fname )
    CPL_ATTR_ALLOC;

cpl_frame*
sph_utils_extract_frame( const cpl_frameset* frameset, const char* tag )
    CPL_ATTR_ALLOC;

cpl_frameset*
sph_utils_create_master_frameset( const cpl_frameset* inframes )
    CPL_ATTR_ALLOC;

double
sph_utils_get_exposure_time( const cpl_frame* inframe );

int
sph_utils_check_exposure_times_are_same( const cpl_frameset* inframes );

sph_error_code
sph_utils_append_to_propertynames( cpl_propertylist* proplist,
        const char* postfix);

void
sph_utils_update_header(cpl_propertylist* plist);

sph_error_code
sph_utils_simple_copy_singular(const cpl_propertylist* pin,
                               cpl_propertylist* pout);

sph_error_code
sph_utils_get_exptime_from_raw( cpl_frameset* rawframes, cpl_propertylist* pout);


cpl_frameset*
sph_utils_extract_frames_group( cpl_frameset* frameset, cpl_frame_group group );


int
sph_utils_get_dither_id( const cpl_frame* inframe, float res, const char* keyx, const char* keyy );

int
sph_utils_get_dit_id_from_cpl_table( const cpl_frame* inframe, const cpl_table* dit_table );


void sph_utils_lowercase( char string[] );

void sph_utils_uppercase( char string[] );

sph_error_code
sph_utils_frames_unlink( const cpl_frameset* self );

sph_error_code sph_utils_copy_frames( const cpl_frameset* inframes, cpl_frameset* framesout );

sph_error_code
sph_utils_attach_plist( cpl_propertylist* plist, cpl_frame* frame, int ext );

sph_error_code
sph_utils_cpl_image_fill_double( cpl_image* image, double value );

sph_error_code
sph_utils_delete_files( cpl_frameset* inframes );

cpl_propertylist*
sph_utils_astrometry_create_wcs_pl( double ra,  double dec,
                                    double xpix, double ypix,
                                    double xscale, double yscale)
    CPL_ATTR_ALLOC;

cpl_error_code sph_utils_remove_wcs_3d(cpl_propertylist* self);
cpl_error_code sph_utils_reset_wcs_12d(cpl_propertylist* self);

int sph_utils_is_single_frame(cpl_propertylist* pl);
int sph_utils_set_single_frame(cpl_propertylist* pl);

#endif /*SPH_UTILS_H_*/
