/* $Id: $
 * This file is part of the SPHERE Pipeline
 * Copyright (C) 2007-2010 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: $
 * $Date: $
 * $Revision: $
 * $Name: $
 */

#ifndef SPH_XTALK_H_
#define SPH_XTALK_H_

/*-----------------------------------------------------------------------------
 Includes
 -----------------------------------------------------------------------------*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "sph_error.h"
#include <cpl.h>

typedef struct _sph_xtalk_ {
    int              npreamps;
    cpl_image*       preamp_image;
    cpl_image*      derivim;
    cpl_image*      coeffs;

} sph_xtalk;

sph_xtalk*
sph_xtalk_new( int npreamps ) CPL_ATTR_ALLOC;

sph_xtalk*
sph_xtalk_load_pattern( const char* filename ) CPL_ATTR_ALLOC;

cpl_image*
sph_xtalk_apply( sph_xtalk* self, const cpl_image* imin ) CPL_ATTR_ALLOC;


sph_error_code
sph_xtalk_apply_frameset(
        sph_xtalk* self,
        const cpl_frameset* rawframes,
        cpl_frameset* outframes);

void
sph_xtalk_delete(sph_xtalk* self);

#endif /* SPH_XTALK_H_ */
