/* $Id: $
 * This file is part of the SPHERE Pipeline
 * Copyright (C) 2007-2010 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: $
 * $Date: $
 * $Revision: $
 * $Name: $
 */
/*-----------------------------------------------------------------------------
 Includes
 -----------------------------------------------------------------------------*/
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <cpl.h>
#include "sph_error.h"


#ifndef SPH_ZPL_EXPOSURE_H_
#define SPH_ZPL_EXPOSURE_H_

//Binary Table, Column Names
#define ADU1_ZERO_OVSC_MEAN 				"ADU1 ZERO PHASE OVSC MEAN"
#define ADU1_ZERO_OVSC_RMS	 				"ADU1 ZERO PHASE OVSC RMS"
#define ADU2_ZERO_OVSC_MEAN         		"ADU2 ZERO PHASE OVSC MEAN"
#define ADU2_ZERO_OVSC_RMS				    "ADU2 ZERO PHASE OVSC RMS"
#define ADU1_PI_OVSC_MEAN					"ADU1 PI PHASE OVSC MEAN"
#define ADU1_PI_OVSC_RMS					"ADU1 PI PHASE OVSC RMS"
#define ADU2_PI_OVSC_MEAN					"ADU2 PI PHASE OVSC MEAN"
#define ADU2_PI_OVSC_RMS					"ADU2 PI PHASE OVSC RMS"
#define OVSC_SIZE							8
/*-----------------------------------------------------------------------------
 Type definition
 -----------------------------------------------------------------------------*/
typedef struct _sph_zpl_exposure_
{
    cpl_propertylist* properties;
    cpl_image* image_zero_odd;
    cpl_image* image_zero_even;
    cpl_image* image_pi_odd;
    cpl_image* image_pi_even;
    cpl_propertylist* ovsc;
} sph_zpl_exposure;


sph_zpl_exposure* sph_zpl_exposure_new_empty(void)  CPL_ATTR_ALLOC;

sph_zpl_exposure* sph_zpl_exposure_new( int nx, int ny )  CPL_ATTR_ALLOC;

sph_zpl_exposure* sph_zpl_exposure_new_from_cplimages( cpl_image* image_zero_odd, cpl_image* image_zero_even,
		                                      cpl_image* image_pi_odd, cpl_image* image_pi_even )  CPL_ATTR_ALLOC;

sph_zpl_exposure* sph_zpl_exposure_duplicate( sph_zpl_exposure* self)  CPL_ATTR_ALLOC;

sph_error_code sph_zpl_exposure_save( sph_zpl_exposure* self, cpl_frame* outframe, cpl_propertylist* pl);

sph_error_code
sph_zpl_exposure_save_open( sph_zpl_exposure* self, cpl_frame* outframe,
		cpl_propertylist* pli, cpl_table* ovsc_table);

sph_error_code
sph_zpl_exposure_save_append( sph_zpl_exposure* self, cpl_frame* outframe, cpl_table* ovsc_table);

sph_error_code
sph_zpl_exposure_finalize_file( cpl_frame* outframe, cpl_table* ovsc_table);

cpl_table*
sph_zpl_exposure_ovsc_table_create_empty( void );

sph_error_code
sph_zpl_exposure_ovsc_table_add_raw( sph_zpl_exposure* self, cpl_table* ovsc_table );

sph_error_code
sph_zpl_exposure_subtract_overscans( sph_zpl_exposure* self );

sph_error_code
sph_zpl_exposure_save_ovsc( cpl_frame* outframe, cpl_table* ovsc_table);



sph_error_code
sph_zpl_exposure_save_dfs(
		sph_zpl_exposure* self,
        const char* outfilename,
        cpl_frameset* allframes,
        cpl_frame* template_frame,
        cpl_parameterlist* params,
        const char* tag,
        const char* recipe,
        const char* pipename,
        cpl_propertylist* pl);

sph_zpl_exposure* sph_zpl_exposure_load( const cpl_frame* inframe, int iplane )
    CPL_ATTR_ALLOC;

void sph_zpl_exposure_delete( sph_zpl_exposure* self);

#endif /* SPH_ZPL_EXPOSURE_H_ */
