/* $Id: $
 * This file is part of the SPHERE Pipeline
 * Copyright (C) 2007-2010 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: $
 * $Date: $
 * $Revision: $
 * $Name: $
 */

#ifndef SPH_TEST_IMAGE_TOOLS_H_
#define SPH_TEST_IMAGE_TOOLS_H_
#include "sph_error.h"
#include <cpl.h>
#include <gsl/gsl_rng.h>
#include <gsl/gsl_randist.h>

cpl_image*
sph_test_image_tools_create_flat_image_int(int nx, int ny, int value)
  CPL_ATTR_ALLOC;

cpl_image*
sph_test_image_tools_create_flat_image_double(int nx, int ny, double value)
  CPL_ATTR_ALLOC;

int
sph_test_image_tools_add_noise(cpl_image* inimage, double noise_sigma,
        gsl_rng* pRNG);
int
sph_test_image_tools_apply_poisson_noise(cpl_image* inimage, gsl_rng* pRNG);
int
sph_test_image_tools_add_speckle(cpl_image* inimage, double xpos, double ypos,
        double size, double value);
sph_error_code
sph_test_image_tools_add_gradient_x(cpl_image* im, double min, double max);
sph_error_code
sph_test_image_tools_add_gradient_y(cpl_image* im, double min, double max);
sph_error_code
sph_test_image_tools_multiply_gradient_x(cpl_image* im, double min, double max);
sph_error_code
sph_test_image_tools_multiply_gradient_y(cpl_image* im, double min, double max);
int
sph_test_image_tools_add_gauss(cpl_image* inimage, double dxpos, double dypos,
        double psize, double value);
cpl_error_code
sph_test_image_tools_add_badpixles(cpl_image* self, int nbads, gsl_rng* pRNG);
cpl_error_code
sph_test_image_tools_add_deadpixels(cpl_image* self, int nbads,
        gsl_rng* pRNG);
cpl_error_code
sph_test_image_tools_add_hotpixels(cpl_image* self, int nbads, double hotval,
                                   gsl_rng* pRNG);

cpl_error_code
sph_test_image_tools_add_crazypixels(cpl_image* self, int nbads, double hotval,
        gsl_rng* pRNG);

cpl_image*
sph_test_image_tools_create_striped_image(int nx, int ny, int nstripes,
        cpl_type type, double minvalue, double maxvalue)
  CPL_ATTR_ALLOC;

int
sph_test_image_tools_add_in_window(cpl_image* inimage, int minx, int miny,
        int maxx, int maxy, double val);

cpl_image*
sph_test_image_tools_create_grid_image(int nx, int ny, int npx, int npy,
        cpl_type type, double maxvalue, double psize)
  CPL_ATTR_ALLOC;

sph_error_code
sph_test_image_tools_save_image_as_new_cube(cpl_image* im, const char* filename,
        cpl_type_bpp BPP, cpl_propertylist* pl, unsigned int mode);
int
sph_test_image_tools_validate_images_are_same(cpl_image* imA, cpl_image* imB,
        double maxdiff);
#endif /* SPH_TEST_IMAGE_TOOLS_H_ */
