/* $Id: $
 * This file is part of the SPHERE Pipeline
 * Copyright (C) 2007-2010 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: $
 * $Date: $
 * $Revision: $
 * $Name: $
 */

/*-----------------------------------------------------------------------------
 Includes
 -----------------------------------------------------------------------------*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "sph_ifs_tags.h"
#include "sph_error.h"
#include "sph_test.h"
#include "sph_test_ngc_ir_simulator.h"
#include "sph_test_pupilimage_creator.h"
#include "sph_test_image_tools.h"
#include "sph_utils.h"
#include "sph_common_keywords.h"
#include "sph_crosstalkco.h"

#include <math.h>

/*----------------------------------------------------------------------------*/
/**
 * @defgroup A CUnit Test Suite -- representing a collection of testcases
 * @par Synopsis:
 * @code
 * @endcode
 * @par Desciption:
 *
 * This module provides a collection of tests for one specific, distinct
 * module or set-up. The testing code is implemented using the CUnit
 * framework.
 */
/*----------------------------------------------------------------------------*/
/**@{*/


/*----------------------------------------------------------------------------*/
/*-                            INTERNAL HELPER FUNCTIONS                      */
/*----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/**
 @brief    Function to initiailise the unit test suite
 */
/*----------------------------------------------------------------------------*/
static
int cutest_sph_crosstalkco_init_testsuite(void) {
    /*--------------------------------------------------------------------
     * -    Prepare CPL and error logging
     * -------------------------------------------------------------------*/
    return sph_test_nop_code();
}

/*----------------------------------------------------------------------------*/
/**
 @brief    Function to clean the unit test suite
 */
/*----------------------------------------------------------------------------*/
static
int cutest_sph_crosstalkco_clean_testsuite(void) {
    return sph_end_test();
}

/*----------------------------------------------------------------------------*/
/**
 @brief        A test function of the testsuite
 */
/*----------------------------------------------------------------------------*/
static
void cutest_sph_crosstalkco_apply_to_raw_cubes(void) {
	cpl_frameset* allframes = cpl_frameset_new();
        cpl_frame* aframe;
	cpl_imagelist* imlist = cpl_imagelist_new();

	cpl_image* image =
            sph_test_image_tools_create_striped_image(512, 512, 10,
                                                      CPL_TYPE_DOUBLE, 0.0,
                                                      1000.0);

	cpl_image_turn(image,1);
	sph_test_image_tools_add_gradient_x(image,0.0,5000.0);
	sph_test_image_tools_add_gradient_y(image,0.0,5000.0);
	//sph_test_image_tools_add_crazypixels(image,1000000,1.0e10,NULL);

	aframe = sph_test_cubify_image(image,"IFS RAW",CPL_FRAME_GROUP_RAW);

	cpl_frameset_insert(allframes,aframe);

	sph_crosstalkco_apply_to_raw_cube(allframes, aframe, 20, 0.727986/1.8,
                                          3.0, 64, 50000.0, 100.0, 10.0);

	cpl_image_delete(image);
	cpl_imagelist_delete(imlist);
	cpl_frameset_delete(allframes);
}

/*----------------------------------------------------------------------------*/
/**
 @brief    Unit test MAIN function
 */
/*----------------------------------------------------------------------------*/
int main(void) {
    const void* pSuite = NULL;


    if ( 0 != sph_test_init())
        return sph_test_get_error();


    pSuite = sph_add_suite("Testing sph_badpixelco",
            cutest_sph_crosstalkco_init_testsuite,
            cutest_sph_crosstalkco_clean_testsuite);
    if (NULL == pSuite) {
        return sph_test_get_error();
    }


    if (NULL
            == sph_test_do(pSuite, "sph_crosstalkco_apply",
                    cutest_sph_crosstalkco_apply_to_raw_cubes)) {
        return sph_test_get_error();
    }
    return sph_test_end();
}

/**@}*/
